/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;

public class MapPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final String PUT_PREFIX = "put";
    private static final String PUT_ALL_PREFIX = "putAll";
    private static final String REMOVE_PREFIX = "remove";
    private static final String CLEAR_PREFIX = "clear";
    private static final String GET_PREFIX = "get";

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        if (!config.getProperty().getNullableAnnotations().isEmpty()) {
            return Optional.absent();
        }
        if (config.getProperty().getType().getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)config.getProperty().getType();
            if (Util.erasesToAnyOf(type, Map.class, ImmutableMap.class)) {
                TypeMirror keyType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
                TypeMirror valueType = Util.upperBound(config.getElements(), type.getTypeArguments().get(1));
                Optional<TypeMirror> unboxedKeyType = MapPropertyFactory.unboxed(config.getTypes(), keyType);
                Optional<TypeMirror> unboxedValueType = MapPropertyFactory.unboxed(config.getTypes(), valueType);
                return Optional.of(new CodeGenerator(config.getProperty(), keyType, unboxedKeyType, valueType, unboxedValueType));
            }
        }
        return Optional.absent();
    }

    private static Optional<TypeMirror> unboxed(Types types, TypeMirror elementType) {
        Optional<TypeMirror> unboxedType;
        try {
            unboxedType = Optional.of(types.unboxedType(elementType));
        }
        catch (IllegalArgumentException e) {
            unboxedType = Optional.absent();
        }
        return unboxedType;
    }

    private static class CodeGenerator
    extends PropertyCodeGenerator {
        private final TypeMirror keyType;
        private final Optional<TypeMirror> unboxedKeyType;
        private final TypeMirror valueType;
        private final Optional<TypeMirror> unboxedValueType;

        CodeGenerator(Metadata.Property property, TypeMirror keyType, Optional<TypeMirror> unboxedKeyType, TypeMirror valueType, Optional<TypeMirror> unboxedValueType) {
            super(property);
            this.keyType = keyType;
            this.unboxedKeyType = unboxedKeyType;
            this.valueType = valueType;
            this.unboxedValueType = unboxedValueType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.add("private final %1$s<%2$s, %3$s> %4$s = new %1$s<", LinkedHashMap.class, this.keyType, this.valueType, this.property.getName());
            if (!code.getSourceLevel().supportsDiamondOperator()) {
                code.add("%s, %s", this.keyType, this.valueType);
            }
            code.add(">();\n", new Object[0]);
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Associates {@code key} with {@code value} in the map to be returned from", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" * Duplicate keys are not allowed.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
                code.add(" * @throws NullPointerException if ", new Object[0]);
                if (this.unboxedKeyType.isPresent()) {
                    code.add("{@code value} is", new Object[0]);
                } else if (this.unboxedValueType.isPresent()) {
                    code.add("{@code key} is", new Object[0]);
                } else {
                    code.add("either {@code key} or {@code value} are", new Object[0]);
                }
                code.add(" null\n", new Object[0]);
            }
            code.addLine(" * @throws IllegalArgumentException if {@code key} is already present", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s%s(%s key, %s value) {", metadata.getBuilder(), MapPropertyFactory.PUT_PREFIX, this.property.getCapitalizedName(), this.unboxedKeyType.or(this.keyType), this.unboxedValueType.or(this.valueType));
            if (!this.unboxedKeyType.isPresent()) {
                code.addLine("  %s.checkNotNull(key);", Preconditions.class);
            }
            if (!this.unboxedValueType.isPresent()) {
                code.addLine("  %s.checkNotNull(value);", Preconditions.class);
            }
            code.addLine("  %s.checkArgument(!%s.containsKey(key),", Preconditions.class, this.property.getName()).addLine("      \"Key already present in %s: %%s\", key);", this.property.getName()).addLine("  this.%s.put(key, value);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Associates all of {@code map}'s keys and values in the map to be returned", new Object[0]).addLine(" * from {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" * Duplicate keys are not allowed.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code map} is null or contains a", new Object[0]).addLine(" *     null key or value", new Object[0]).addLine(" * @throws IllegalArgumentException if any key is already present", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s%s(%s<? extends %s, ? extends %s> map) {", metadata.getBuilder(), MapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName(), Map.class, this.keyType, this.valueType).addLine("  for (%s<? extends %s, ? extends %s> entry : map.entrySet()) {", Map.Entry.class, this.keyType, this.valueType).addLine("    %s%s(entry.getKey(), entry.getValue());", MapPropertyFactory.PUT_PREFIX, this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes the mapping for {@code key} from the map to be returned from", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedKeyType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code key} is null", new Object[0]);
            }
            code.addLine(" * @throws IllegalArgumentException if {@code key} is not present", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s%s(%s key) {", metadata.getBuilder(), MapPropertyFactory.REMOVE_PREFIX, this.property.getCapitalizedName(), this.unboxedKeyType.or(this.keyType), this.valueType);
            if (!this.unboxedKeyType.isPresent()) {
                code.addLine("  %s.checkNotNull(key);", Preconditions.class);
            }
            code.addLine("  %s.checkArgument(%s.containsKey(key),", Preconditions.class, this.property.getName()).addLine("      \"Key not present in %s: %%s\", key);", this.property.getName()).addLine("  %s.remove(key);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes all of the mappings from the map to be returned from ", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s%s() {", metadata.getBuilder(), MapPropertyFactory.CLEAR_PREFIX, this.property.getCapitalizedName()).addLine("  this.%s.clear();", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the map that will be returned by", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s, %s> %s%s() {", Map.class, this.keyType, this.valueType, MapPropertyFactory.GET_PREFIX, this.property.getCapitalizedName()).addLine("  return %s.unmodifiableMap(%s);", Collections.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.copyOf(%s.%s);", finalField, ImmutableMap.class, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s%s(%s.%s());", MapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName(), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s%s(((%s) %s).%s);", MapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName(), metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s%s(%s);", builder, MapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName(), variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return false;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%s.clear();", this.property.getName());
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            code.addLine("%s.clear();", this.property.getName());
        }
    }
}

