/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Metadata_Builder;
import org.inferred.freebuilder.processor.Metadata_Property_Builder;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.TypeReference;
import org.inferred.freebuilder.shaded.com.google.common.base.Function;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

public abstract class Metadata {
    public static final Function<Property, PropertyCodeGenerator> GET_CODE_GENERATOR = new Function<Property, PropertyCodeGenerator>(){

        @Override
        public PropertyCodeGenerator apply(Property input) {
            return input.getCodeGenerator();
        }
    };

    public PackageElement getPackage() {
        Element element = this.getType();
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    public abstract TypeElement getType();

    abstract Optional<TypeElement> getOptionalBuilder();

    public boolean hasBuilder() {
        return this.getOptionalBuilder().isPresent();
    }

    public TypeElement getBuilder() {
        return this.getOptionalBuilder().get();
    }

    public abstract Optional<BuilderFactory> getBuilderFactory();

    public abstract TypeReference getGeneratedBuilder();

    public abstract TypeReference getValueType();

    public abstract TypeReference getPartialType();

    public abstract ImmutableSet<TypeReference> getVisibleNestedTypes();

    public abstract TypeReference getPropertyEnum();

    public abstract ImmutableList<Property> getProperties();

    public UnderrideLevel standardMethodUnderride(StandardMethod standardMethod) {
        UnderrideLevel underrideLevel = this.getStandardMethodUnderrides().get((Object)standardMethod);
        return underrideLevel == null ? UnderrideLevel.ABSENT : underrideLevel;
    }

    public abstract ImmutableMap<StandardMethod, UnderrideLevel> getStandardMethodUnderrides();

    public abstract boolean isBuilderSerializable();

    public abstract boolean isGwtCompatible();

    public abstract boolean isGwtSerializable();

    public static class Builder
    extends Metadata_Builder {
        public Builder setBuilder(Optional<TypeElement> builder) {
            return this.setOptionalBuilder(builder);
        }

        public Builder setBuilder(TypeElement builder) {
            return this.setOptionalBuilder(builder);
        }

        @Override
        public Metadata build() {
            Metadata metadata = super.build();
            TypeReference generatedBuilder = metadata.getGeneratedBuilder();
            Preconditions.checkState(metadata.getValueType().getEnclosingType().equals(generatedBuilder), "%s not a nested class of %s", metadata.getValueType(), generatedBuilder);
            Preconditions.checkState(metadata.getPartialType().getEnclosingType().equals(generatedBuilder), "%s not a nested class of %s", metadata.getPartialType(), generatedBuilder);
            Preconditions.checkState(metadata.getPropertyEnum().getEnclosingType().equals(generatedBuilder), "%s not a nested class of %s", metadata.getPropertyEnum(), generatedBuilder);
            return metadata;
        }
    }

    public static interface Property {
        public TypeMirror getType();

        @Nullable
        public TypeMirror getBoxedType();

        public String getName();

        public String getCapitalizedName();

        public String getAllCapsName();

        public String getGetterName();

        @Nullable
        public PropertyCodeGenerator getCodeGenerator();

        public boolean isFullyCheckedCast();

        public ImmutableSet<TypeElement> getNullableAnnotations();

        public static class Builder
        extends Metadata_Property_Builder {
        }
    }

    public static enum UnderrideLevel {
        ABSENT,
        OVERRIDEABLE,
        FINAL;

    }

    public static enum StandardMethod {
        TO_STRING,
        HASH_CODE,
        EQUALS;

    }
}

