/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.TypeElement;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.util.TypeReference;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Joiner;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

abstract class Metadata_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on(", ").skipNulls();
    private BuilderFactory builderFactory = null;
    private TypeReference generatedBuilder;
    private TypeElement optionalBuilder = null;
    private TypeReference partialType;
    private ArrayList<Metadata.Property> properties = new ArrayList();
    private TypeReference propertyEnum;
    private LinkedHashMap<Metadata.StandardMethod, Metadata.UnderrideLevel> standardMethodUnderrides = new LinkedHashMap();
    private TypeElement type;
    private TypeReference valueType;
    private LinkedHashSet<TypeReference> visibleNestedTypes = new LinkedHashSet();
    private boolean builderSerializable;
    private boolean gwtCompatible;
    private boolean gwtSerializable;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Metadata_Builder() {
    }

    public Metadata.Builder setBuilderFactory(BuilderFactory builderFactory) {
        this.builderFactory = Preconditions.checkNotNull(builderFactory);
        return (Metadata.Builder)this;
    }

    public Metadata.Builder setBuilderFactory(Optional<? extends BuilderFactory> builderFactory) {
        if (builderFactory.isPresent()) {
            return this.setBuilderFactory(builderFactory.get());
        }
        return this.clearBuilderFactory();
    }

    public Metadata.Builder setNullableBuilderFactory(@Nullable BuilderFactory builderFactory) {
        if (builderFactory != null) {
            return this.setBuilderFactory(builderFactory);
        }
        return this.clearBuilderFactory();
    }

    public Metadata.Builder clearBuilderFactory() {
        this.builderFactory = null;
        return (Metadata.Builder)this;
    }

    public Optional<BuilderFactory> getBuilderFactory() {
        return Optional.fromNullable(this.builderFactory);
    }

    public Metadata.Builder setGeneratedBuilder(TypeReference generatedBuilder) {
        this.generatedBuilder = Preconditions.checkNotNull(generatedBuilder);
        this._unsetProperties.remove((Object)Property.GENERATED_BUILDER);
        return (Metadata.Builder)this;
    }

    public TypeReference getGeneratedBuilder() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.GENERATED_BUILDER), "generatedBuilder not set");
        return this.generatedBuilder;
    }

    public Metadata.Builder setOptionalBuilder(TypeElement optionalBuilder) {
        this.optionalBuilder = Preconditions.checkNotNull(optionalBuilder);
        return (Metadata.Builder)this;
    }

    public Metadata.Builder setOptionalBuilder(Optional<? extends TypeElement> optionalBuilder) {
        if (optionalBuilder.isPresent()) {
            return this.setOptionalBuilder(optionalBuilder.get());
        }
        return this.clearOptionalBuilder();
    }

    public Metadata.Builder setNullableOptionalBuilder(@Nullable TypeElement optionalBuilder) {
        if (optionalBuilder != null) {
            return this.setOptionalBuilder(optionalBuilder);
        }
        return this.clearOptionalBuilder();
    }

    public Metadata.Builder clearOptionalBuilder() {
        this.optionalBuilder = null;
        return (Metadata.Builder)this;
    }

    public Optional<TypeElement> getOptionalBuilder() {
        return Optional.fromNullable(this.optionalBuilder);
    }

    public Metadata.Builder setPartialType(TypeReference partialType) {
        this.partialType = Preconditions.checkNotNull(partialType);
        this._unsetProperties.remove((Object)Property.PARTIAL_TYPE);
        return (Metadata.Builder)this;
    }

    public TypeReference getPartialType() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.PARTIAL_TYPE), "partialType not set");
        return this.partialType;
    }

    public Metadata.Builder addProperties(Metadata.Property element) {
        this.properties.add(Preconditions.checkNotNull(element));
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addProperties(Metadata.Property ... elements) {
        this.properties.ensureCapacity(this.properties.size() + elements.length);
        for (Metadata.Property element : elements) {
            this.addProperties(element);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addAllProperties(Iterable<? extends Metadata.Property> elements) {
        if (elements instanceof Collection) {
            this.properties.ensureCapacity(this.properties.size() + ((Collection)elements).size());
        }
        for (Metadata.Property property : elements) {
            this.addProperties(property);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clearProperties() {
        this.properties.clear();
        return (Metadata.Builder)this;
    }

    public List<Metadata.Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public Metadata.Builder setPropertyEnum(TypeReference propertyEnum) {
        this.propertyEnum = Preconditions.checkNotNull(propertyEnum);
        this._unsetProperties.remove((Object)Property.PROPERTY_ENUM);
        return (Metadata.Builder)this;
    }

    public TypeReference getPropertyEnum() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.PROPERTY_ENUM), "propertyEnum not set");
        return this.propertyEnum;
    }

    public Metadata.Builder putStandardMethodUnderrides(Metadata.StandardMethod key, Metadata.UnderrideLevel value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(!this.standardMethodUnderrides.containsKey((Object)key), "Key already present in standardMethodUnderrides: %s", new Object[]{key});
        this.standardMethodUnderrides.put(key, value);
        return (Metadata.Builder)this;
    }

    public Metadata.Builder putAllStandardMethodUnderrides(Map<? extends Metadata.StandardMethod, ? extends Metadata.UnderrideLevel> map) {
        for (Metadata.StandardMethod standardMethod : map.keySet()) {
            this.putStandardMethodUnderrides(standardMethod, map.get((Object)standardMethod));
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder removeStandardMethodUnderrides(Metadata.StandardMethod key) {
        Preconditions.checkNotNull(key);
        Preconditions.checkArgument(this.standardMethodUnderrides.containsKey((Object)key), "Key not present in standardMethodUnderrides: %s", new Object[]{key});
        this.standardMethodUnderrides.remove((Object)key);
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clearStandardMethodUnderrides() {
        this.standardMethodUnderrides.clear();
        return (Metadata.Builder)this;
    }

    public Map<Metadata.StandardMethod, Metadata.UnderrideLevel> getStandardMethodUnderrides() {
        return Collections.unmodifiableMap(this.standardMethodUnderrides);
    }

    public Metadata.Builder setType(TypeElement type) {
        this.type = Preconditions.checkNotNull(type);
        this._unsetProperties.remove((Object)Property.TYPE);
        return (Metadata.Builder)this;
    }

    public TypeElement getType() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.TYPE), "type not set");
        return this.type;
    }

    public Metadata.Builder setValueType(TypeReference valueType) {
        this.valueType = Preconditions.checkNotNull(valueType);
        this._unsetProperties.remove((Object)Property.VALUE_TYPE);
        return (Metadata.Builder)this;
    }

    public TypeReference getValueType() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.VALUE_TYPE), "valueType not set");
        return this.valueType;
    }

    public Metadata.Builder addVisibleNestedTypes(TypeReference element) {
        this.visibleNestedTypes.add(Preconditions.checkNotNull(element));
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addVisibleNestedTypes(TypeReference ... elements) {
        for (TypeReference element : elements) {
            this.addVisibleNestedTypes(element);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addAllVisibleNestedTypes(Iterable<? extends TypeReference> elements) {
        for (TypeReference typeReference : elements) {
            this.addVisibleNestedTypes(typeReference);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clearVisibleNestedTypes() {
        this.visibleNestedTypes.clear();
        return (Metadata.Builder)this;
    }

    public Set<TypeReference> getVisibleNestedTypes() {
        return Collections.unmodifiableSet(this.visibleNestedTypes);
    }

    public Metadata.Builder setBuilderSerializable(boolean builderSerializable) {
        this.builderSerializable = builderSerializable;
        this._unsetProperties.remove((Object)Property.BUILDER_SERIALIZABLE);
        return (Metadata.Builder)this;
    }

    public boolean isBuilderSerializable() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE), "builderSerializable not set");
        return this.builderSerializable;
    }

    public Metadata.Builder setGwtCompatible(boolean gwtCompatible) {
        this.gwtCompatible = gwtCompatible;
        this._unsetProperties.remove((Object)Property.GWT_COMPATIBLE);
        return (Metadata.Builder)this;
    }

    public boolean isGwtCompatible() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.GWT_COMPATIBLE), "gwtCompatible not set");
        return this.gwtCompatible;
    }

    public Metadata.Builder setGwtSerializable(boolean gwtSerializable) {
        this.gwtSerializable = gwtSerializable;
        this._unsetProperties.remove((Object)Property.GWT_SERIALIZABLE);
        return (Metadata.Builder)this;
    }

    public boolean isGwtSerializable() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.GWT_SERIALIZABLE), "gwtSerializable not set");
        return this.gwtSerializable;
    }

    public Metadata build() {
        Preconditions.checkState(this._unsetProperties.isEmpty(), "Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    public Metadata.Builder mergeFrom(Metadata value) {
        this.setBuilderFactory(value.getBuilderFactory());
        this.setGeneratedBuilder(value.getGeneratedBuilder());
        this.setOptionalBuilder(value.getOptionalBuilder());
        this.setPartialType(value.getPartialType());
        this.addAllProperties(value.getProperties());
        this.setPropertyEnum(value.getPropertyEnum());
        this.putAllStandardMethodUnderrides(value.getStandardMethodUnderrides());
        this.setType(value.getType());
        this.setValueType(value.getValueType());
        this.addAllVisibleNestedTypes(value.getVisibleNestedTypes());
        this.setBuilderSerializable(value.isBuilderSerializable());
        this.setGwtCompatible(value.isGwtCompatible());
        this.setGwtSerializable(value.isGwtSerializable());
        return (Metadata.Builder)this;
    }

    public Metadata.Builder mergeFrom(Metadata.Builder template) {
        EnumSet<Property> _templateUnset = template._unsetProperties;
        this.setBuilderFactory(template.getBuilderFactory());
        if (!_templateUnset.contains((Object)Property.GENERATED_BUILDER)) {
            this.setGeneratedBuilder(template.getGeneratedBuilder());
        }
        this.setOptionalBuilder(template.getOptionalBuilder());
        if (!_templateUnset.contains((Object)Property.PARTIAL_TYPE)) {
            this.setPartialType(template.getPartialType());
        }
        this.addAllProperties(template.properties);
        if (!_templateUnset.contains((Object)Property.PROPERTY_ENUM)) {
            this.setPropertyEnum(template.getPropertyEnum());
        }
        this.putAllStandardMethodUnderrides(template.standardMethodUnderrides);
        if (!_templateUnset.contains((Object)Property.TYPE)) {
            this.setType(template.getType());
        }
        if (!_templateUnset.contains((Object)Property.VALUE_TYPE)) {
            this.setValueType(template.getValueType());
        }
        this.addAllVisibleNestedTypes(template.visibleNestedTypes);
        if (!_templateUnset.contains((Object)Property.BUILDER_SERIALIZABLE)) {
            this.setBuilderSerializable(template.isBuilderSerializable());
        }
        if (!_templateUnset.contains((Object)Property.GWT_COMPATIBLE)) {
            this.setGwtCompatible(template.isGwtCompatible());
        }
        if (!_templateUnset.contains((Object)Property.GWT_SERIALIZABLE)) {
            this.setGwtSerializable(template.isGwtSerializable());
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clear() {
        Metadata.Builder _template = new Metadata.Builder();
        this.builderFactory = _template.builderFactory;
        this.generatedBuilder = _template.generatedBuilder;
        this.optionalBuilder = _template.optionalBuilder;
        this.partialType = _template.partialType;
        this.properties.clear();
        this.propertyEnum = _template.propertyEnum;
        this.standardMethodUnderrides.clear();
        this.type = _template.type;
        this.valueType = _template.valueType;
        this.visibleNestedTypes.clear();
        this.builderSerializable = _template.builderSerializable;
        this.gwtCompatible = _template.gwtCompatible;
        this.gwtSerializable = _template.gwtSerializable;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_template._unsetProperties);
        return (Metadata.Builder)this;
    }

    @VisibleForTesting
    public Metadata buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Metadata {
        private final BuilderFactory builderFactory;
        private final TypeReference generatedBuilder;
        private final TypeElement optionalBuilder;
        private final TypeReference partialType;
        private final ImmutableList<Metadata.Property> properties;
        private final TypeReference propertyEnum;
        private final ImmutableMap<Metadata.StandardMethod, Metadata.UnderrideLevel> standardMethodUnderrides;
        private final TypeElement type;
        private final TypeReference valueType;
        private final ImmutableSet<TypeReference> visibleNestedTypes;
        private final boolean builderSerializable;
        private final boolean gwtCompatible;
        private final boolean gwtSerializable;
        private final EnumSet<Property> _unsetProperties;

        Partial(Metadata_Builder builder) {
            this.builderFactory = builder.builderFactory;
            this.generatedBuilder = builder.generatedBuilder;
            this.optionalBuilder = builder.optionalBuilder;
            this.partialType = builder.partialType;
            this.properties = ImmutableList.copyOf(builder.properties);
            this.propertyEnum = builder.propertyEnum;
            this.standardMethodUnderrides = ImmutableMap.copyOf(builder.standardMethodUnderrides);
            this.type = builder.type;
            this.valueType = builder.valueType;
            this.visibleNestedTypes = ImmutableSet.copyOf(builder.visibleNestedTypes);
            this.builderSerializable = builder.builderSerializable;
            this.gwtCompatible = builder.gwtCompatible;
            this.gwtSerializable = builder.gwtSerializable;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public Optional<BuilderFactory> getBuilderFactory() {
            return Optional.fromNullable(this.builderFactory);
        }

        @Override
        public TypeReference getGeneratedBuilder() {
            if (this._unsetProperties.contains((Object)Property.GENERATED_BUILDER)) {
                throw new UnsupportedOperationException("generatedBuilder not set");
            }
            return this.generatedBuilder;
        }

        @Override
        public Optional<TypeElement> getOptionalBuilder() {
            return Optional.fromNullable(this.optionalBuilder);
        }

        @Override
        public TypeReference getPartialType() {
            if (this._unsetProperties.contains((Object)Property.PARTIAL_TYPE)) {
                throw new UnsupportedOperationException("partialType not set");
            }
            return this.partialType;
        }

        @Override
        public ImmutableList<Metadata.Property> getProperties() {
            return this.properties;
        }

        @Override
        public TypeReference getPropertyEnum() {
            if (this._unsetProperties.contains((Object)Property.PROPERTY_ENUM)) {
                throw new UnsupportedOperationException("propertyEnum not set");
            }
            return this.propertyEnum;
        }

        @Override
        public ImmutableMap<Metadata.StandardMethod, Metadata.UnderrideLevel> getStandardMethodUnderrides() {
            return this.standardMethodUnderrides;
        }

        @Override
        public TypeElement getType() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        public TypeReference getValueType() {
            if (this._unsetProperties.contains((Object)Property.VALUE_TYPE)) {
                throw new UnsupportedOperationException("valueType not set");
            }
            return this.valueType;
        }

        @Override
        public ImmutableSet<TypeReference> getVisibleNestedTypes() {
            return this.visibleNestedTypes;
        }

        @Override
        public boolean isBuilderSerializable() {
            if (this._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE)) {
                throw new UnsupportedOperationException("builderSerializable not set");
            }
            return this.builderSerializable;
        }

        @Override
        public boolean isGwtCompatible() {
            if (this._unsetProperties.contains((Object)Property.GWT_COMPATIBLE)) {
                throw new UnsupportedOperationException("gwtCompatible not set");
            }
            return this.gwtCompatible;
        }

        @Override
        public boolean isGwtSerializable() {
            if (this._unsetProperties.contains((Object)Property.GWT_SERIALIZABLE)) {
                throw new UnsupportedOperationException("gwtSerializable not set");
            }
            return this.gwtSerializable;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            if (!(this.builderFactory == other.builderFactory || this.builderFactory != null && this.builderFactory.equals((Object)other.builderFactory))) {
                return false;
            }
            if (!(this.generatedBuilder == other.generatedBuilder || this.generatedBuilder != null && this.generatedBuilder.equals(other.generatedBuilder))) {
                return false;
            }
            if (!(this.optionalBuilder == other.optionalBuilder || this.optionalBuilder != null && this.optionalBuilder.equals(other.optionalBuilder))) {
                return false;
            }
            if (!(this.partialType == other.partialType || this.partialType != null && this.partialType.equals(other.partialType))) {
                return false;
            }
            if (!this.properties.equals(other.properties)) {
                return false;
            }
            if (!(this.propertyEnum == other.propertyEnum || this.propertyEnum != null && this.propertyEnum.equals(other.propertyEnum))) {
                return false;
            }
            if (!this.standardMethodUnderrides.equals(other.standardMethodUnderrides)) {
                return false;
            }
            if (!(this.type == other.type || this.type != null && this.type.equals(other.type))) {
                return false;
            }
            if (!(this.valueType == other.valueType || this.valueType != null && this.valueType.equals(other.valueType))) {
                return false;
            }
            if (!this.visibleNestedTypes.equals(other.visibleNestedTypes)) {
                return false;
            }
            if (this.builderSerializable != other.builderSerializable) {
                return false;
            }
            if (this.gwtCompatible != other.gwtCompatible) {
                return false;
            }
            if (this.gwtSerializable != other.gwtSerializable) {
                return false;
            }
            return this._unsetProperties.equals(other._unsetProperties);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.builderFactory, this.generatedBuilder, this.optionalBuilder, this.partialType, this.properties, this.propertyEnum, this.standardMethodUnderrides, this.type, this.valueType, this.visibleNestedTypes, this.builderSerializable, this.gwtCompatible, this.gwtSerializable, this._unsetProperties});
        }

        public String toString() {
            return "partial Metadata{" + COMMA_JOINER.join(this.builderFactory != null ? "builderFactory=" + (Object)((Object)this.builderFactory) : null, !this._unsetProperties.contains((Object)Property.GENERATED_BUILDER) ? "generatedBuilder=" + this.generatedBuilder : null, this.optionalBuilder != null ? "optionalBuilder=" + this.optionalBuilder : null, !this._unsetProperties.contains((Object)Property.PARTIAL_TYPE) ? "partialType=" + this.partialType : null, "properties=" + this.properties, !this._unsetProperties.contains((Object)Property.PROPERTY_ENUM) ? "propertyEnum=" + this.propertyEnum : null, "standardMethodUnderrides=" + this.standardMethodUnderrides, !this._unsetProperties.contains((Object)Property.TYPE) ? "type=" + this.type : null, !this._unsetProperties.contains((Object)Property.VALUE_TYPE) ? "valueType=" + this.valueType : null, "visibleNestedTypes=" + this.visibleNestedTypes, !this._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE) ? "builderSerializable=" + this.builderSerializable : null, !this._unsetProperties.contains((Object)Property.GWT_COMPATIBLE) ? "gwtCompatible=" + this.gwtCompatible : null, !this._unsetProperties.contains((Object)Property.GWT_SERIALIZABLE) ? "gwtSerializable=" + this.gwtSerializable : null) + "}";
        }
    }

    private static final class Value
    extends Metadata {
        private final BuilderFactory builderFactory;
        private final TypeReference generatedBuilder;
        private final TypeElement optionalBuilder;
        private final TypeReference partialType;
        private final ImmutableList<Metadata.Property> properties;
        private final TypeReference propertyEnum;
        private final ImmutableMap<Metadata.StandardMethod, Metadata.UnderrideLevel> standardMethodUnderrides;
        private final TypeElement type;
        private final TypeReference valueType;
        private final ImmutableSet<TypeReference> visibleNestedTypes;
        private final boolean builderSerializable;
        private final boolean gwtCompatible;
        private final boolean gwtSerializable;

        private Value(Metadata_Builder builder) {
            this.builderFactory = builder.builderFactory;
            this.generatedBuilder = builder.generatedBuilder;
            this.optionalBuilder = builder.optionalBuilder;
            this.partialType = builder.partialType;
            this.properties = ImmutableList.copyOf(builder.properties);
            this.propertyEnum = builder.propertyEnum;
            this.standardMethodUnderrides = ImmutableMap.copyOf(builder.standardMethodUnderrides);
            this.type = builder.type;
            this.valueType = builder.valueType;
            this.visibleNestedTypes = ImmutableSet.copyOf(builder.visibleNestedTypes);
            this.builderSerializable = builder.builderSerializable;
            this.gwtCompatible = builder.gwtCompatible;
            this.gwtSerializable = builder.gwtSerializable;
        }

        @Override
        public Optional<BuilderFactory> getBuilderFactory() {
            return Optional.fromNullable(this.builderFactory);
        }

        @Override
        public TypeReference getGeneratedBuilder() {
            return this.generatedBuilder;
        }

        @Override
        public Optional<TypeElement> getOptionalBuilder() {
            return Optional.fromNullable(this.optionalBuilder);
        }

        @Override
        public TypeReference getPartialType() {
            return this.partialType;
        }

        @Override
        public ImmutableList<Metadata.Property> getProperties() {
            return this.properties;
        }

        @Override
        public TypeReference getPropertyEnum() {
            return this.propertyEnum;
        }

        @Override
        public ImmutableMap<Metadata.StandardMethod, Metadata.UnderrideLevel> getStandardMethodUnderrides() {
            return this.standardMethodUnderrides;
        }

        @Override
        public TypeElement getType() {
            return this.type;
        }

        @Override
        public TypeReference getValueType() {
            return this.valueType;
        }

        @Override
        public ImmutableSet<TypeReference> getVisibleNestedTypes() {
            return this.visibleNestedTypes;
        }

        @Override
        public boolean isBuilderSerializable() {
            return this.builderSerializable;
        }

        @Override
        public boolean isGwtCompatible() {
            return this.gwtCompatible;
        }

        @Override
        public boolean isGwtSerializable() {
            return this.gwtSerializable;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            if (!(this.builderFactory == other.builderFactory || this.builderFactory != null && this.builderFactory.equals((Object)other.builderFactory))) {
                return false;
            }
            if (!this.generatedBuilder.equals(other.generatedBuilder)) {
                return false;
            }
            if (!(this.optionalBuilder == other.optionalBuilder || this.optionalBuilder != null && this.optionalBuilder.equals(other.optionalBuilder))) {
                return false;
            }
            if (!this.partialType.equals(other.partialType)) {
                return false;
            }
            if (!this.properties.equals(other.properties)) {
                return false;
            }
            if (!this.propertyEnum.equals(other.propertyEnum)) {
                return false;
            }
            if (!this.standardMethodUnderrides.equals(other.standardMethodUnderrides)) {
                return false;
            }
            if (!this.type.equals(other.type)) {
                return false;
            }
            if (!this.valueType.equals(other.valueType)) {
                return false;
            }
            if (!this.visibleNestedTypes.equals(other.visibleNestedTypes)) {
                return false;
            }
            if (this.builderSerializable != other.builderSerializable) {
                return false;
            }
            if (this.gwtCompatible != other.gwtCompatible) {
                return false;
            }
            return this.gwtSerializable == other.gwtSerializable;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.builderFactory, this.generatedBuilder, this.optionalBuilder, this.partialType, this.properties, this.propertyEnum, this.standardMethodUnderrides, this.type, this.valueType, this.visibleNestedTypes, this.builderSerializable, this.gwtCompatible, this.gwtSerializable});
        }

        public String toString() {
            return "Metadata{" + COMMA_JOINER.join(this.builderFactory != null ? "builderFactory=" + (Object)((Object)this.builderFactory) : null, "generatedBuilder=" + this.generatedBuilder, this.optionalBuilder != null ? "optionalBuilder=" + this.optionalBuilder : null, "partialType=" + this.partialType, "properties=" + this.properties, "propertyEnum=" + this.propertyEnum, "standardMethodUnderrides=" + this.standardMethodUnderrides, "type=" + this.type, "valueType=" + this.valueType, "visibleNestedTypes=" + this.visibleNestedTypes, "builderSerializable=" + this.builderSerializable, "gwtCompatible=" + this.gwtCompatible, "gwtSerializable=" + this.gwtSerializable) + "}";
        }
    }

    private static enum Property {
        GENERATED_BUILDER("generatedBuilder"),
        PARTIAL_TYPE("partialType"),
        PROPERTY_ENUM("propertyEnum"),
        TYPE("type"),
        VALUE_TYPE("valueType"),
        BUILDER_SERIALIZABLE("builderSerializable"),
        GWT_COMPATIBLE("gwtCompatible"),
        GWT_SERIALIZABLE("gwtSerializable");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

