/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMultiset;
import org.inferred.freebuilder.shaded.com.google.common.collect.LinkedHashMultiset;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multiset;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multisets;

public class MultisetPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final String ADD_PREFIX = "add";
    private static final String ADD_ALL_PREFIX = "addAll";
    private static final String ADD_COPIES_PREFIX = "addCopiesTo";
    private static final String CLEAR_PREFIX = "clear";
    private static final String GET_PREFIX = "get";
    private static final String SET_COUNT_PREFIX = "setCountOf";

    public Optional<CodeGenerator> create(PropertyCodeGenerator.Config config) {
        if (!config.getProperty().getNullableAnnotations().isEmpty()) {
            return Optional.absent();
        }
        if (config.getProperty().getType().getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)config.getProperty().getType();
            if (Util.erasesToAnyOf(type, Multiset.class, ImmutableMultiset.class)) {
                Optional<TypeMirror> unboxedType;
                TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
                try {
                    unboxedType = Optional.of(config.getTypes().unboxedType(elementType));
                }
                catch (IllegalArgumentException e) {
                    unboxedType = Optional.absent();
                }
                return Optional.of(new CodeGenerator(config.getProperty(), elementType, unboxedType));
            }
        }
        return Optional.absent();
    }

    private static class CodeGenerator
    extends PropertyCodeGenerator {
        private final TypeMirror elementType;
        private final Optional<TypeMirror> unboxedType;

        CodeGenerator(Metadata.Property property, TypeMirror elementType, Optional<TypeMirror> unboxedType) {
            super(property);
            this.elementType = elementType;
            this.unboxedType = unboxedType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("private final %1$s<%2$s> %3$s = %1$s.create();", LinkedHashMultiset.class, this.elementType, this.property.getName());
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the multiset to be returned from {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s%s(%s element) {", metadata.getBuilder(), MultisetPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName(), this.unboxedType.or(this.elementType)).addLine("  %s%s(element, 1);", MultisetPropertyFactory.ADD_COPIES_PREFIX, this.property.getCapitalizedName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the multiset to be returned from", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s%s(%s... elements) {", metadata.getBuilder(), MultisetPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName(), this.unboxedType.or(this.elementType)).addLine("  for (%s element : elements) {", this.unboxedType.or(this.elementType)).addLine("    %s%s(element, 1);", MultisetPropertyFactory.ADD_COPIES_PREFIX, this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the multiset to be returned from", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s%s(%s<? extends %s> elements) {", metadata.getBuilder(), MultisetPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), Iterable.class, this.elementType).addLine("  for (%s element : elements) {", this.unboxedType.or(this.elementType)).addLine("    %s%s(element, 1);", MultisetPropertyFactory.ADD_COPIES_PREFIX, this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds a number of occurrences of {@code element} to the multiset to be", new Object[0]).addLine(" * returned from {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" * @throws IllegalArgumentException if {@code occurrences} is negative", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s%s(%s element, int occurrences) {", metadata.getBuilder(), MultisetPropertyFactory.ADD_COPIES_PREFIX, this.property.getCapitalizedName(), this.unboxedType.or(this.elementType)).addLine("  %s%s(element, this.%s.count(element) + occurrences);", MultisetPropertyFactory.SET_COUNT_PREFIX, this.property.getCapitalizedName(), this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the multiset to be returned from {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s%s() {", metadata.getBuilder(), MultisetPropertyFactory.CLEAR_PREFIX, this.property.getCapitalizedName()).addLine("  this.%s.clear();", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds or removes the necessary occurrences of {@code element} to/from the", new Object[0]).addLine(" * multiset to be returned from {@link %s#%s()}, such that it attains the", metadata.getType(), this.property.getGetterName()).addLine(" * desired count.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" * @throws IllegalArgumentException if {@code occurrences} is negative", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s%s(%s element, int occurrences) {", metadata.getBuilder(), MultisetPropertyFactory.SET_COUNT_PREFIX, this.property.getCapitalizedName(), this.unboxedType.or(this.elementType));
            if (!this.unboxedType.isPresent()) {
                code.addLine("  %s.checkNotNull(element);", Preconditions.class, this.property.getName());
            }
            code.addLine("  this.%s.setCount(element, occurrences);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the multiset that will be returned by", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s%s() {", Multiset.class, this.elementType, MultisetPropertyFactory.GET_PREFIX, this.property.getCapitalizedName()).addLine("  return %s.unmodifiableMultiset(%s);", Multisets.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.copyOf(%s.%s);", finalField, ImmutableMultiset.class, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s%s(%s.%s());", MultisetPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s%s(((%s) %s).%s);", MultisetPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s%s(%s);", builder, MultisetPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return false;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%s.clear();", this.property.getName());
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            code.addLine("%s.clear();", this.property.getName());
        }
    }
}

