/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import javax.annotation.Nullable;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

public class OptionalPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final String SET_PREFIX = "set";
    private static final String NULLABLE_SET_PREFIX = "setNullable";
    private static final String CLEAR_PREFIX = "clear";
    private static final SimpleTypeVisitor6<Boolean, Void> HAS_WILDCARD = new SimpleTypeVisitor6<Boolean, Void>(){

        @Override
        protected Boolean defaultAction(TypeMirror e, Void p) {
            return false;
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                if (!((Boolean)this.visit(typeMirror)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitWildcard(WildcardType t, Void p) {
            return true;
        }
    };

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        if (!config.getProperty().getNullableAnnotations().isEmpty()) {
            return Optional.absent();
        }
        if (config.getProperty().getType().getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)config.getProperty().getType();
            if (Util.erasesToAnyOf(type, Optional.class)) {
                Optional<TypeMirror> unboxedType;
                TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
                try {
                    unboxedType = Optional.of(config.getTypes().unboxedType(elementType));
                }
                catch (IllegalArgumentException e) {
                    unboxedType = Optional.absent();
                }
                String capitalizedName = config.getProperty().getCapitalizedName();
                String setterName = SET_PREFIX + capitalizedName;
                String nullableSetterName = NULLABLE_SET_PREFIX + capitalizedName;
                String clearName = CLEAR_PREFIX + capitalizedName;
                boolean requiresExplicitTypeParameters = (Boolean)HAS_WILDCARD.visit(elementType);
                return Optional.of(new CodeGenerator(config.getProperty(), setterName, nullableSetterName, clearName, elementType, unboxedType, requiresExplicitTypeParameters));
            }
        }
        return Optional.absent();
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        private final String setterName;
        private final String nullableSetterName;
        private final String clearName;
        private final TypeMirror elementType;
        private final Optional<TypeMirror> unboxedType;
        private final boolean requiresExplicitTypeParameters;

        @VisibleForTesting
        CodeGenerator(Metadata.Property property, String setterName, String nullableSetterName, String clearName, TypeMirror elementType, Optional<TypeMirror> unboxedType, boolean requiresExplicitTypeParametersInJava7) {
            super(property);
            this.setterName = setterName;
            this.nullableSetterName = nullableSetterName;
            this.clearName = clearName;
            this.elementType = elementType;
            this.unboxedType = unboxedType;
            this.requiresExplicitTypeParameters = requiresExplicitTypeParametersInJava7;
        }

        @Override
        public PropertyCodeGenerator.Type getType() {
            return PropertyCodeGenerator.Type.OPTIONAL;
        }

        @Override
        public void addValueFieldDeclaration(SourceBuilder code, String finalField) {
            code.addLine("// Store a nullable object instead of an Optional. Escape analysis then", new Object[0]).addLine("// allows the JVM to optimize away the Optional objects created by our", new Object[0]).addLine("// getter method.", new Object[0]).addLine("private final %s %s;", this.elementType, finalField);
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("// Store a nullable object instead of an Optional. Escape analysis then", new Object[0]).addLine("// allows the JVM to optimize away the Optional objects created by and", new Object[0]).addLine("// passed to our API.", new Object[0]).addLine("private %s %s = null;", this.elementType, this.property.getName());
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName());
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s %s) {", metadata.getBuilder(), this.setterName, this.unboxedType.or(this.elementType), this.property.getName());
            if (this.unboxedType.isPresent()) {
                code.addLine("  this.%1$s = %1$s;", this.property.getName());
            } else {
                code.addLine("  this.%1$s = %2$s.checkNotNull(%1$s);", this.property.getName(), Preconditions.class);
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s(%s<? extends %s> %s) {", metadata.getBuilder(), this.setterName, Optional.class, this.elementType, this.property.getName()).addLine("  if (%s.isPresent()) {", this.property.getName()).addLine("    return %s(%s.get());", this.setterName, this.property.getName()).addLine("  } else {", new Object[0]).addLine("    return %s();", this.clearName).addLine("  }", new Object[0]).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s(@%s %s %s) {", metadata.getBuilder(), this.nullableSetterName, Nullable.class, this.elementType, this.property.getName()).addLine("  if (%s != null) {", this.property.getName()).addLine("    return %s(%s);", this.setterName, this.property.getName()).addLine("  } else {", new Object[0]).addLine("    return %s();", this.clearName).addLine("  }", new Object[0]).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by {@link %s#%s()}", metadata.getType(), this.property.getGetterName()).addLine(" * to {@link %s#absent() Optional.absent()}.", Optional.class).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", metadata.getBuilder(), this.clearName).addLine("  this.%s = null;", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.property.getType(), this.property.getGetterName());
            code.add("  return %s.", Optional.class);
            if (this.requiresExplicitTypeParameters) {
                code.add("<%s>", this.elementType);
            }
            code.add("fromNullable(%s);\n", this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.%s;", finalField, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s(%s.%s());", this.setterName, value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s(%s.%s());", this.setterName, builder, this.property.getGetterName());
        }

        @Override
        public void addReadValueFragment(SourceBuilder code, String finalField) {
            code.add("%s.", Optional.class);
            if (this.requiresExplicitTypeParameters) {
                code.add("<%s>", this.elementType);
            }
            code.add("fromNullable(%s)", finalField);
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, this.setterName, variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return true;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%1$s = %2$s.%1$s;", this.property.getName(), template);
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            code.addLine("%s = null;", this.property.getName());
        }
    }
}

