/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Set;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Predicate;

public abstract class PropertyCodeGenerator {
    protected final Metadata.Property property;
    public static final Predicate<PropertyCodeGenerator> IS_TEMPLATE_REQUIRED_IN_CLEAR = new Predicate<PropertyCodeGenerator>(){

        @Override
        public boolean apply(PropertyCodeGenerator input) {
            return input.isTemplateRequiredInClear();
        }
    };

    public PropertyCodeGenerator(Metadata.Property property) {
        this.property = property;
    }

    public Type getType() {
        return Type.HAS_DEFAULT;
    }

    public void addValueFieldDeclaration(SourceBuilder code, String finalField) {
        code.addLine("private final %s %s;", this.property.getType(), finalField);
    }

    public abstract void addBuilderFieldDeclaration(SourceBuilder var1);

    public abstract void addBuilderFieldAccessors(SourceBuilder var1, Metadata var2);

    public abstract void addFinalFieldAssignment(SourceBuilder var1, String var2, String var3);

    public void addPartialFieldAssignment(SourceBuilder code, String finalField, String builder) {
        this.addFinalFieldAssignment(code, finalField, builder);
    }

    public abstract void addMergeFromValue(SourceBuilder var1, String var2);

    public abstract void addMergeFromBuilder(SourceBuilder var1, Metadata var2, String var3);

    public void addReadValueFragment(SourceBuilder code, String finalField) {
        code.add("%s", finalField);
    }

    public abstract void addSetFromResult(SourceBuilder var1, String var2, String var3);

    public abstract boolean isTemplateRequiredInClear();

    public abstract void addClear(SourceBuilder var1, String var2);

    public abstract void addPartialClear(SourceBuilder var1);

    public static enum Type {
        REQUIRED,
        OPTIONAL,
        HAS_DEFAULT;

    }

    static interface Factory {
        public Optional<? extends PropertyCodeGenerator> create(Config var1);
    }

    static interface Config {
        public Metadata.Property getProperty();

        public Set<String> getMethodsInvokedInBuilderConstructor();

        public Elements getElements();

        public Types getTypes();
    }
}

