/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Collection;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSetMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.LinkedHashMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multimaps;
import org.inferred.freebuilder.shaded.com.google.common.collect.SetMultimap;

public class SetMultimapPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final String PUT_PREFIX = "put";
    private static final String PUT_ALL_PREFIX = "putAll";
    private static final String CLEAR_PREFIX = "clear";
    private static final String GET_PREFIX = "get";

    public Optional<CodeGenerator> create(PropertyCodeGenerator.Config config) {
        if (!config.getProperty().getNullableAnnotations().isEmpty()) {
            return Optional.absent();
        }
        if (config.getProperty().getType().getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)config.getProperty().getType();
            if (Util.erasesToAnyOf(type, SetMultimap.class, ImmutableSetMultimap.class)) {
                TypeMirror keyType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
                TypeMirror valueType = Util.upperBound(config.getElements(), type.getTypeArguments().get(1));
                Optional<TypeMirror> unboxedKeyType = SetMultimapPropertyFactory.unboxed(config.getTypes(), keyType);
                Optional<TypeMirror> unboxedValueType = SetMultimapPropertyFactory.unboxed(config.getTypes(), valueType);
                return Optional.of(new CodeGenerator(config.getProperty(), keyType, unboxedKeyType, valueType, unboxedValueType));
            }
        }
        return Optional.absent();
    }

    private static Optional<TypeMirror> unboxed(Types types, TypeMirror elementType) {
        Optional<TypeMirror> unboxedType;
        try {
            unboxedType = Optional.of(types.unboxedType(elementType));
        }
        catch (IllegalArgumentException e) {
            unboxedType = Optional.absent();
        }
        return unboxedType;
    }

    private static class CodeGenerator
    extends PropertyCodeGenerator {
        private final TypeMirror keyType;
        private final Optional<TypeMirror> unboxedKeyType;
        private final TypeMirror valueType;
        private final Optional<TypeMirror> unboxedValueType;

        CodeGenerator(Metadata.Property property, TypeMirror keyType, Optional<TypeMirror> unboxedKeyType, TypeMirror valueType, Optional<TypeMirror> unboxedValueType) {
            super(property);
            this.keyType = keyType;
            this.unboxedKeyType = unboxedKeyType;
            this.valueType = valueType;
            this.unboxedValueType = unboxedValueType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("private final %1$s<%2$s, %3$s> %4$s = %1$s.create();", LinkedHashMultimap.class, this.keyType, this.valueType, this.property.getName());
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds a {@code key}-{@code value} mapping to the multimap to be returned", new Object[0]).addLine(" * from {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" * If the multimap already contains this mapping, then {@code %s%s}", SetMultimapPropertyFactory.PUT_PREFIX, this.property.getCapitalizedName()).addLine(" * has no effect (only the previously added mapping is retained).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
                code.add(" * @throws NullPointerException if ", new Object[0]);
                if (this.unboxedKeyType.isPresent()) {
                    code.add("{@code value}", new Object[0]);
                } else if (this.unboxedValueType.isPresent()) {
                    code.add("{@code key}", new Object[0]);
                } else {
                    code.add("either {@code key} or {@code value}", new Object[0]);
                }
                code.add(" is null\n", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s%s(%s key, %s value) {", metadata.getBuilder(), SetMultimapPropertyFactory.PUT_PREFIX, this.property.getCapitalizedName(), this.unboxedKeyType.or(this.keyType), this.unboxedValueType.or(this.valueType));
            if (!this.unboxedKeyType.isPresent()) {
                code.addLine("  %s.checkNotNull(key);", Preconditions.class);
            }
            if (!this.unboxedValueType.isPresent()) {
                code.addLine("  %s.checkNotNull(value);", Preconditions.class);
            }
            code.addLine("  this.%s.put(key, value);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds a collection of {@code values} with the same {@code key} to the", new Object[0]).addLine(" * multimap to be returned from {@link %s#%s()}, ignoring duplicate values", metadata.getType(), this.property.getGetterName()).addLine(" * (only the first duplicate value is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (this.unboxedKeyType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code values} is null or contains a null element", new Object[0]);
            } else {
                code.addLine(" * @throws NullPointerException if either {@code key} or {@code values} is", new Object[0]).addLine(" *     null, or if {@code values} contains a null element", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s%s(%s key, %s<? extends %s> values) {", metadata.getBuilder(), SetMultimapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName(), this.unboxedKeyType.or(this.keyType), Iterable.class, this.valueType).addLine("  for (%s value : values) {", this.unboxedValueType.or(this.valueType)).addLine("    %s%s(key, value);", SetMultimapPropertyFactory.PUT_PREFIX, this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each mapping in {@code multimap} to the multimap to be returned from", new Object[0]).addLine(" * {@link %s#%s()}, ignoring duplicate mappings", metadata.getType(), this.property.getGetterName()).addLine(" * (only the first duplicate mapping is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code multimap} is null or contains a", new Object[0]).addLine(" *     null key or value", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s%s(%s<? extends %s, ? extends %s> multimap) {", metadata.getBuilder(), SetMultimapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName(), Multimap.class, this.keyType, this.valueType).addLine("  for (%s<? extends %s, ? extends %s<? extends %s>> entry", Map.Entry.class, this.keyType, Collection.class, this.valueType).addLine("      : multimap.asMap().entrySet()) {", new Object[0]).addLine("    %s%s(entry.getKey(), entry.getValue());", SetMultimapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes all of the mappings from the multimap to be returned from", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s%s() {", metadata.getBuilder(), SetMultimapPropertyFactory.CLEAR_PREFIX, this.property.getCapitalizedName()).addLine("  this.%s.clear();", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the multimap that will be returned by", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s, %s> %s%s() {", SetMultimap.class, this.keyType, this.valueType, SetMultimapPropertyFactory.GET_PREFIX, this.property.getCapitalizedName()).addLine("  return %s.unmodifiableSetMultimap(%s);", Multimaps.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.copyOf(%s.%s);", finalField, ImmutableSetMultimap.class, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s%s(%s.%s());", SetMultimapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName(), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s%s(((%s) %s).%s);", SetMultimapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName(), metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s%s(%s);", builder, SetMultimapPropertyFactory.PUT_ALL_PREFIX, this.property.getCapitalizedName(), variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return false;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%s.clear();", this.property.getName());
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            code.addLine("%s.clear();", this.property.getName());
        }
    }
}

