/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

public class SetPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final String ADD_PREFIX = "add";
    private static final String ADD_ALL_PREFIX = "addAll";
    private static final String CLEAR_PREFIX = "clear";
    private static final String GET_PREFIX = "get";

    public Optional<CodeGenerator> create(PropertyCodeGenerator.Config config) {
        if (!config.getProperty().getNullableAnnotations().isEmpty()) {
            return Optional.absent();
        }
        if (config.getProperty().getType().getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)config.getProperty().getType();
            if (Util.erasesToAnyOf(type, Set.class, ImmutableSet.class)) {
                Optional<TypeMirror> unboxedType;
                TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
                try {
                    unboxedType = Optional.of(config.getTypes().unboxedType(elementType));
                }
                catch (IllegalArgumentException e) {
                    unboxedType = Optional.absent();
                }
                return Optional.of(new CodeGenerator(config.getProperty(), elementType, unboxedType));
            }
        }
        return Optional.absent();
    }

    private static class CodeGenerator
    extends PropertyCodeGenerator {
        private final TypeMirror elementType;
        private final Optional<TypeMirror> unboxedType;

        CodeGenerator(Metadata.Property property, TypeMirror elementType, Optional<TypeMirror> unboxedType) {
            super(property);
            this.elementType = elementType;
            this.unboxedType = unboxedType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("private final %1$s<%2$s> %3$s = new %1$s<%4$s>();", LinkedHashSet.class, this.elementType, this.property.getName(), code.getSourceLevel().supportsDiamondOperator() ? "" : this.elementType);
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the set to be returned from {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" * If the set already contains {@code element}, then {@code %s%s}", SetPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName()).addLine(" * has no effect (only the previously added element is retained).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s%s(%s element) {", metadata.getBuilder(), SetPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName(), this.unboxedType.or(this.elementType));
            if (this.unboxedType.isPresent()) {
                code.addLine("  this.%s.add(element);", this.property.getName());
            } else {
                code.addLine("  this.%s.add(%s.checkNotNull(element));", this.property.getName(), Preconditions.class);
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the set to be returned from", new Object[0]).addLine(" * {@link %s#%s()}, ignoring duplicate elements", metadata.getType(), this.property.getGetterName()).addLine(" * (only the first duplicate element is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s%s(%s... elements) {", metadata.getBuilder(), SetPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName(), this.unboxedType.or(this.elementType)).addLine("  for (%s element : elements) {", this.unboxedType.or(this.elementType)).addLine("    %s%s(element);", SetPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the set to be returned from", new Object[0]).addLine(" * {@link %s#%s()}, ignoring duplicate elements", metadata.getType(), this.property.getGetterName()).addLine(" * (only the first duplicate element is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s%s(%s<? extends %s> elements) {", metadata.getBuilder(), SetPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), Iterable.class, this.elementType).addLine("  for (%s element : elements) {", this.unboxedType.or(this.elementType)).addLine("    %s%s(element);", SetPropertyFactory.ADD_PREFIX, this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the set to be returned from {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s%s() {", metadata.getBuilder(), SetPropertyFactory.CLEAR_PREFIX, this.property.getCapitalizedName()).addLine("  this.%s.clear();", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the set that will be returned by", new Object[0]).addLine(" * {@link %s#%s()}.", metadata.getType(), this.property.getGetterName()).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s%s() {", Set.class, this.elementType, SetPropertyFactory.GET_PREFIX, this.property.getCapitalizedName()).addLine("  return %s.unmodifiableSet(%s);", Collections.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.copyOf(%s.%s);", finalField, ImmutableSet.class, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s%s(%s.%s());", SetPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s%s(((%s) %s).%s);", SetPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s%s(%s);", builder, SetPropertyFactory.ADD_ALL_PREFIX, this.property.getCapitalizedName(), variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return false;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%s.clear();", this.property.getName());
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            code.addLine("%s.clear();", this.property.getName());
        }
    }
}

