/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.util.IsInvalidTypeVisitor;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceLevel;
import org.inferred.freebuilder.processor.util.TypeReference;
import org.inferred.freebuilder.processor.util.TypeShortener;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

public final class SourceStringBuilder
implements SourceBuilder {
    private final SourceLevel sourceLevel;
    private final StringBuilder destination;
    private final TypeShortener shortener;

    public static SourceStringBuilder simple(SourceLevel sourceLevel) {
        return new SourceStringBuilder(sourceLevel, new TypeShortener.AlwaysShorten());
    }

    SourceStringBuilder(SourceLevel sourceLevel, TypeShortener shortener) {
        this(sourceLevel, shortener, new StringBuilder());
    }

    SourceStringBuilder(SourceLevel sourceLevel, TypeShortener shortener, StringBuilder destination) {
        this.sourceLevel = sourceLevel;
        this.destination = destination;
        this.shortener = shortener;
    }

    @Override
    public SourceBuilder add(String fmt, Object ... args) {
        Object[] substituteArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            substituteArgs[i] = this.substitute(args[i]);
        }
        this.destination.append(String.format(fmt, substituteArgs));
        return this;
    }

    @Override
    public SourceBuilder addLine(String fmt, Object ... args) {
        return this.add(fmt + "\n", args);
    }

    @Override
    public SourceLevel getSourceLevel() {
        return this.sourceLevel;
    }

    public String toString() {
        return this.destination.toString();
    }

    private Object substitute(Object arg) {
        if (arg instanceof Package) {
            return ((Package)arg).getName();
        }
        if (arg instanceof PackageElement) {
            return ((PackageElement)arg).getQualifiedName();
        }
        if (arg instanceof Class) {
            return this.shortener.shorten((Class)arg);
        }
        if (arg instanceof TypeElement) {
            return this.shortener.shorten((TypeElement)arg);
        }
        if (arg instanceof DeclaredType && ((DeclaredType)arg).asElement() instanceof TypeElement) {
            DeclaredType mirror = (DeclaredType)arg;
            Preconditions.checkArgument(SourceStringBuilder.isLegalType(mirror), "Cannot write unknown type %s", mirror);
            return this.shortener.shorten(mirror);
        }
        if (arg instanceof TypeReference) {
            return this.shortener.shorten((TypeReference)arg);
        }
        return arg;
    }

    private static boolean isLegalType(TypeMirror mirror) {
        return (Boolean)new IsInvalidTypeVisitor().visit(mirror) == false;
    }
}

