/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.beans.Introspector;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.BuildablePropertyFactory;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.DefaultPropertyFactory;
import org.inferred.freebuilder.processor.GwtSupport;
import org.inferred.freebuilder.processor.JacksonSupport;
import org.inferred.freebuilder.processor.ListMultimapPropertyFactory;
import org.inferred.freebuilder.processor.ListPropertyFactory;
import org.inferred.freebuilder.processor.MapPropertyFactory;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.MethodFinder;
import org.inferred.freebuilder.processor.MethodIntrospector;
import org.inferred.freebuilder.processor.MultisetPropertyFactory;
import org.inferred.freebuilder.processor.NullablePropertyFactory;
import org.inferred.freebuilder.processor.OptionalPropertyFactory;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.SetMultimapPropertyFactory;
import org.inferred.freebuilder.processor.SetPropertyFactory;
import org.inferred.freebuilder.processor.util.IsInvalidTypeVisitor;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.QualifiedName;

class Analyser {
    private static final List<PropertyCodeGenerator.Factory> PROPERTY_FACTORIES = ImmutableList.of((Object)new NullablePropertyFactory(), (Object)new ListPropertyFactory(), (Object)new SetPropertyFactory(), (Object)new MapPropertyFactory(), (Object)new MultisetPropertyFactory(), (Object)new ListMultimapPropertyFactory(), (Object)new SetMultimapPropertyFactory(), (Object)new OptionalPropertyFactory(), (Object)new BuildablePropertyFactory(), (Object)new DefaultPropertyFactory());
    private static final String BUILDER_SIMPLE_NAME_TEMPLATE = "%s_Builder";
    private static final String USER_BUILDER_NAME = "Builder";
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(get|is)(.+)");
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private final Elements elements;
    private final Messager messager;
    private final MethodIntrospector methodIntrospector;
    private final Types types;
    private static final SimpleTypeVisitor6<Boolean, ?> CAST_IS_FULLY_CHECKED = new SimpleTypeVisitor6<Boolean, Void>(){

        @Override
        public Boolean visitArray(ArrayType t, Void p) {
            return (Boolean)this.visit(t.getComponentType());
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                if (((Boolean)IS_UNBOUNDED_WILDCARD.visit(typeMirror)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected Boolean defaultAction(TypeMirror e, Void p) {
            return true;
        }
    };
    private static final SimpleTypeVisitor6<Boolean, ?> IS_UNBOUNDED_WILDCARD = new SimpleTypeVisitor6<Boolean, Void>(){

        @Override
        public Boolean visitWildcard(WildcardType t, Void p) {
            return t.getExtendsBound() == null || t.getExtendsBound().toString().equals("java.lang.Object");
        }

        @Override
        protected Boolean defaultAction(TypeMirror e, Void p) {
            return false;
        }
    };

    Analyser(Elements elements, Messager messager, MethodIntrospector methodIntrospector, Types types) {
        this.elements = elements;
        this.messager = messager;
        this.methodIntrospector = methodIntrospector;
        this.types = types;
    }

    Metadata analyse(TypeElement type) throws CannotGenerateCodeException {
        PackageElement pkg = this.elements.getPackageOf(type);
        this.verifyType(type, pkg);
        ImmutableSet<ExecutableElement> methods = MethodFinder.methodsOn(type, this.elements);
        QualifiedName generatedBuilder = QualifiedName.of(pkg.getQualifiedName().toString(), this.generatedBuilderSimpleName(type), new String[0]);
        Optional<TypeElement> builder = this.tryFindBuilder(generatedBuilder, type);
        QualifiedName valueType = generatedBuilder.nestedType("Value");
        QualifiedName partialType = generatedBuilder.nestedType("Partial");
        QualifiedName propertyType = generatedBuilder.nestedType("Property");
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        Metadata.Builder metadata = new Metadata.Builder().setType(QualifiedName.of(type).withParameters(typeParameters)).setInterfaceType(type.getKind().isInterface()).setBuilder(Analyser.parameterized(builder, typeParameters)).setBuilderFactory((Optional)this.builderFactory(builder)).setGeneratedBuilder(generatedBuilder.withParameters(typeParameters)).setValueType(valueType.withParameters(typeParameters)).setPartialType(partialType.withParameters(typeParameters)).setPropertyEnum(propertyType.withParameters(new String[0])).addVisibleNestedTypes(valueType).addVisibleNestedTypes(partialType).addVisibleNestedTypes(propertyType).addAllVisibleNestedTypes(Analyser.visibleTypesIn(type)).putAllStandardMethodUnderrides(this.findUnderriddenMethods((Iterable<ExecutableElement>)methods)).setBuilderSerializable(this.shouldBuilderBeSerializable(builder));
        GwtSupport.addGwtMetadata(type, metadata);
        return metadata.addAllProperties(this.findProperties(type, (Iterable<ExecutableElement>)methods, builder).values()).build();
    }

    private static Set<QualifiedName> visibleTypesIn(TypeElement type) {
        ImmutableSet.Builder visibleTypes = ImmutableSet.builder();
        for (TypeElement nestedType : ElementFilter.typesIn(type.getEnclosedElements())) {
            visibleTypes.add((Object)QualifiedName.of(nestedType));
        }
        visibleTypes.addAll(Analyser.visibleTypesIn(ModelUtils.maybeType(type.getEnclosingElement())));
        visibleTypes.addAll(Analyser.visibleTypesIn(ModelUtils.maybeAsTypeElement(type.getSuperclass())));
        return visibleTypes.build();
    }

    private static Set<QualifiedName> visibleTypesIn(Optional<TypeElement> type) {
        if (!type.isPresent()) {
            return ImmutableSet.of();
        }
        return Analyser.visibleTypesIn((TypeElement)type.get());
    }

    private void verifyType(TypeElement type, PackageElement pkg) throws CannotGenerateCodeException {
        if (pkg.isUnnamed()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder does not support types in unnamed packages", type);
            throw new CannotGenerateCodeException();
        }
        switch (type.getNestingKind()) {
            case TOP_LEVEL: {
                break;
            }
            case MEMBER: {
                if (!type.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Inner classes cannot be @FreeBuilder types (did you forget the static keyword?)", type);
                    throw new CannotGenerateCodeException();
                }
                if (type.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder types cannot be private", type);
                    throw new CannotGenerateCodeException();
                }
                for (Element e = type.getEnclosingElement(); e != null; e = e.getEnclosingElement()) {
                    if (!e.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder types cannot be private, but enclosing type " + e.getSimpleName() + " is inaccessible", type);
                    throw new CannotGenerateCodeException();
                }
                break;
            }
            default: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Only top-level or static nested types can be @FreeBuilder types", type);
                throw new CannotGenerateCodeException();
            }
        }
        switch (type.getKind()) {
            case ANNOTATION_TYPE: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder does not support annotation types", type);
                throw new CannotGenerateCodeException();
            }
            case CLASS: {
                this.verifyTypeIsConstructible(type);
                break;
            }
            case ENUM: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder does not support enum types", type);
                throw new CannotGenerateCodeException();
            }
            case INTERFACE: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected element kind " + (Object)((Object)type.getKind())));
            }
        }
    }

    private void verifyTypeIsConstructible(TypeElement type) throws CannotGenerateCodeException {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getEnclosedElements());
        if (constructors.isEmpty()) {
            return;
        }
        for (ExecutableElement constructor : constructors) {
            if (!constructor.getParameters().isEmpty()) continue;
            if (constructor.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder types must have a package-visible no-args constructor", constructor);
                throw new CannotGenerateCodeException();
            }
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "@FreeBuilder types must have a package-visible no-args constructor", type);
        throw new CannotGenerateCodeException();
    }

    private Map<Metadata.StandardMethod, Metadata.UnderrideLevel> findUnderriddenMethods(Iterable<ExecutableElement> methods) {
        LinkedHashMap<Object, ExecutableElement> standardMethods = new LinkedHashMap<Object, ExecutableElement>();
        for (ExecutableElement method : methods) {
            Object standardMethod = Analyser.maybeStandardMethod(method);
            if (!standardMethod.isPresent() || !Analyser.isUnderride(method)) continue;
            standardMethods.put(standardMethod.get(), method);
        }
        if (standardMethods.containsKey((Object)Metadata.StandardMethod.EQUALS) != standardMethods.containsKey((Object)Metadata.StandardMethod.HASH_CODE)) {
            ExecutableElement underriddenMethod = standardMethods.containsKey((Object)Metadata.StandardMethod.EQUALS) ? (ExecutableElement)standardMethods.get((Object)Metadata.StandardMethod.EQUALS) : (ExecutableElement)standardMethods.get((Object)Metadata.StandardMethod.HASH_CODE);
            this.messager.printMessage(Diagnostic.Kind.ERROR, "hashCode and equals must be implemented together on @FreeBuilder types", underriddenMethod);
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Object standardMethod : standardMethods.keySet()) {
            if (((ExecutableElement)standardMethods.get(standardMethod)).getModifiers().contains((Object)Modifier.FINAL)) {
                result.put(standardMethod, (Object)Metadata.UnderrideLevel.FINAL);
                continue;
            }
            result.put(standardMethod, (Object)Metadata.UnderrideLevel.OVERRIDEABLE);
        }
        return result.build();
    }

    private static boolean isUnderride(ExecutableElement method) {
        return !method.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private Optional<TypeElement> tryFindBuilder(QualifiedName generatedBuilder, TypeElement type) {
        Optional userClass = Iterables.tryFind(ElementFilter.typesIn(type.getEnclosedElements()), (Predicate)new Predicate<Element>(){

            public boolean apply(Element input) {
                return input.getSimpleName().contentEquals(Analyser.USER_BUILDER_NAME);
            }
        });
        if (!userClass.isPresent()) {
            if (type.getKind() == ElementKind.INTERFACE) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Add \"class Builder extends " + generatedBuilder.getSimpleName() + " {}\" to your interface to enable the @FreeBuilder API", type);
            } else {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Add \"public static class Builder extends " + generatedBuilder.getSimpleName() + " {}\" to your class to enable the @FreeBuilder API", type);
            }
            return Optional.absent();
        }
        boolean extendsSuperclass = (Boolean)new IsSubclassOfGeneratedTypeVisitor(generatedBuilder, type.getTypeParameters()).visit(((TypeElement)userClass.get()).getSuperclass());
        if (!extendsSuperclass) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder extends the wrong type (should be " + generatedBuilder.getSimpleName() + ")", (Element)userClass.get());
            return Optional.absent();
        }
        return userClass;
    }

    private Optional<BuilderFactory> builderFactory(Optional<TypeElement> builder) {
        if (!builder.isPresent()) {
            return Optional.of((Object)((Object)BuilderFactory.NO_ARGS_CONSTRUCTOR));
        }
        if (!((TypeElement)builder.get()).getModifiers().contains((Object)Modifier.STATIC)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder must be static on @FreeBuilder types", (Element)builder.get());
            return Optional.absent();
        }
        return BuilderFactory.from((TypeElement)builder.get());
    }

    private Map<String, Metadata.Property> findProperties(TypeElement type, Iterable<ExecutableElement> methods, Optional<TypeElement> builder) {
        Set<String> methodsInvokedInBuilderConstructor = this.getMethodsInvokedInBuilderConstructor(builder);
        LinkedHashMap<String, Metadata.Property> propertiesByName = new LinkedHashMap<String, Metadata.Property>();
        Optional<JacksonSupport> jacksonSupport = JacksonSupport.create(type);
        for (ExecutableElement method : methods) {
            Metadata.Property property = this.asPropertyOrNull(type, builder, method, methodsInvokedInBuilderConstructor, jacksonSupport);
            if (property == null) continue;
            propertiesByName.put(property.getName(), property);
        }
        return propertiesByName;
    }

    private Set<String> getMethodsInvokedInBuilderConstructor(Optional<TypeElement> builder) {
        if (!builder.isPresent()) {
            return ImmutableSet.of();
        }
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(((TypeElement)builder.get()).getEnclosedElements());
        if (constructors.isEmpty()) {
            return ImmutableSet.of();
        }
        Sets.SetView result = null;
        for (ExecutableElement constructor : constructors) {
            if (result == null) {
                result = this.methodIntrospector.getOwnMethodInvocations(constructor);
                continue;
            }
            result = Sets.intersection(result, this.methodIntrospector.getOwnMethodInvocations(constructor));
        }
        return ImmutableSet.copyOf((Iterable)Iterables.transform(result, (Function)Functions.toStringFunction()));
    }

    private Metadata.Property asPropertyOrNull(TypeElement valueType, Optional<TypeElement> builder, ExecutableElement method, Set<String> methodsInvokedInBuilderConstructor, Optional<JacksonSupport> jacksonSupport) {
        MatchResult getterNameMatchResult = this.getterNameMatchResult(valueType, method);
        if (getterNameMatchResult == null) {
            return null;
        }
        String getterName = getterNameMatchResult.group(0);
        TypeMirror propertyType = this.getReturnType(valueType, method);
        String camelCaseName = Introspector.decapitalize(getterNameMatchResult.group(2));
        Metadata.Property.Builder resultBuilder = new Metadata.Property.Builder().setType(propertyType).setName(camelCaseName).setCapitalizedName(getterNameMatchResult.group(2)).setAllCapsName(Analyser.camelCaseToAllCaps(camelCaseName)).setGetterName(getterName).setFullyCheckedCast((Boolean)CAST_IS_FULLY_CHECKED.visit(propertyType));
        if (jacksonSupport.isPresent()) {
            ((JacksonSupport)jacksonSupport.get()).addJacksonAnnotations(resultBuilder, method);
        }
        if (propertyType.getKind().isPrimitive()) {
            PrimitiveType unboxedType = this.types.getPrimitiveType(propertyType.getKind());
            TypeMirror boxedType = this.types.erasure(this.types.boxedClass(unboxedType).asType());
            resultBuilder.setBoxedType(boxedType);
        }
        Metadata.Property propertyWithoutCodeGenerator = resultBuilder.build();
        if (builder.isPresent()) {
            resultBuilder.setCodeGenerator(this.createCodeGenerator((TypeElement)builder.get(), propertyWithoutCodeGenerator, method, methodsInvokedInBuilderConstructor));
        }
        return resultBuilder.build();
    }

    private TypeMirror getReturnType(TypeElement type, ExecutableElement method) {
        try {
            ExecutableType executableType = (ExecutableType)this.types.asMemberOf((DeclaredType)type.asType(), method);
            return executableType.getReturnType();
        }
        catch (IllegalArgumentException e) {
            return method.getReturnType();
        }
    }

    private PropertyCodeGenerator createCodeGenerator(TypeElement builder, Metadata.Property propertyWithoutCodeGenerator, ExecutableElement getterMethod, Set<String> methodsInvokedInBuilderConstructor) {
        ConfigImpl config = new ConfigImpl(builder, propertyWithoutCodeGenerator, getterMethod, methodsInvokedInBuilderConstructor);
        for (PropertyCodeGenerator.Factory factory : PROPERTY_FACTORIES) {
            Optional<? extends PropertyCodeGenerator> codeGenerator = factory.create(config);
            if (!codeGenerator.isPresent()) continue;
            return (PropertyCodeGenerator)codeGenerator.get();
        }
        throw new AssertionError((Object)"DefaultPropertyFactory not registered");
    }

    private MatchResult getterNameMatchResult(TypeElement valueType, ExecutableElement method) {
        if (Analyser.maybeStandardMethod(method).isPresent()) {
            return null;
        }
        Set<Modifier> modifiers = method.getModifiers();
        if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        boolean declaredOnValueType = method.getEnclosingElement().equals(valueType);
        String name = method.getSimpleName().toString();
        Matcher getterMatcher = GETTER_PATTERN.matcher(name);
        if (!getterMatcher.matches()) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Only getter methods (starting with 'get' or 'is') may be declared abstract on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        String prefix = getterMatcher.group(1);
        String suffix = getterMatcher.group(2);
        if (Analyser.hasUpperCase(suffix.codePointAt(0))) {
            if (declaredOnValueType) {
                String message = new StringBuilder().append("Getter methods cannot have a lowercase character immediately after the '").append(prefix).append("' prefix on @FreeBuilder types (did you mean '").append(prefix).appendCodePoint(Character.toUpperCase(suffix.codePointAt(0))).append(suffix.substring(suffix.offsetByCodePoints(0, 1))).append("'?)").toString();
                this.messager.printMessage(Diagnostic.Kind.ERROR, message, method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        TypeMirror returnType = this.getReturnType(valueType, method);
        if (returnType.getKind() == TypeKind.VOID) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Getter methods must not be void on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        if (prefix.equals(IS_PREFIX) && returnType.getKind() != TypeKind.BOOLEAN) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Getter methods starting with 'is' must return a boolean on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        if (!method.getParameters().isEmpty()) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Getter methods cannot take parameters on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return null;
        }
        if (((Boolean)new IsInvalidTypeVisitor().visit(returnType)).booleanValue()) {
            return null;
        }
        return getterMatcher.toMatchResult();
    }

    private void printNoImplementationMessage(TypeElement valueType, ExecutableElement method) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, "No implementation found for non-getter method '" + method + "'; " + "cannot generate @FreeBuilder implementation", valueType);
    }

    private String generatedBuilderSimpleName(TypeElement type) {
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        String originalName = type.getQualifiedName().toString();
        Preconditions.checkState((boolean)originalName.startsWith(packageName + "."));
        String nameWithoutPackage = originalName.substring(packageName.length() + 1);
        return String.format(BUILDER_SIMPLE_NAME_TEMPLATE, nameWithoutPackage.replaceAll("\\.", "_"));
    }

    private boolean shouldBuilderBeSerializable(Optional<TypeElement> builder) {
        if (!builder.isPresent()) {
            return true;
        }
        return Iterables.any(((TypeElement)builder.get()).getInterfaces(), this.isEqualTo(Serializable.class));
    }

    private static final boolean hasUpperCase(int codepoint) {
        return Character.toUpperCase(codepoint) != codepoint;
    }

    private static Optional<Metadata.StandardMethod> maybeStandardMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (methodName.equals("equals")) {
            if (method.getParameters().size() == 1 && method.getParameters().get(0).asType().toString().equals("java.lang.Object")) {
                return Optional.of((Object)((Object)Metadata.StandardMethod.EQUALS));
            }
            return Optional.absent();
        }
        if (methodName.equals("hashCode")) {
            if (method.getParameters().isEmpty()) {
                return Optional.of((Object)((Object)Metadata.StandardMethod.HASH_CODE));
            }
            return Optional.absent();
        }
        if (methodName.equals("toString")) {
            if (method.getParameters().isEmpty()) {
                return Optional.of((Object)((Object)Metadata.StandardMethod.TO_STRING));
            }
            return Optional.absent();
        }
        return Optional.absent();
    }

    private static String camelCaseToAllCaps(String camelCase) {
        return camelCase.replaceAll("(?<=[^A-Z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][^A-Z])", "_").toUpperCase();
    }

    private Predicate<TypeMirror> isEqualTo(Class<?> cls) {
        final TypeMirror typeMirror = this.elements.getTypeElement(cls.getCanonicalName()).asType();
        return new Predicate<TypeMirror>(){

            public boolean apply(TypeMirror input) {
                return Analyser.this.types.isSameType(input, typeMirror);
            }
        };
    }

    private static Optional<ParameterizedType> parameterized(Optional<TypeElement> type, List<? extends TypeParameterElement> typeParameters) {
        if (!type.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)QualifiedName.of((TypeElement)type.get()).withParameters(typeParameters));
    }

    private static final class IsSubclassOfGeneratedTypeVisitor
    extends SimpleTypeVisitor6<Boolean, Void> {
        private final QualifiedName superclass;
        private final List<? extends TypeParameterElement> typeParameters;

        private IsSubclassOfGeneratedTypeVisitor(QualifiedName superclass, List<? extends TypeParameterElement> typeParameters) {
            super(false);
            this.superclass = superclass;
            this.typeParameters = typeParameters;
        }

        @Override
        public Boolean visitError(ErrorType t, Void p) {
            if (this.typeParameters.isEmpty()) {
                String simpleName = t.toString();
                return Objects.equal((Object)simpleName, (Object)this.superclass.getSimpleName());
            }
            return true;
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            return ModelUtils.asElement(t).getQualifiedName().contentEquals(this.superclass.toString());
        }
    }

    private class ConfigImpl
    implements PropertyCodeGenerator.Config {
        private final TypeElement builder;
        private final Metadata.Property property;
        private final ExecutableElement getterMethod;
        private final Set<String> methodsInvokedInBuilderConstructor;

        ConfigImpl(TypeElement builder, Metadata.Property property, ExecutableElement getterMethod, Set<String> methodsInvokedInBuilderConstructor) {
            this.builder = builder;
            this.property = property;
            this.getterMethod = getterMethod;
            this.methodsInvokedInBuilderConstructor = methodsInvokedInBuilderConstructor;
        }

        @Override
        public TypeElement getBuilder() {
            return this.builder;
        }

        @Override
        public Metadata.Property getProperty() {
            return this.property;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotations() {
            return this.getterMethod.getAnnotationMirrors();
        }

        @Override
        public Set<String> getMethodsInvokedInBuilderConstructor() {
            return this.methodsInvokedInBuilderConstructor;
        }

        @Override
        public Elements getElements() {
            return Analyser.this.elements;
        }

        @Override
        public Types getTypes() {
            return Analyser.this.types;
        }
    }

    public static class CannotGenerateCodeException
    extends Exception {
    }
}

