/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.SourceBuilder;

public enum BuilderFactory {
    NO_ARGS_CONSTRUCTOR{

        @Override
        public Excerpt newBuilder(final ParameterizedType builderType, final TypeInference typeInference) {
            return new Excerpt(){

                @Override
                public void addTo(SourceBuilder code) {
                    if (typeInference == TypeInference.INFERRED_TYPES) {
                        code.add("%s()", builderType.constructor());
                    } else {
                        code.add("new %s()", builderType);
                    }
                }
            };
        }
    }
    ,
    BUILDER_METHOD{

        @Override
        public Excerpt newBuilder(final ParameterizedType builderType, final TypeInference typeInference) {
            return new Excerpt(){

                @Override
                public void addTo(SourceBuilder code) {
                    if (typeInference == TypeInference.INFERRED_TYPES) {
                        code.add("%s.builder()", builderType.getQualifiedName().getEnclosingType());
                    } else {
                        code.add("%s.%sbuilder()", builderType.getQualifiedName().getEnclosingType(), builderType.typeParameters());
                    }
                }
            };
        }
    }
    ,
    NEW_BUILDER_METHOD{

        @Override
        public Excerpt newBuilder(final ParameterizedType builderType, final TypeInference typeInference) {
            return new Excerpt(){

                @Override
                public void addTo(SourceBuilder code) {
                    if (typeInference == TypeInference.INFERRED_TYPES) {
                        code.add("%s.newBuilder()", builderType.getQualifiedName().getEnclosingType());
                    } else {
                        code.add("%s.%snewBuilder()", builderType.getQualifiedName().getEnclosingType(), builderType.typeParameters());
                    }
                }
            };
        }
    };


    public static Optional<BuilderFactory> from(TypeElement builderType) {
        ImmutableSet<String> staticMethods = BuilderFactory.findPotentialStaticFactoryMethods(builderType);
        if (BuilderFactory.typeIsAbstract(builderType)) {
            return Optional.absent();
        }
        if (staticMethods.contains((Object)"builder")) {
            return Optional.of((Object)((Object)BUILDER_METHOD));
        }
        if (staticMethods.contains((Object)"newBuilder")) {
            return Optional.of((Object)((Object)NEW_BUILDER_METHOD));
        }
        if (BuilderFactory.hasExplicitNoArgsConstructor(builderType)) {
            return Optional.of((Object)((Object)NO_ARGS_CONSTRUCTOR));
        }
        return Optional.absent();
    }

    public abstract Excerpt newBuilder(ParameterizedType var1, TypeInference var2);

    private static boolean typeIsAbstract(TypeElement type) {
        return type.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private static boolean hasExplicitNoArgsConstructor(TypeElement type) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(type.getEnclosedElements())) {
            if (!constructor.getParameters().isEmpty() || constructor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    private static ImmutableSet<String> findPotentialStaticFactoryMethods(TypeElement builderType) {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        Element valueType = builderType.getEnclosingElement();
        for (ExecutableElement method : ElementFilter.methodsIn(valueType.getEnclosedElements())) {
            Set<Modifier> modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE) || !method.getParameters().isEmpty() || !builderType.asType().toString().equals(method.getReturnType().toString())) continue;
            resultBuilder.add((Object)method.getSimpleName().toString());
        }
        return resultBuilder.build();
    }

    public static enum TypeInference {
        EXPLICIT_TYPES,
        INFERRED_TYPES;

    }
}

