/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Generated;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public class CodeGenerator {
    private static final Predicate<Metadata.Property> IS_REQUIRED = new Predicate<Metadata.Property>(){

        public boolean apply(Metadata.Property property) {
            return property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.REQUIRED;
        }
    };
    private static final Predicate<Metadata.Property> IS_OPTIONAL = new Predicate<Metadata.Property>(){

        public boolean apply(Metadata.Property property) {
            return property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL;
        }
    };
    private static final Predicate<Metadata.Property> HAS_DEFAULT = new Predicate<Metadata.Property>(){

        public boolean apply(Metadata.Property property) {
            return property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.HAS_DEFAULT;
        }
    };

    void writeBuilderSource(SourceBuilder code, Metadata metadata) {
        if (!metadata.hasBuilder()) {
            this.writeStubSource(code, metadata);
            return;
        }
        this.addBuilderTypeDeclaration(code, metadata);
        code.addLine(" {", new Object[0]);
        CodeGenerator.addStaticFromMethod(code, metadata);
        CodeGenerator.addConstantDeclarations(metadata, code);
        if (Iterables.any(metadata.getProperties(), IS_REQUIRED)) {
            CodeGenerator.addPropertyEnum(metadata, code);
        }
        CodeGenerator.addFieldDeclarations(code, metadata);
        CodeGenerator.addAccessors(metadata, code);
        CodeGenerator.addMergeFromValueMethod(code, metadata);
        CodeGenerator.addMergeFromBuilderMethod(code, metadata);
        CodeGenerator.addClearMethod(code, metadata);
        CodeGenerator.addBuildMethod(code, metadata);
        CodeGenerator.addBuildPartialMethod(code, metadata);
        CodeGenerator.addValueType(code, metadata);
        CodeGenerator.addPartialType(code, metadata);
        for (Function nestedClass : metadata.getNestedClasses()) {
            code.add((Excerpt)nestedClass.apply((Object)metadata));
        }
        CodeGenerator.addStaticMethods(code, metadata);
        code.addLine("}", new Object[0]);
    }

    private void addBuilderTypeDeclaration(SourceBuilder code, Metadata metadata) {
        code.addLine("/**", new Object[0]).addLine(" * Auto-generated superclass of %s,", metadata.getBuilder().javadocLink()).addLine(" * derived from the API of %s.", metadata.getType().javadocLink()).addLine(" */", new Object[0]).addLine("@%s(\"%s\")", Generated.class, this.getClass().getName());
        for (Excerpt annotation : metadata.getGeneratedBuilderAnnotations()) {
            code.add(annotation);
        }
        code.add("abstract class %s", metadata.getGeneratedBuilder().declaration());
        if (metadata.isBuilderSerializable()) {
            code.add(" implements %s", Serializable.class);
        }
    }

    private static void addStaticFromMethod(SourceBuilder code, Metadata metadata) {
        BuilderFactory builderFactory = (BuilderFactory)((Object)metadata.getBuilderFactory().orNull());
        if (builderFactory == null) {
            return;
        }
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Creates a new builder using {@code value} as a template.", new Object[0]).addLine(" */", new Object[0]).addLine("public static %s %s from(%s value) {", metadata.getBuilder().declarationParameters(), metadata.getBuilder(), metadata.getType()).addLine("  return %s.mergeFrom(value);", builderFactory.newBuilder(metadata.getBuilder(), BuilderFactory.TypeInference.EXPLICIT_TYPES)).addLine("}", new Object[0]);
    }

    private static void addConstantDeclarations(Metadata metadata, SourceBuilder body) {
        if (body.feature(GuavaLibrary.GUAVA).isAvailable() && metadata.getProperties().size() > 1) {
            body.addLine("", new Object[0]).addLine("private static final %1$s COMMA_JOINER = %1$s.on(\", \").skipNulls();", Joiner.class);
        }
    }

    private static void addFieldDeclarations(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]);
        for (Metadata.Property property : metadata.getProperties()) {
            PropertyCodeGenerator codeGenerator = property.getCodeGenerator();
            codeGenerator.addBuilderFieldDeclaration(code);
        }
        if (Iterables.any(metadata.getProperties(), IS_REQUIRED)) {
            code.addLine("private final %s<%s> _unsetProperties =", EnumSet.class, metadata.getPropertyEnum()).addLine("    %s.allOf(%s.class);", EnumSet.class, metadata.getPropertyEnum());
        }
    }

    private static void addAccessors(Metadata metadata, SourceBuilder body) {
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addBuilderFieldAccessors(body, metadata);
        }
    }

    private static void addBuildMethod(SourceBuilder code, Metadata metadata) {
        boolean hasRequiredProperties = Iterables.any(metadata.getProperties(), IS_REQUIRED);
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns a newly-created %s based on the contents of the {@code %s}.", metadata.getType().javadocLink(), metadata.getBuilder().getSimpleName());
        if (hasRequiredProperties) {
            code.addLine(" *", new Object[0]).addLine(" * @throws IllegalStateException if any field has not been set", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s build() {", metadata.getType());
        if (hasRequiredProperties) {
            code.add(PreconditionExcerpts.checkState("_unsetProperties.isEmpty()", "Not set: %s", "_unsetProperties"));
        }
        code.addLine("  return %s(this);", metadata.getValueType().constructor()).addLine("}", new Object[0]);
    }

    private static void addMergeFromValueMethod(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets all property values using the given {@code %s} as a template.", metadata.getType().getQualifiedName()).addLine(" */", new Object[0]).addLine("public %s mergeFrom(%s value) {", metadata.getBuilder(), metadata.getType());
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addMergeFromValue(code, "value");
        }
        code.add("  return (%s) this;\n", metadata.getBuilder());
        code.addLine("}", new Object[0]);
    }

    private static void addMergeFromBuilderMethod(SourceBuilder code, Metadata metadata) {
        boolean hasRequiredProperties = Iterables.any(metadata.getProperties(), IS_REQUIRED);
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Copies values from the given {@code %s}.", metadata.getBuilder().getSimpleName());
        if (hasRequiredProperties) {
            code.addLine(" * Does not affect any properties not set on the input.", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %1$s mergeFrom(%1$s template) {", metadata.getBuilder());
        if (hasRequiredProperties) {
            code.addLine("  // Upcast to access the private _unsetProperties field.", new Object[0]).addLine("  // Otherwise, oddly, we get an access violation.", new Object[0]).addLine("  %s<%s> _templateUnset = ((%s) template)._unsetProperties;", EnumSet.class, metadata.getPropertyEnum(), metadata.getGeneratedBuilder());
        }
        for (Metadata.Property property : metadata.getProperties()) {
            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.REQUIRED) {
                code.addLine("  if (!_templateUnset.contains(%s.%s)) {", metadata.getPropertyEnum(), property.getAllCapsName());
                property.getCodeGenerator().addMergeFromBuilder(code, metadata, "template");
                code.addLine("  }", new Object[0]);
                continue;
            }
            property.getCodeGenerator().addMergeFromBuilder(code, metadata, "template");
        }
        code.addLine("  return (%s) this;", metadata.getBuilder());
        code.addLine("}", new Object[0]);
    }

    private static void addClearMethod(SourceBuilder code, Metadata metadata) {
        if (metadata.getBuilderFactory().isPresent()) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Resets the state of this builder.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s clear() {", metadata.getBuilder());
            List codeGenerators = Lists.transform(metadata.getProperties(), Metadata.GET_CODE_GENERATOR);
            if (Iterables.any((Iterable)codeGenerators, PropertyCodeGenerator.IS_TEMPLATE_REQUIRED_IN_CLEAR)) {
                code.addLine("  %s _template = %s;", metadata.getGeneratedBuilder(), ((BuilderFactory)((Object)metadata.getBuilderFactory().get())).newBuilder(metadata.getBuilder(), BuilderFactory.TypeInference.INFERRED_TYPES));
            }
            for (PropertyCodeGenerator codeGenerator : codeGenerators) {
                if (codeGenerator.isTemplateRequiredInClear()) {
                    codeGenerator.addClear(code, "_template");
                    continue;
                }
                codeGenerator.addClear(code, null);
            }
            if (Iterables.any(metadata.getProperties(), IS_REQUIRED)) {
                code.addLine("  _unsetProperties.clear();", new Object[0]).addLine("  _unsetProperties.addAll(_template._unsetProperties);", metadata.getGeneratedBuilder());
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        } else {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Ensures a subsequent mergeFrom call will make a clone of its input.", new Object[0]).addLine(" *", new Object[0]).addLine(" * <p>The exact implementation of this method is not guaranteed to remain", new Object[0]).addLine(" * stable; it should always be followed directly by a mergeFrom call.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s clear() {", metadata.getBuilder());
            for (Metadata.Property property : metadata.getProperties()) {
                property.getCodeGenerator().addPartialClear(code);
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }
    }

    private static void addBuildPartialMethod(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns a newly-created partial %s", metadata.getType().javadocLink()).addLine(" * based on the contents of the {@code %s}.", metadata.getBuilder().getSimpleName()).addLine(" * State checking will not be performed.", new Object[0]);
        if (Iterables.any(metadata.getProperties(), IS_REQUIRED)) {
            code.addLine(" * Unset properties will throw an {@link %s}", UnsupportedOperationException.class).addLine(" * when accessed via the partial object.", new Object[0]);
        }
        code.addLine(" *", new Object[0]).addLine(" * <p>Partials should only ever be used in tests.", new Object[0]).addLine(" */", new Object[0]);
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("@%s()", VisibleForTesting.class);
        }
        code.addLine("public %s buildPartial() {", metadata.getType()).addLine("  return %s(this);", metadata.getPartialType().constructor()).addLine("}", new Object[0]);
    }

    private static void addPropertyEnum(Metadata metadata, SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("private enum %s {", metadata.getPropertyEnum().getSimpleName());
        for (Metadata.Property property : metadata.getProperties()) {
            if (property.getCodeGenerator().getType() != PropertyCodeGenerator.Type.REQUIRED) continue;
            code.addLine("  %s(\"%s\"),", property.getAllCapsName(), property.getName());
        }
        code.addLine("  ;", new Object[0]).addLine("", new Object[0]).addLine("  private final %s name;", String.class).addLine("", new Object[0]).addLine("  private %s(%s name) {", metadata.getPropertyEnum().getSimpleName(), String.class).addLine("    this.name = name;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @%s public %s toString() {", Override.class, String.class).addLine("    return name;", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    private static void addValueType(SourceBuilder code, Metadata metadata) {
        code.addLine("", new Object[0]);
        for (Excerpt annotation : metadata.getValueTypeAnnotations()) {
            code.add(annotation);
        }
        code.addLine("%s static final class %s %s {", metadata.getValueTypeVisibility(), metadata.getValueType().declaration(), CodeGenerator.extending(metadata.getType(), metadata.isInterfaceType()));
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addValueFieldDeclaration(code, property.getName());
        }
        code.addLine("", new Object[0]).addLine("  private %s(%s builder) {", metadata.getValueType().getSimpleName(), metadata.getGeneratedBuilder());
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addFinalFieldAssignment(code, "this." + property.getName(), "builder");
        }
        code.addLine("  }", new Object[0]);
        for (Metadata.Property property : metadata.getProperties()) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class);
            property.getCodeGenerator().addGetterAnnotations(code);
            code.addLine("  public %s %s() {", property.getType(), property.getGetterName());
            code.add("    return ", new Object[0]);
            property.getCodeGenerator().addReadValueFragment(code, property.getName());
            code.add(";\n", new Object[0]);
            code.addLine("  }", new Object[0]);
        }
        switch (metadata.standardMethodUnderride(Metadata.StandardMethod.EQUALS)) {
            case ABSENT: {
                code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean equals(Object obj) {", new Object[0]).addLine("    if (!(obj instanceof %s)) {", metadata.getValueType().getQualifiedName()).addLine("      return false;", new Object[0]).addLine("    }", new Object[0]).addLine("    %1$s other = (%1$s) obj;", metadata.getValueType().withWildcards());
                if (metadata.getProperties().isEmpty()) {
                    code.addLine("    return true;", new Object[0]);
                } else if (code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                    String prefix = "    return ";
                    for (Metadata.Property property : metadata.getProperties()) {
                        code.add(prefix, new Object[0]);
                        code.add("%1$s.equals(%2$s, other.%2$s)", code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().get(), property.getName());
                        prefix = "\n        && ";
                    }
                    code.add(";\n", new Object[0]);
                } else {
                    for (Metadata.Property property : metadata.getProperties()) {
                        switch (property.getType().getKind()) {
                            case FLOAT: 
                            case DOUBLE: {
                                code.addLine("    if (%s.doubleToLongBits(%s)", Double.class, property.getName()).addLine("        != %s.doubleToLongBits(other.%s)) {", Double.class, property.getName());
                                break;
                            }
                            default: {
                                if (property.getType().getKind().isPrimitive()) {
                                    code.addLine("    if (%1$s != other.%1$s) {", property.getName());
                                    break;
                                }
                                if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL) {
                                    code.addLine("    if (%1$s != other.%1$s", property.getName()).addLine("        && (%1$s == null || !%1$s.equals(other.%1$s))) {", property.getName());
                                    break;
                                }
                                code.addLine("    if (!%1$s.equals(other.%1$s)) {", property.getName());
                            }
                        }
                        code.addLine("      return false;", new Object[0]).addLine("    }", new Object[0]);
                    }
                    code.addLine("    return true;", new Object[0]);
                }
                code.addLine("  }", new Object[0]);
                break;
            }
            case OVERRIDEABLE: {
                code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean equals(Object obj) {", new Object[0]).addLine("    return (!(obj instanceof %s) && super.equals(obj));", metadata.getPartialType().getQualifiedName()).addLine("  }", new Object[0]);
                break;
            }
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.HASH_CODE) == Metadata.UnderrideLevel.ABSENT) {
            String properties = Joiner.on((String)", ").join(CodeGenerator.getNames(metadata.getProperties()));
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public int hashCode() {", new Object[0]);
            if (code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                code.addLine("    return %s.hash(%s);", code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().get(), properties);
            } else {
                code.addLine("    return %s.hashCode(new Object[] { %s });", Arrays.class, properties);
            }
            code.addLine("  }", new Object[0]);
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.TO_STRING) == Metadata.UnderrideLevel.ABSENT) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s toString() {", String.class).add("    return \"%s{", metadata.getType().getSimpleName());
            switch (metadata.getProperties().size()) {
                case 0: {
                    code.add("}\";\n", new Object[0]);
                    break;
                }
                case 1: {
                    Metadata.Property property = (Metadata.Property)Iterables.getOnlyElement(metadata.getProperties());
                    if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL) {
                        code.add("\" + (%1$s != null ? \"%1$s=\" + %1$s : \"\") + \"}\";\n", property.getName());
                        break;
                    }
                    code.add("%1$s=\" + %1$s + \"}\";\n", property.getName());
                    break;
                }
                default: {
                    Metadata.Property lastProperty;
                    if (Iterables.any(metadata.getProperties(), IS_OPTIONAL)) {
                        code.add("\"\n", new Object[0]).add("        + COMMA_JOINER.join(\n", new Object[0]);
                        lastProperty = (Metadata.Property)Iterables.getLast(metadata.getProperties());
                        for (Metadata.Property property : metadata.getProperties()) {
                            code.add("            ", new Object[0]);
                            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL) {
                                code.add("(%s != null ? ", property.getName());
                            }
                            code.add("\"%1$s=\" + %1$s", property.getName());
                            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.OPTIONAL) {
                                code.add(" : null)", new Object[0]);
                            }
                            if (property != lastProperty) {
                                code.add(",\n", new Object[0]);
                                continue;
                            }
                            code.add(")\n", new Object[0]);
                        }
                        code.addLine("        + \"}\";", new Object[0]);
                        break;
                    }
                    code.add("\"\n", new Object[0]);
                    lastProperty = (Metadata.Property)Iterables.getLast(metadata.getProperties());
                    for (Metadata.Property property : metadata.getProperties()) {
                        code.add("        + \"%1$s=\" + %1$s", property.getName());
                        if (property != lastProperty) {
                            code.add(" + \", \"\n", new Object[0]);
                            continue;
                        }
                        code.add(" + \"}\";\n", new Object[0]);
                    }
                }
            }
            code.addLine("  }", new Object[0]);
        }
        code.addLine("}", new Object[0]);
    }

    private static void addPartialType(SourceBuilder code, Metadata metadata) {
        boolean hasRequiredProperties = Iterables.any(metadata.getProperties(), IS_REQUIRED);
        code.addLine("", new Object[0]).addLine("private static final class %s %s {", metadata.getPartialType().declaration(), CodeGenerator.extending(metadata.getType(), metadata.isInterfaceType()));
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addValueFieldDeclaration(code, property.getName());
        }
        if (hasRequiredProperties) {
            code.addLine("  private final %s<%s> _unsetProperties;", EnumSet.class, metadata.getPropertyEnum());
        }
        code.addLine("", new Object[0]).addLine("  %s(%s builder) {", metadata.getPartialType().getSimpleName(), metadata.getGeneratedBuilder());
        for (Metadata.Property property : metadata.getProperties()) {
            property.getCodeGenerator().addPartialFieldAssignment(code, "this." + property.getName(), "builder");
        }
        if (hasRequiredProperties) {
            code.addLine("    this._unsetProperties = builder._unsetProperties.clone();", new Object[0]);
        }
        code.addLine("  }", new Object[0]);
        for (Metadata.Property property : metadata.getProperties()) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class);
            property.getCodeGenerator().addGetterAnnotations(code);
            code.addLine("  public %s %s() {", property.getType(), property.getGetterName());
            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.REQUIRED) {
                code.addLine("    if (_unsetProperties.contains(%s.%s)) {", metadata.getPropertyEnum(), property.getAllCapsName()).addLine("      throw new %s(\"%s not set\");", UnsupportedOperationException.class, property.getName()).addLine("    }", new Object[0]);
            }
            code.add("    return ", new Object[0]);
            property.getCodeGenerator().addReadValueFragment(code, property.getName());
            code.add(";\n", new Object[0]);
            code.addLine("  }", new Object[0]);
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.EQUALS) != Metadata.UnderrideLevel.FINAL) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean equals(Object obj) {", new Object[0]).addLine("    if (!(obj instanceof %s)) {", metadata.getPartialType().getQualifiedName()).addLine("      return false;", new Object[0]).addLine("    }", new Object[0]).addLine("    %1$s other = (%1$s) obj;", metadata.getPartialType().withWildcards());
            if (metadata.getProperties().isEmpty()) {
                code.addLine("    return true;", new Object[0]);
            } else if (code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                String prefix = "    return ";
                for (Metadata.Property property : metadata.getProperties()) {
                    code.add(prefix, new Object[0]);
                    code.add("%1$s.equals(%2$s, other.%2$s)", code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().get(), property.getName());
                    prefix = "\n        && ";
                }
                if (hasRequiredProperties) {
                    code.add(prefix, new Object[0]);
                    code.add("%1$s.equals(_unsetProperties, other._unsetProperties)", code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().get());
                }
                code.add(";\n", new Object[0]);
            } else {
                for (Metadata.Property property : metadata.getProperties()) {
                    switch (property.getType().getKind()) {
                        case FLOAT: 
                        case DOUBLE: {
                            code.addLine("    if (%s.doubleToLongBits(%s)", Double.class, property.getName()).addLine("        != %s.doubleToLongBits(other.%s)) {", Double.class, property.getName());
                            break;
                        }
                        default: {
                            if (property.getType().getKind().isPrimitive()) {
                                code.addLine("    if (%1$s != other.%1$s) {", property.getName());
                                break;
                            }
                            if (property.getCodeGenerator().getType() == PropertyCodeGenerator.Type.HAS_DEFAULT) {
                                code.addLine("    if (!%1$s.equals(other.%1$s)) {", property.getName());
                                break;
                            }
                            code.addLine("    if (%1$s != other.%1$s", property.getName()).addLine("        && (%1$s == null || !%1$s.equals(other.%1$s))) {", property.getName());
                        }
                    }
                    code.addLine("      return false;", new Object[0]).addLine("    }", new Object[0]);
                }
                if (hasRequiredProperties) {
                    code.addLine("    return _unsetProperties.equals(other._unsetProperties);", new Object[0]);
                } else {
                    code.addLine("    return true;", new Object[0]);
                }
            }
            code.addLine("  }", new Object[0]);
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.HASH_CODE) != Metadata.UnderrideLevel.FINAL) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public int hashCode() {", new Object[0]);
            ImmutableList namesList = CodeGenerator.getNames(metadata.getProperties());
            if (hasRequiredProperties) {
                namesList = ImmutableList.builder().addAll(namesList).add((Object)"_unsetProperties").build();
            }
            String properties = Joiner.on((String)", ").join(namesList);
            if (code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                code.addLine("    return %s.hash(%s);", code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().get(), properties);
            } else {
                code.addLine("    return %s.hashCode(new Object[] { %s });", Arrays.class, properties);
            }
            code.addLine("  }", new Object[0]);
        }
        if (metadata.standardMethodUnderride(Metadata.StandardMethod.TO_STRING) != Metadata.UnderrideLevel.FINAL) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s toString() {", String.class);
            if (metadata.getProperties().size() > 1 && !code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                CodeGenerator.writePartialToStringWithBuilder(code, metadata);
            } else {
                CodeGenerator.writePartialToStringWithConcatenation(code, metadata);
            }
            code.addLine("  }", new Object[0]);
        }
        code.addLine("}", new Object[0]);
    }

    private static void writePartialToStringWithBuilder(SourceBuilder code, Metadata metadata) {
        boolean noDefaults;
        code.addLine("%1$s result = new %1$s(\"partial %2$s{\");", StringBuilder.class, metadata.getType().getSimpleName());
        boolean bl = noDefaults = !Iterables.any(metadata.getProperties(), HAS_DEFAULT);
        if (noDefaults) {
            code.addLine("String separator = \"\";", new Object[0]);
        }
        boolean seenDefault = false;
        Metadata.Property first = (Metadata.Property)metadata.getProperties().get(0);
        Metadata.Property last = (Metadata.Property)Iterables.getLast(metadata.getProperties());
        for (Metadata.Property property : metadata.getProperties()) {
            boolean hadSeenDefault = seenDefault;
            switch (property.getCodeGenerator().getType()) {
                case HAS_DEFAULT: {
                    seenDefault = true;
                    break;
                }
                case OPTIONAL: {
                    code.addLine("if (%s != null) {", property.getName());
                    break;
                }
                case REQUIRED: {
                    code.addLine("if (!_unsetProperties.contains(%s.%s)) {", metadata.getPropertyEnum(), property.getAllCapsName());
                }
            }
            if (noDefaults && property != first) {
                code.addLine("result.append(separator);", new Object[0]);
            } else if (!noDefaults && hadSeenDefault) {
                code.addLine("result.append(\", \");", new Object[0]);
            }
            code.addLine("result.append(\"%1$s=\").append(%1$s);", property.getName());
            if (!noDefaults && !seenDefault) {
                code.addLine("result.append(\", \");", new Object[0]);
            } else if (noDefaults && property != last) {
                code.addLine("separator = \", \";", new Object[0]);
            }
            switch (property.getCodeGenerator().getType()) {
                case HAS_DEFAULT: {
                    break;
                }
                case OPTIONAL: 
                case REQUIRED: {
                    code.addLine("}", new Object[0]);
                }
            }
        }
        code.addLine("result.append(\"}\");", new Object[0]).addLine("return result.toString();", new Object[0]);
    }

    private static void writePartialToStringWithConcatenation(SourceBuilder code, Metadata metadata) {
        code.add("    return \"partial %s{", metadata.getType().getSimpleName());
        switch (metadata.getProperties().size()) {
            case 0: {
                code.add("}\";\n", new Object[0]);
                break;
            }
            case 1: {
                Metadata.Property property = (Metadata.Property)Iterables.getOnlyElement(metadata.getProperties());
                switch (property.getCodeGenerator().getType()) {
                    case HAS_DEFAULT: {
                        code.add("%1$s=\" + %1$s + \"}\";\n", property.getName());
                        break;
                    }
                    case OPTIONAL: {
                        code.add("\"\n", new Object[0]).addLine("        + (%1$s != null ? \"%1$s=\" + %1$s : \"\")", property.getName()).addLine("        + \"}\";", new Object[0]);
                        break;
                    }
                    case REQUIRED: {
                        code.add("\"\n", new Object[0]).addLine("        + (!_unsetProperties.contains(%s.%s)", metadata.getPropertyEnum(), property.getAllCapsName()).addLine("            ? \"%1$s=\" + %1$s : \"\")", property.getName()).addLine("        + \"}\";", new Object[0]);
                    }
                }
                break;
            }
            default: {
                code.add("\"\n", new Object[0]).add("        + COMMA_JOINER.join(\n", new Object[0]);
                Metadata.Property lastProperty = (Metadata.Property)Iterables.getLast(metadata.getProperties());
                for (Metadata.Property property : metadata.getProperties()) {
                    code.add("            ", new Object[0]);
                    switch (property.getCodeGenerator().getType()) {
                        case HAS_DEFAULT: {
                            code.add("\"%1$s=\" + %1$s", property.getName());
                            break;
                        }
                        case OPTIONAL: {
                            code.add("(%1$s != null ? \"%1$s=\" + %1$s : null)", property.getName());
                            break;
                        }
                        case REQUIRED: {
                            code.add("(!_unsetProperties.contains(%s.%s)\n", metadata.getPropertyEnum(), property.getAllCapsName()).add("                ? \"%1$s=\" + %1$s : null)", property.getName());
                        }
                    }
                    if (property != lastProperty) {
                        code.add(",\n", new Object[0]);
                        continue;
                    }
                    code.add(")\n", new Object[0]);
                }
                code.addLine("        + \"}\";", new Object[0]);
                break;
            }
        }
    }

    private static void addStaticMethods(SourceBuilder code, Metadata metadata) {
        TreeSet<? extends StaticExcerpt> staticMethods = new TreeSet<StaticExcerpt>();
        for (Metadata.Property property : metadata.getProperties()) {
            staticMethods.addAll(property.getCodeGenerator().getStaticExcerpts());
        }
        for (Excerpt staticMethod : staticMethods) {
            code.add(staticMethod);
        }
    }

    private void writeStubSource(SourceBuilder code, Metadata metadata) {
        code.addLine("/**", new Object[0]).addLine(" * Placeholder. Create {@code %s.Builder} and subclass this type.", metadata.getType()).addLine(" */", new Object[0]).addLine("@%s(\"%s\")", Generated.class, this.getClass().getName()).addLine("abstract class %s {}", metadata.getGeneratedBuilder().declaration());
    }

    private static Excerpt extending(final Object type, final boolean isInterface) {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder source) {
                if (isInterface) {
                    source.add("implements %s", type);
                } else {
                    source.add("extends %s", type);
                }
            }
        };
    }

    private static ImmutableList<String> getNames(Iterable<Metadata.Property> properties) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Metadata.Property property : properties) {
            result.add((Object)property.getName());
        }
        return result.build();
    }
}

