/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;

public class DefaultPropertyFactory
implements PropertyCodeGenerator.Factory {
    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        Metadata.Property property = config.getProperty();
        boolean hasDefault = config.getMethodsInvokedInBuilderConstructor().contains(BuilderMethods.setter(property));
        return Optional.of((Object)new CodeGenerator(property, hasDefault));
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        private final boolean hasDefault;
        private final boolean isPrimitive;

        CodeGenerator(Metadata.Property property, boolean hasDefault) {
            super(property);
            this.hasDefault = hasDefault;
            this.isPrimitive = property.getType().getKind().isPrimitive();
        }

        @Override
        public PropertyCodeGenerator.Type getType() {
            return this.hasDefault ? PropertyCodeGenerator.Type.HAS_DEFAULT : PropertyCodeGenerator.Type.REQUIRED;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("private %s %s;", this.property.getType(), this.property.getName());
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            this.addSetter(code, metadata);
            this.addMapper(code, metadata);
            this.addGetter(code, metadata);
        }

        private void addSetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.isPrimitive) {
                code.addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName());
            }
            code.addLine(" */", new Object[0]);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s %s) {", metadata.getBuilder(), BuilderMethods.setter(this.property), this.property.getType(), this.property.getName());
            if (this.isPrimitive) {
                code.addLine("  this.%1$s = %1$s;", this.property.getName());
            } else {
                code.add(PreconditionExcerpts.checkNotNullPreamble(this.property.getName())).addLine("  this.%s = %s;", this.property.getName(), PreconditionExcerpts.checkNotNullInline(this.property.getName()));
            }
            if (!this.hasDefault) {
                code.addLine("  _unsetProperties.remove(%s.%s);", metadata.getPropertyEnum(), this.property.getAllCapsName());
            }
            if (metadata.getBuilder() == metadata.getGeneratedBuilder()) {
                code.addLine("  return this;", new Object[0]);
            } else {
                code.addLine("  return (%s) this;", metadata.getBuilder());
            }
            code.addLine("}", new Object[0]);
        }

        private void addMapper(SourceBuilder code, Metadata metadata) {
            ParameterizedType unaryOperator = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).unaryOperator().orNull();
            if (unaryOperator == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Replaces the value to be returned by %s", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * by applying {@code mapper} to it and using the result.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mapper} is null or returns null", new Object[0]);
            if (!this.hasDefault) {
                code.addLine(" * @throws IllegalStateException if the field has not been set", new Object[0]);
            }
            TypeMirror typeParam = (TypeMirror)Objects.firstNonNull((Object)this.property.getBoxedType(), (Object)this.property.getType());
            code.addLine(" */", new Object[0]).add("public %s %s(%s mapper) {", metadata.getBuilder(), BuilderMethods.mapper(this.property), unaryOperator.withParameters(typeParam));
            if (!this.hasDefault) {
                code.add(PreconditionExcerpts.checkNotNull("mapper"));
            }
            code.addLine("  return %s(mapper.apply(%s()));", BuilderMethods.setter(this.property), BuilderMethods.getter(this.property)).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, final Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName()));
            if (!this.hasDefault) {
                code.addLine(" *", new Object[0]).addLine(" * @throws IllegalStateException if the field has not been set", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s() {", this.property.getType(), BuilderMethods.getter(this.property));
            if (!this.hasDefault) {
                Excerpt propertyIsSet = new Excerpt(){

                    @Override
                    public void addTo(SourceBuilder source) {
                        source.add("!_unsetProperties.contains(%s.%s)", metadata.getPropertyEnum(), CodeGenerator.this.property.getAllCapsName());
                    }
                };
                code.add(PreconditionExcerpts.checkState(propertyIsSet, this.property.getName() + " not set", new Object[0]));
            }
            code.addLine("  return %s;", this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addValueFieldDeclaration(SourceBuilder code, String finalField) {
            code.add("private final %s %s;\n", this.property.getType(), finalField);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.%s;", finalField, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s(%s.%s());", BuilderMethods.setter(this.property), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s(%s.%s());", BuilderMethods.setter(this.property), builder, BuilderMethods.getter(this.property));
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return true;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%1$s = %2$s.%1$s;", this.property.getName(), template);
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
        }
    }
}

