/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;

class JacksonSupport {
    private static final String JSON_DESERIALIZE = "com.fasterxml.jackson.databind.annotation.JsonDeserialize";
    private static final QualifiedName JSON_PROPERTY = QualifiedName.of("com.fasterxml.jackson.annotation", "JsonProperty", new String[0]);
    private static final Set<QualifiedName> DISABLE_PROPERTY_ANNOTATIONS = ImmutableSet.of((Object)QualifiedName.of("com.fasterxml.jackson.annotation", "JsonAnyGetter", new String[0]), (Object)QualifiedName.of("com.fasterxml.jackson.annotation", "JsonIgnore", new String[0]), (Object)QualifiedName.of("com.fasterxml.jackson.annotation", "JsonUnwrapped", new String[0]), (Object)QualifiedName.of("com.fasterxml.jackson.annotation", "JsonValue", new String[0]));

    public static Optional<JacksonSupport> create(TypeElement userValueType) {
        if (ModelUtils.findAnnotationMirror((Element)userValueType, JSON_DESERIALIZE).isPresent()) {
            return Optional.of((Object)new JacksonSupport());
        }
        return Optional.absent();
    }

    private JacksonSupport() {
    }

    public void addJacksonAnnotations(Metadata.Property.Builder resultBuilder, ExecutableElement getterMethod) {
        Optional<AnnotationMirror> annotation = ModelUtils.findAnnotationMirror((Element)getterMethod, JSON_PROPERTY);
        if (annotation.isPresent()) {
            resultBuilder.addAccessorAnnotations(new AnnotationExcerpt((AnnotationMirror)annotation.get()));
        } else if (JacksonSupport.generateDefaultAnnotations(getterMethod)) {
            resultBuilder.addAccessorAnnotations(new JsonPropertyExcerpt(resultBuilder.getName()));
        }
    }

    private static boolean generateDefaultAnnotations(ExecutableElement getterMethod) {
        for (AnnotationMirror annotationMirror : getterMethod.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            QualifiedName annotationType = QualifiedName.of(annotationTypeElement);
            if (!DISABLE_PROPERTY_ANNOTATIONS.contains(annotationType)) continue;
            return false;
        }
        return true;
    }

    private static class JsonPropertyExcerpt
    implements Excerpt {
        private final String propertyName;

        JsonPropertyExcerpt(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("@%s(\"%s\")", JSON_PROPERTY, this.propertyName);
        }
    }

    private static class AnnotationExcerpt
    implements Excerpt {
        private final AnnotationMirror annotation;

        AnnotationExcerpt(AnnotationMirror annotation) {
            this.annotation = annotation;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("%s", this.annotation);
        }
    }
}

