/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.collect.ImmutableSet;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import org.inferred.freebuilder.processor.MethodIntrospector;

class JavacMethodIntrospector
extends MethodIntrospector {
    private final Trees trees;
    private static final SimpleTreeVisitor<TreeAnalysis, ?> OWN_METHOD_INVOCATIONS_FETCHER = new SimpleTreeVisitor<TreeAnalysis, Void>(){

        @Override
        public TreeAnalysis visitMethod(MethodTree node, Void p) {
            TreeAnalysis result = new TreeAnalysis();
            for (StatementTree statementTree : node.getBody().getStatements()) {
                TreeAnalysis statementAnalysis = statementTree.accept(this, p);
                result.names.addAll(statementAnalysis.names);
                if (!statementAnalysis.explicitReturn) continue;
                result.explicitReturn = true;
                return result;
            }
            return result;
        }

        @Override
        public TreeAnalysis visitExpressionStatement(ExpressionStatementTree node, Void p) {
            return node.getExpression().accept(this, p);
        }

        @Override
        public TreeAnalysis visitMethodInvocation(MethodInvocationTree node, Void p) {
            return node.getMethodSelect().accept(this, p);
        }

        @Override
        public TreeAnalysis visitIdentifier(IdentifierTree node, Void p) {
            TreeAnalysis result = new TreeAnalysis();
            result.names.add(node.getName());
            return result;
        }

        @Override
        public TreeAnalysis visitMemberSelect(MemberSelectTree node, Void p) {
            TreeAnalysis result = new TreeAnalysis();
            ExpressionTree lhs = node.getExpression();
            if (lhs.getKind() != Tree.Kind.IDENTIFIER) {
                return result;
            }
            if (!((IdentifierTree)lhs).getName().contentEquals("this")) {
                return result;
            }
            result.names.add(node.getIdentifier());
            return result;
        }

        @Override
        protected TreeAnalysis defaultAction(Tree node, Void p) {
            TreeAnalysis result = new TreeAnalysis();
            result.explicitReturn = RETURN_TREE_FINDER.scan(node, null) != null;
            return result;
        }
    };
    private static final TreeScanner<ReturnTree, ?> RETURN_TREE_FINDER = new TreeScanner<ReturnTree, Void>(){

        @Override
        public ReturnTree visitReturn(ReturnTree node, Void p) {
            return node;
        }

        @Override
        public ReturnTree reduce(ReturnTree r1, ReturnTree r2) {
            return r1 != null ? r1 : r2;
        }
    };

    public static MethodIntrospector instance(ProcessingEnvironment env) {
        return new JavacMethodIntrospector(Trees.instance(env));
    }

    private JavacMethodIntrospector(Trees trees) {
        this.trees = trees;
    }

    @Override
    public Set<Name> getOwnMethodInvocations(ExecutableElement method) {
        try {
            return ImmutableSet.copyOf((Collection)this.trees.getTree(method).accept(OWN_METHOD_INVOCATIONS_FETCHER, null).names);
        }
        catch (RuntimeException e) {
            return ImmutableSet.of();
        }
    }

    private static class TreeAnalysis {
        private final Set<Name> names = new HashSet<Name>();
        private boolean explicitReturn = false;

        private TreeAnalysis() {
        }
    }
}

