/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.excerpt.CheckedList;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public class ListPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final StaticExcerpt IMMUTABLE_LIST = new StaticExcerpt(StaticExcerpt.Type.METHOD, "immutableList"){

        @Override
        public void addTo(SourceBuilder code) {
            if (!code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("", new Object[0]).addLine("@%s(\"unchecked\")", SuppressWarnings.class).addLine("private static <E> %1$s<E> immutableList(%1$s<E> elements, %2$s<E> type) {", List.class, Class.class).addLine("  switch (elements.size()) {", new Object[0]).addLine("  case 0:", new Object[0]).addLine("    return %s.emptyList();", Collections.class).addLine("  case 1:", new Object[0]).addLine("    return %s.singletonList(elements.get(0));", Collections.class).addLine("  default:", new Object[0]).addLine("    return %s.unmodifiableList(%s.asList(elements.toArray(", Collections.class, Arrays.class).addLine("        (E[]) %s.newInstance(type, elements.size()))));", Array.class).addLine("  }", new Object[0]).addLine("}", new Object[0]);
            }
        }
    };

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        DeclaredType type = (DeclaredType)ModelUtils.maybeDeclared(config.getProperty().getType()).orNull();
        if (type == null || !Util.erasesToAnyOf(type, Collection.class, List.class, ImmutableList.class)) {
            return Optional.absent();
        }
        TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
        Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
        boolean overridesAddMethod = ListPropertyFactory.hasAddMethodOverride(config, (TypeMirror)unboxedType.or((Object)elementType));
        return Optional.of((Object)new CodeGenerator(config.getProperty(), overridesAddMethod, elementType, unboxedType));
    }

    private static boolean hasAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror keyType) {
        return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), keyType);
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        private static final ParameterizedType COLLECTION = QualifiedName.of(Collection.class).withParameters("E");
        private final boolean overridesAddMethod;
        private final TypeMirror elementType;
        private final Optional<TypeMirror> unboxedType;

        @VisibleForTesting
        CodeGenerator(Metadata.Property property, boolean overridesAddMethod, TypeMirror elementType, Optional<TypeMirror> unboxedType) {
            super(property);
            this.overridesAddMethod = overridesAddMethod;
            this.elementType = elementType;
            this.unboxedType = unboxedType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("private final %1$s<%2$s> %3$s = new %1$s<%4$s>();", ArrayList.class, this.elementType, this.property.getName(), code.feature(SourceLevel.SOURCE_LEVEL).supportsDiamondOperator() ? "" : this.elementType);
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            this.addAdd(code, metadata);
            this.addVarargsAdd(code, metadata);
            this.addAddAll(code, metadata);
            this.addMutate(code, metadata);
            this.addClear(code, metadata);
            this.addGetter(code, metadata);
        }

        private void addAdd(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the list to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", metadata.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.or((Object)this.elementType));
            if (this.unboxedType.isPresent()) {
                code.addLine("  this.%s.add(element);", this.property.getName());
            } else {
                code.add(PreconditionExcerpts.checkNotNullPreamble("element")).addLine("  this.%s.add(%s);", this.property.getName(), PreconditionExcerpts.checkNotNullInline("element"));
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addVarargsAdd(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the list to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s... elements) {", metadata.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.or((Object)this.elementType)).addLine("  %1$s.ensureCapacity(%1$s.size() + elements.length);", this.property.getName()).addLine("  for (%s element : elements) {", this.unboxedType.or((Object)this.elementType)).addLine("    %s(element);", BuilderMethods.addMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addAddAll(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the list to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s<? extends %s> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType).addLine("  if (elements instanceof %s) {", Collection.class).addLine("    %1$s.ensureCapacity(%1$s.size() + ((%2$s<?>) elements).size());", this.property.getName(), Collection.class).addLine("  }", new Object[0]).addLine("  for (%s element : elements) {", this.unboxedType.or((Object)this.elementType)).addLine("    %s(element);", BuilderMethods.addMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addMutate(SourceBuilder code, Metadata metadata) {
            ParameterizedType consumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).consumer().orNull();
            if (consumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the list to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the list in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", COLLECTION.javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s<? super %s<%s>> mutator) {", metadata.getBuilder(), BuilderMethods.mutator(this.property), consumer.getQualifiedName(), List.class, this.elementType);
            if (this.overridesAddMethod) {
                code.addLine("  mutator.accept(new CheckedList<>(%s, this::%s));", this.property.getName(), BuilderMethods.addMethod(this.property));
            } else {
                code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.addMethod(this.property)).addLine("  mutator.accept(%s);", this.property.getName());
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addClear(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the list to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", metadata.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  this.%s.clear();", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the list that will be returned by", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s() {", List.class, this.elementType, BuilderMethods.getter(this.property)).addLine("  return %s.unmodifiableList(%s);", Collections.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("%s = %s.copyOf(%s.%s);", finalField, ImmutableList.class, builder, this.property.getName());
            } else {
                code.addLine("%s = immutableList(%s.%s, %s.class);", finalField, builder, this.property.getName(), this.elementType);
            }
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s(%s.%s());", BuilderMethods.addAllMethod(this.property), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s(((%s) %s).%s);", BuilderMethods.addAllMethod(this.property), metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, BuilderMethods.addAllMethod(this.property), variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return false;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%s.clear();", this.property.getName());
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            code.addLine("%s.clear();", this.property.getName());
        }

        public Set<StaticExcerpt> getStaticExcerpts() {
            ImmutableSet.Builder methods = ImmutableSet.builder();
            methods.add((Object)IMMUTABLE_LIST);
            if (this.overridesAddMethod) {
                methods.addAll(CheckedList.excerpts());
            }
            return methods.build();
        }
    }
}

