/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.excerpt.CheckedMap;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public class MapPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final StaticExcerpt IMMUTABLE_MAP = new StaticExcerpt(StaticExcerpt.Type.METHOD, "immutableMap"){

        @Override
        public void addTo(SourceBuilder code) {
            if (!code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("", new Object[0]).addLine("private static <K, V> %1$s<K, V> immutableMap(%1$s<K, V> entries) {", Map.class).addLine("  switch (entries.size()) {", new Object[0]).addLine("  case 0:", new Object[0]).addLine("    return %s.emptyMap();", Collections.class).addLine("  case 1:", new Object[0]).addLine("    %s<K, V> entry = entries.entrySet().iterator().next();", Map.Entry.class).addLine("    return %s.singletonMap(entry.getKey(), entry.getValue());", Collections.class).addLine("  default:", new Object[0]).add("    return %s.unmodifiableMap(new %s<", Collections.class, LinkedHashMap.class);
                if (!code.feature(SourceLevel.SOURCE_LEVEL).supportsDiamondOperator()) {
                    code.add("K, V", new Object[0]);
                }
                code.add(">(entries));\n", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
            }
        }
    };

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        DeclaredType type = (DeclaredType)ModelUtils.maybeDeclared(config.getProperty().getType()).orNull();
        if (type == null || !Util.erasesToAnyOf(type, Map.class, ImmutableMap.class)) {
            return Optional.absent();
        }
        TypeMirror keyType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
        TypeMirror valueType = Util.upperBound(config.getElements(), type.getTypeArguments().get(1));
        Optional<TypeMirror> unboxedKeyType = ModelUtils.maybeUnbox(keyType, config.getTypes());
        Optional<TypeMirror> unboxedValueType = ModelUtils.maybeUnbox(valueType, config.getTypes());
        boolean overridesPutMethod = MapPropertyFactory.hasPutMethodOverride(config, (TypeMirror)unboxedKeyType.or((Object)keyType), (TypeMirror)unboxedValueType.or((Object)valueType));
        return Optional.of((Object)new CodeGenerator(config.getProperty(), overridesPutMethod, keyType, unboxedKeyType, valueType, unboxedValueType));
    }

    private static boolean hasPutMethodOverride(PropertyCodeGenerator.Config config, TypeMirror keyType, TypeMirror valueType) {
        return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.putMethod(config.getProperty()), keyType, valueType);
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        private static final ParameterizedType COLLECTION = QualifiedName.of(Collection.class).withParameters("E");
        private final boolean overridesPutMethod;
        private final TypeMirror keyType;
        private final Optional<TypeMirror> unboxedKeyType;
        private final TypeMirror valueType;
        private final Optional<TypeMirror> unboxedValueType;

        CodeGenerator(Metadata.Property property, boolean overridesPutMethod, TypeMirror keyType, Optional<TypeMirror> unboxedKeyType, TypeMirror valueType, Optional<TypeMirror> unboxedValueType) {
            super(property);
            this.overridesPutMethod = overridesPutMethod;
            this.keyType = keyType;
            this.unboxedKeyType = unboxedKeyType;
            this.valueType = valueType;
            this.unboxedValueType = unboxedValueType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.add("private final %1$s<%2$s, %3$s> %4$s = new %1$s<", LinkedHashMap.class, this.keyType, this.valueType, this.property.getName());
            if (!code.feature(SourceLevel.SOURCE_LEVEL).supportsDiamondOperator()) {
                code.add("%s, %s", this.keyType, this.valueType);
            }
            code.add(">();\n", new Object[0]);
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code, Metadata metadata) {
            this.addPut(code, metadata);
            this.addPutAll(code, metadata);
            this.addRemove(code, metadata);
            this.addMutate(code, metadata);
            this.addClear(code, metadata);
            this.addGetter(code, metadata);
        }

        private void addPut(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Associates {@code key} with {@code value} in the map to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * If the map previously contained a mapping for the key,", new Object[0]).addLine(" * the old value is replaced by the specified value.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
                code.add(" * @throws NullPointerException if ", new Object[0]);
                if (this.unboxedKeyType.isPresent()) {
                    code.add("{@code value} is", new Object[0]);
                } else if (this.unboxedValueType.isPresent()) {
                    code.add("{@code key} is", new Object[0]);
                } else {
                    code.add("either {@code key} or {@code value} are", new Object[0]);
                }
                code.add(" null\n", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s key, %s value) {", metadata.getBuilder(), BuilderMethods.putMethod(this.property), this.unboxedKeyType.or((Object)this.keyType), this.unboxedValueType.or((Object)this.valueType));
            if (!this.unboxedKeyType.isPresent()) {
                code.add(PreconditionExcerpts.checkNotNull("key"));
            }
            if (!this.unboxedValueType.isPresent()) {
                code.add(PreconditionExcerpts.checkNotNull("value"));
            }
            code.addLine("  %s.put(key, value);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addPutAll(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Copies all of the mappings from {@code map} to the map to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code map} is null or contains a", new Object[0]).addLine(" *     null key or value", new Object[0]).addLine(" */", new Object[0]);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s<? extends %s, ? extends %s> map) {", metadata.getBuilder(), BuilderMethods.putAllMethod(this.property), Map.class, this.keyType, this.valueType).addLine("  for (%s<? extends %s, ? extends %s> entry : map.entrySet()) {", Map.Entry.class, this.keyType, this.valueType).addLine("    %s(entry.getKey(), entry.getValue());", BuilderMethods.putMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addRemove(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes the mapping for {@code key} from the map to be returned from", new Object[0]).addLine(" * %s, if one is present.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedKeyType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code key} is null", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s key) {", metadata.getBuilder(), BuilderMethods.removeMethod(this.property), this.unboxedKeyType.or((Object)this.keyType));
            if (!this.unboxedKeyType.isPresent()) {
                code.add(PreconditionExcerpts.checkNotNull("key"));
            }
            code.addLine("  %s.remove(key);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addMutate(SourceBuilder code, Metadata metadata) {
            ParameterizedType consumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).consumer().orNull();
            if (consumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Invokes {@code mutator} with the map to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the map in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", COLLECTION.javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s<? super %s<%s, %s>> mutator) {", metadata.getBuilder(), BuilderMethods.mutator(this.property), consumer.getQualifiedName(), Map.class, this.keyType, this.valueType);
            if (this.overridesPutMethod) {
                code.addLine("  mutator.accept(new CheckedMap<>(%s, this::%s));", this.property.getName(), BuilderMethods.putMethod(this.property));
            } else {
                code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.putMethod(this.property)).addLine("  mutator.accept(%s);", this.property.getName());
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addClear(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes all of the mappings from the map to be returned from ", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", metadata.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  %s.clear();", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the map that will be returned by", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s, %s> %s() {", Map.class, this.keyType, this.valueType, BuilderMethods.getter(this.property)).addLine("  return %s.unmodifiableMap(%s);", Collections.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.add("%s = ", finalField);
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.add("%s.copyOf", ImmutableMap.class);
            } else {
                code.add("immutableMap", new Object[0]);
            }
            code.add("(%s.%s);\n", builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(SourceBuilder code, String value) {
            code.addLine("%s(%s.%s());", BuilderMethods.putAllMethod(this.property), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(SourceBuilder code, Metadata metadata, String builder) {
            code.addLine("%s(((%s) %s).%s);", BuilderMethods.putAllMethod(this.property), metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, BuilderMethods.putAllMethod(this.property), variable);
        }

        @Override
        public boolean isTemplateRequiredInClear() {
            return false;
        }

        @Override
        public void addClear(SourceBuilder code, String template) {
            code.addLine("%s.clear();", this.property.getName());
        }

        @Override
        public void addPartialClear(SourceBuilder code) {
            code.addLine("%s.clear();", this.property.getName());
        }

        public Set<StaticExcerpt> getStaticExcerpts() {
            ImmutableSet.Builder result = ImmutableSet.builder();
            result.add((Object)IMMUTABLE_MAP);
            if (this.overridesPutMethod) {
                result.addAll(CheckedMap.excerpts());
            }
            return result.build();
        }
    }
}

