/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Metadata_Builder;
import org.inferred.freebuilder.processor.Metadata_Property_Builder;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;

public abstract class Metadata {
    public static final Function<Property, PropertyCodeGenerator> GET_CODE_GENERATOR = new Function<Property, PropertyCodeGenerator>(){

        public PropertyCodeGenerator apply(Property input) {
            return input.getCodeGenerator();
        }
    };

    public abstract ParameterizedType getType();

    public abstract boolean isInterfaceType();

    abstract Optional<ParameterizedType> getOptionalBuilder();

    public boolean hasBuilder() {
        return this.getOptionalBuilder().isPresent();
    }

    public ParameterizedType getBuilder() {
        return (ParameterizedType)this.getOptionalBuilder().get();
    }

    public abstract Optional<BuilderFactory> getBuilderFactory();

    public abstract ParameterizedType getGeneratedBuilder();

    public abstract ParameterizedType getValueType();

    public abstract ParameterizedType getPartialType();

    public abstract ImmutableSet<QualifiedName> getVisibleNestedTypes();

    public abstract ParameterizedType getPropertyEnum();

    public abstract ImmutableList<Property> getProperties();

    public UnderrideLevel standardMethodUnderride(StandardMethod standardMethod) {
        UnderrideLevel underrideLevel = (UnderrideLevel)((Object)this.getStandardMethodUnderrides().get((Object)standardMethod));
        return underrideLevel == null ? UnderrideLevel.ABSENT : underrideLevel;
    }

    public abstract ImmutableMap<StandardMethod, UnderrideLevel> getStandardMethodUnderrides();

    public abstract boolean isBuilderSerializable();

    public abstract ImmutableList<Excerpt> getGeneratedBuilderAnnotations();

    public abstract ImmutableList<Excerpt> getValueTypeAnnotations();

    public abstract Visibility getValueTypeVisibility();

    public abstract ImmutableList<Function<Metadata, Excerpt>> getNestedClasses();

    public static class Builder
    extends Metadata_Builder {
        public Builder() {
            super.setValueTypeVisibility(Visibility.PRIVATE);
        }

        @Override
        public Builder setValueTypeVisibility(Visibility visibility) {
            return super.setValueTypeVisibility(Visibility.mostVisible(this.getValueTypeVisibility(), visibility));
        }

        public Builder setBuilder(Optional<ParameterizedType> builder) {
            return this.setOptionalBuilder((Optional)builder);
        }

        public Builder setBuilder(ParameterizedType builder) {
            return this.setOptionalBuilder(builder);
        }

        @Override
        public Metadata build() {
            Metadata metadata = super.build();
            QualifiedName generatedBuilder = metadata.getGeneratedBuilder().getQualifiedName();
            Preconditions.checkState((boolean)metadata.getValueType().getQualifiedName().getEnclosingType().equals(generatedBuilder), (String)"%s not a nested class of %s", (Object[])new Object[]{metadata.getValueType(), generatedBuilder});
            Preconditions.checkState((boolean)metadata.getPartialType().getQualifiedName().getEnclosingType().equals(generatedBuilder), (String)"%s not a nested class of %s", (Object[])new Object[]{metadata.getPartialType(), generatedBuilder});
            Preconditions.checkState((boolean)metadata.getPropertyEnum().getQualifiedName().getEnclosingType().equals(generatedBuilder), (String)"%s not a nested class of %s", (Object[])new Object[]{metadata.getPropertyEnum(), generatedBuilder});
            return metadata;
        }
    }

    public static interface Property {
        public TypeMirror getType();

        @Nullable
        public TypeMirror getBoxedType();

        public String getName();

        public String getCapitalizedName();

        public String getAllCapsName();

        public String getGetterName();

        @Nullable
        public PropertyCodeGenerator getCodeGenerator();

        public boolean isFullyCheckedCast();

        public ImmutableList<Excerpt> getAccessorAnnotations();

        public static class Builder
        extends Metadata_Property_Builder {
        }
    }

    public static enum Visibility implements Excerpt
    {
        PUBLIC("public "),
        PROTECTED("protected "),
        PACKAGE(""),
        PRIVATE("private ");

        private final String excerpt;

        private Visibility(String excerpt) {
            this.excerpt = excerpt;
        }

        public static Visibility mostVisible(Visibility a, Visibility b) {
            return (Visibility)Ordering.natural().min((Object)a, (Object)b);
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.add(this.excerpt, new Object[0]);
        }
    }

    public static enum UnderrideLevel {
        ABSENT,
        OVERRIDEABLE,
        FINAL;

    }

    public static enum StandardMethod {
        TO_STRING,
        HASH_CODE,
        EQUALS;

    }
}

