/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.QualifiedName;

abstract class Metadata_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private ParameterizedType type;
    private boolean interfaceType;
    private ParameterizedType optionalBuilder = null;
    private BuilderFactory builderFactory = null;
    private ParameterizedType generatedBuilder;
    private ParameterizedType valueType;
    private ParameterizedType partialType;
    private final LinkedHashSet<QualifiedName> visibleNestedTypes = new LinkedHashSet();
    private ParameterizedType propertyEnum;
    private final ArrayList<Metadata.Property> properties = new ArrayList();
    private final LinkedHashMap<Metadata.StandardMethod, Metadata.UnderrideLevel> standardMethodUnderrides = new LinkedHashMap();
    private boolean builderSerializable;
    private final ArrayList<Excerpt> generatedBuilderAnnotations = new ArrayList();
    private final ArrayList<Excerpt> valueTypeAnnotations = new ArrayList();
    private Metadata.Visibility valueTypeVisibility;
    private final ArrayList<Function<Metadata, Excerpt>> nestedClasses = new ArrayList();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Metadata_Builder() {
    }

    public Metadata.Builder setType(ParameterizedType type) {
        this.type = (ParameterizedType)Preconditions.checkNotNull((Object)type);
        this._unsetProperties.remove((Object)Property.TYPE);
        return (Metadata.Builder)this;
    }

    public ParameterizedType getType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TYPE) ? 1 : 0) != 0, (Object)"type not set");
        return this.type;
    }

    public Metadata.Builder setInterfaceType(boolean interfaceType) {
        this.interfaceType = interfaceType;
        this._unsetProperties.remove((Object)Property.INTERFACE_TYPE);
        return (Metadata.Builder)this;
    }

    public boolean isInterfaceType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.INTERFACE_TYPE) ? 1 : 0) != 0, (Object)"interfaceType not set");
        return this.interfaceType;
    }

    public Metadata.Builder setOptionalBuilder(ParameterizedType optionalBuilder) {
        this.optionalBuilder = (ParameterizedType)Preconditions.checkNotNull((Object)optionalBuilder);
        return (Metadata.Builder)this;
    }

    public Metadata.Builder setOptionalBuilder(Optional<? extends ParameterizedType> optionalBuilder) {
        if (optionalBuilder.isPresent()) {
            return this.setOptionalBuilder((ParameterizedType)optionalBuilder.get());
        }
        return this.clearOptionalBuilder();
    }

    public Metadata.Builder setNullableOptionalBuilder(@Nullable ParameterizedType optionalBuilder) {
        if (optionalBuilder != null) {
            return this.setOptionalBuilder(optionalBuilder);
        }
        return this.clearOptionalBuilder();
    }

    public Metadata.Builder clearOptionalBuilder() {
        this.optionalBuilder = null;
        return (Metadata.Builder)this;
    }

    public Optional<ParameterizedType> getOptionalBuilder() {
        return Optional.fromNullable((Object)this.optionalBuilder);
    }

    public Metadata.Builder setBuilderFactory(BuilderFactory builderFactory) {
        this.builderFactory = (BuilderFactory)((Object)Preconditions.checkNotNull((Object)((Object)builderFactory)));
        return (Metadata.Builder)this;
    }

    public Metadata.Builder setBuilderFactory(Optional<? extends BuilderFactory> builderFactory) {
        if (builderFactory.isPresent()) {
            return this.setBuilderFactory((BuilderFactory)((Object)builderFactory.get()));
        }
        return this.clearBuilderFactory();
    }

    public Metadata.Builder setNullableBuilderFactory(@Nullable BuilderFactory builderFactory) {
        if (builderFactory != null) {
            return this.setBuilderFactory(builderFactory);
        }
        return this.clearBuilderFactory();
    }

    public Metadata.Builder clearBuilderFactory() {
        this.builderFactory = null;
        return (Metadata.Builder)this;
    }

    public Optional<BuilderFactory> getBuilderFactory() {
        return Optional.fromNullable((Object)((Object)this.builderFactory));
    }

    public Metadata.Builder setGeneratedBuilder(ParameterizedType generatedBuilder) {
        this.generatedBuilder = (ParameterizedType)Preconditions.checkNotNull((Object)generatedBuilder);
        this._unsetProperties.remove((Object)Property.GENERATED_BUILDER);
        return (Metadata.Builder)this;
    }

    public ParameterizedType getGeneratedBuilder() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.GENERATED_BUILDER) ? 1 : 0) != 0, (Object)"generatedBuilder not set");
        return this.generatedBuilder;
    }

    public Metadata.Builder setValueType(ParameterizedType valueType) {
        this.valueType = (ParameterizedType)Preconditions.checkNotNull((Object)valueType);
        this._unsetProperties.remove((Object)Property.VALUE_TYPE);
        return (Metadata.Builder)this;
    }

    public ParameterizedType getValueType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.VALUE_TYPE) ? 1 : 0) != 0, (Object)"valueType not set");
        return this.valueType;
    }

    public Metadata.Builder setPartialType(ParameterizedType partialType) {
        this.partialType = (ParameterizedType)Preconditions.checkNotNull((Object)partialType);
        this._unsetProperties.remove((Object)Property.PARTIAL_TYPE);
        return (Metadata.Builder)this;
    }

    public ParameterizedType getPartialType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.PARTIAL_TYPE) ? 1 : 0) != 0, (Object)"partialType not set");
        return this.partialType;
    }

    public Metadata.Builder addVisibleNestedTypes(QualifiedName element) {
        this.visibleNestedTypes.add((QualifiedName)Preconditions.checkNotNull((Object)element));
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addVisibleNestedTypes(QualifiedName ... elements) {
        for (QualifiedName element : elements) {
            this.addVisibleNestedTypes(element);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addAllVisibleNestedTypes(Iterable<? extends QualifiedName> elements) {
        for (QualifiedName qualifiedName : elements) {
            this.addVisibleNestedTypes(qualifiedName);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clearVisibleNestedTypes() {
        this.visibleNestedTypes.clear();
        return (Metadata.Builder)this;
    }

    public Set<QualifiedName> getVisibleNestedTypes() {
        return Collections.unmodifiableSet(this.visibleNestedTypes);
    }

    public Metadata.Builder setPropertyEnum(ParameterizedType propertyEnum) {
        this.propertyEnum = (ParameterizedType)Preconditions.checkNotNull((Object)propertyEnum);
        this._unsetProperties.remove((Object)Property.PROPERTY_ENUM);
        return (Metadata.Builder)this;
    }

    public ParameterizedType getPropertyEnum() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.PROPERTY_ENUM) ? 1 : 0) != 0, (Object)"propertyEnum not set");
        return this.propertyEnum;
    }

    public Metadata.Builder addProperties(Metadata.Property element) {
        this.properties.add((Metadata.Property)Preconditions.checkNotNull((Object)element));
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addProperties(Metadata.Property ... elements) {
        this.properties.ensureCapacity(this.properties.size() + elements.length);
        for (Metadata.Property element : elements) {
            this.addProperties(element);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addAllProperties(Iterable<? extends Metadata.Property> elements) {
        if (elements instanceof Collection) {
            this.properties.ensureCapacity(this.properties.size() + ((Collection)elements).size());
        }
        for (Metadata.Property property : elements) {
            this.addProperties(property);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clearProperties() {
        this.properties.clear();
        return (Metadata.Builder)this;
    }

    public List<Metadata.Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public Metadata.Builder putStandardMethodUnderrides(Metadata.StandardMethod key, Metadata.UnderrideLevel value) {
        Preconditions.checkNotNull((Object)((Object)key));
        Preconditions.checkNotNull((Object)((Object)value));
        Preconditions.checkArgument((!this.standardMethodUnderrides.containsKey((Object)key) ? 1 : 0) != 0, (String)"Key already present in standardMethodUnderrides: %s", (Object[])new Object[]{key});
        this.standardMethodUnderrides.put(key, value);
        return (Metadata.Builder)this;
    }

    public Metadata.Builder putAllStandardMethodUnderrides(Map<? extends Metadata.StandardMethod, ? extends Metadata.UnderrideLevel> map) {
        for (Map.Entry<? extends Metadata.StandardMethod, ? extends Metadata.UnderrideLevel> entry : map.entrySet()) {
            this.putStandardMethodUnderrides(entry.getKey(), entry.getValue());
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder removeStandardMethodUnderrides(Metadata.StandardMethod key) {
        Preconditions.checkNotNull((Object)((Object)key));
        Preconditions.checkArgument((boolean)this.standardMethodUnderrides.containsKey((Object)key), (String)"Key not present in standardMethodUnderrides: %s", (Object[])new Object[]{key});
        this.standardMethodUnderrides.remove((Object)key);
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clearStandardMethodUnderrides() {
        this.standardMethodUnderrides.clear();
        return (Metadata.Builder)this;
    }

    public Map<Metadata.StandardMethod, Metadata.UnderrideLevel> getStandardMethodUnderrides() {
        return Collections.unmodifiableMap(this.standardMethodUnderrides);
    }

    public Metadata.Builder setBuilderSerializable(boolean builderSerializable) {
        this.builderSerializable = builderSerializable;
        this._unsetProperties.remove((Object)Property.BUILDER_SERIALIZABLE);
        return (Metadata.Builder)this;
    }

    public boolean isBuilderSerializable() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE) ? 1 : 0) != 0, (Object)"builderSerializable not set");
        return this.builderSerializable;
    }

    public Metadata.Builder addGeneratedBuilderAnnotations(Excerpt element) {
        this.generatedBuilderAnnotations.add((Excerpt)Preconditions.checkNotNull((Object)element));
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addGeneratedBuilderAnnotations(Excerpt ... elements) {
        this.generatedBuilderAnnotations.ensureCapacity(this.generatedBuilderAnnotations.size() + elements.length);
        for (Excerpt element : elements) {
            this.addGeneratedBuilderAnnotations(element);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addAllGeneratedBuilderAnnotations(Iterable<? extends Excerpt> elements) {
        if (elements instanceof Collection) {
            this.generatedBuilderAnnotations.ensureCapacity(this.generatedBuilderAnnotations.size() + ((Collection)elements).size());
        }
        for (Excerpt excerpt : elements) {
            this.addGeneratedBuilderAnnotations(excerpt);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clearGeneratedBuilderAnnotations() {
        this.generatedBuilderAnnotations.clear();
        return (Metadata.Builder)this;
    }

    public List<Excerpt> getGeneratedBuilderAnnotations() {
        return Collections.unmodifiableList(this.generatedBuilderAnnotations);
    }

    public Metadata.Builder addValueTypeAnnotations(Excerpt element) {
        this.valueTypeAnnotations.add((Excerpt)Preconditions.checkNotNull((Object)element));
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addValueTypeAnnotations(Excerpt ... elements) {
        this.valueTypeAnnotations.ensureCapacity(this.valueTypeAnnotations.size() + elements.length);
        for (Excerpt element : elements) {
            this.addValueTypeAnnotations(element);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addAllValueTypeAnnotations(Iterable<? extends Excerpt> elements) {
        if (elements instanceof Collection) {
            this.valueTypeAnnotations.ensureCapacity(this.valueTypeAnnotations.size() + ((Collection)elements).size());
        }
        for (Excerpt excerpt : elements) {
            this.addValueTypeAnnotations(excerpt);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clearValueTypeAnnotations() {
        this.valueTypeAnnotations.clear();
        return (Metadata.Builder)this;
    }

    public List<Excerpt> getValueTypeAnnotations() {
        return Collections.unmodifiableList(this.valueTypeAnnotations);
    }

    public Metadata.Builder setValueTypeVisibility(Metadata.Visibility valueTypeVisibility) {
        this.valueTypeVisibility = (Metadata.Visibility)Preconditions.checkNotNull((Object)valueTypeVisibility);
        this._unsetProperties.remove((Object)Property.VALUE_TYPE_VISIBILITY);
        return (Metadata.Builder)this;
    }

    public Metadata.Visibility getValueTypeVisibility() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.VALUE_TYPE_VISIBILITY) ? 1 : 0) != 0, (Object)"valueTypeVisibility not set");
        return this.valueTypeVisibility;
    }

    public Metadata.Builder addNestedClasses(Function<Metadata, Excerpt> element) {
        this.nestedClasses.add((Function<Metadata, Excerpt>)Preconditions.checkNotNull(element));
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addNestedClasses(Function<Metadata, Excerpt> ... elements) {
        this.nestedClasses.ensureCapacity(this.nestedClasses.size() + elements.length);
        for (Function<Metadata, Excerpt> element : elements) {
            this.addNestedClasses(element);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder addAllNestedClasses(Iterable<? extends Function<Metadata, Excerpt>> elements) {
        if (elements instanceof Collection) {
            this.nestedClasses.ensureCapacity(this.nestedClasses.size() + ((Collection)elements).size());
        }
        for (Function<Metadata, Excerpt> function : elements) {
            this.addNestedClasses(function);
        }
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clearNestedClasses() {
        this.nestedClasses.clear();
        return (Metadata.Builder)this;
    }

    public List<Function<Metadata, Excerpt>> getNestedClasses() {
        return Collections.unmodifiableList(this.nestedClasses);
    }

    public Metadata.Builder mergeFrom(Metadata value) {
        this.setType(value.getType());
        this.setInterfaceType(value.isInterfaceType());
        this.setOptionalBuilder(value.getOptionalBuilder());
        this.setBuilderFactory(value.getBuilderFactory());
        this.setGeneratedBuilder(value.getGeneratedBuilder());
        this.setValueType(value.getValueType());
        this.setPartialType(value.getPartialType());
        this.addAllVisibleNestedTypes((Iterable<? extends QualifiedName>)value.getVisibleNestedTypes());
        this.setPropertyEnum(value.getPropertyEnum());
        this.addAllProperties((Iterable<? extends Metadata.Property>)value.getProperties());
        this.putAllStandardMethodUnderrides((Map<? extends Metadata.StandardMethod, ? extends Metadata.UnderrideLevel>)value.getStandardMethodUnderrides());
        this.setBuilderSerializable(value.isBuilderSerializable());
        this.addAllGeneratedBuilderAnnotations((Iterable<? extends Excerpt>)value.getGeneratedBuilderAnnotations());
        this.addAllValueTypeAnnotations((Iterable<? extends Excerpt>)value.getValueTypeAnnotations());
        this.setValueTypeVisibility(value.getValueTypeVisibility());
        this.addAllNestedClasses((Iterable<? extends Function<Metadata, Excerpt>>)value.getNestedClasses());
        return (Metadata.Builder)this;
    }

    public Metadata.Builder mergeFrom(Metadata.Builder template) {
        EnumSet<Property> _templateUnset = template._unsetProperties;
        if (!_templateUnset.contains((Object)Property.TYPE)) {
            this.setType(template.getType());
        }
        if (!_templateUnset.contains((Object)Property.INTERFACE_TYPE)) {
            this.setInterfaceType(template.isInterfaceType());
        }
        this.setOptionalBuilder((Optional<? extends ParameterizedType>)template.getOptionalBuilder());
        this.setBuilderFactory((Optional<? extends BuilderFactory>)template.getBuilderFactory());
        if (!_templateUnset.contains((Object)Property.GENERATED_BUILDER)) {
            this.setGeneratedBuilder(template.getGeneratedBuilder());
        }
        if (!_templateUnset.contains((Object)Property.VALUE_TYPE)) {
            this.setValueType(template.getValueType());
        }
        if (!_templateUnset.contains((Object)Property.PARTIAL_TYPE)) {
            this.setPartialType(template.getPartialType());
        }
        this.addAllVisibleNestedTypes(template.visibleNestedTypes);
        if (!_templateUnset.contains((Object)Property.PROPERTY_ENUM)) {
            this.setPropertyEnum(template.getPropertyEnum());
        }
        this.addAllProperties(template.properties);
        this.putAllStandardMethodUnderrides(template.standardMethodUnderrides);
        if (!_templateUnset.contains((Object)Property.BUILDER_SERIALIZABLE)) {
            this.setBuilderSerializable(template.isBuilderSerializable());
        }
        this.addAllGeneratedBuilderAnnotations(template.generatedBuilderAnnotations);
        this.addAllValueTypeAnnotations(template.valueTypeAnnotations);
        if (!_templateUnset.contains((Object)Property.VALUE_TYPE_VISIBILITY)) {
            this.setValueTypeVisibility(template.getValueTypeVisibility());
        }
        this.addAllNestedClasses(template.nestedClasses);
        return (Metadata.Builder)this;
    }

    public Metadata.Builder clear() {
        Metadata.Builder _template = new Metadata.Builder();
        this.type = _template.type;
        this.interfaceType = _template.interfaceType;
        this.optionalBuilder = _template.optionalBuilder;
        this.builderFactory = _template.builderFactory;
        this.generatedBuilder = _template.generatedBuilder;
        this.valueType = _template.valueType;
        this.partialType = _template.partialType;
        this.visibleNestedTypes.clear();
        this.propertyEnum = _template.propertyEnum;
        this.properties.clear();
        this.standardMethodUnderrides.clear();
        this.builderSerializable = _template.builderSerializable;
        this.generatedBuilderAnnotations.clear();
        this.valueTypeAnnotations.clear();
        this.valueTypeVisibility = _template.valueTypeVisibility;
        this.nestedClasses.clear();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_template._unsetProperties);
        return (Metadata.Builder)this;
    }

    public Metadata build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public Metadata buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Metadata {
        private final ParameterizedType type;
        private final boolean interfaceType;
        private final ParameterizedType optionalBuilder;
        private final BuilderFactory builderFactory;
        private final ParameterizedType generatedBuilder;
        private final ParameterizedType valueType;
        private final ParameterizedType partialType;
        private final ImmutableSet<QualifiedName> visibleNestedTypes;
        private final ParameterizedType propertyEnum;
        private final ImmutableList<Metadata.Property> properties;
        private final ImmutableMap<Metadata.StandardMethod, Metadata.UnderrideLevel> standardMethodUnderrides;
        private final boolean builderSerializable;
        private final ImmutableList<Excerpt> generatedBuilderAnnotations;
        private final ImmutableList<Excerpt> valueTypeAnnotations;
        private final Metadata.Visibility valueTypeVisibility;
        private final ImmutableList<Function<Metadata, Excerpt>> nestedClasses;
        private final EnumSet<Property> _unsetProperties;

        Partial(Metadata_Builder builder) {
            this.type = builder.type;
            this.interfaceType = builder.interfaceType;
            this.optionalBuilder = builder.optionalBuilder;
            this.builderFactory = builder.builderFactory;
            this.generatedBuilder = builder.generatedBuilder;
            this.valueType = builder.valueType;
            this.partialType = builder.partialType;
            this.visibleNestedTypes = ImmutableSet.copyOf((Collection)builder.visibleNestedTypes);
            this.propertyEnum = builder.propertyEnum;
            this.properties = ImmutableList.copyOf((Collection)builder.properties);
            this.standardMethodUnderrides = ImmutableMap.copyOf((Map)builder.standardMethodUnderrides);
            this.builderSerializable = builder.builderSerializable;
            this.generatedBuilderAnnotations = ImmutableList.copyOf((Collection)builder.generatedBuilderAnnotations);
            this.valueTypeAnnotations = ImmutableList.copyOf((Collection)builder.valueTypeAnnotations);
            this.valueTypeVisibility = builder.valueTypeVisibility;
            this.nestedClasses = ImmutableList.copyOf((Collection)builder.nestedClasses);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public ParameterizedType getType() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        public boolean isInterfaceType() {
            if (this._unsetProperties.contains((Object)Property.INTERFACE_TYPE)) {
                throw new UnsupportedOperationException("interfaceType not set");
            }
            return this.interfaceType;
        }

        @Override
        public Optional<ParameterizedType> getOptionalBuilder() {
            return Optional.fromNullable((Object)this.optionalBuilder);
        }

        @Override
        public Optional<BuilderFactory> getBuilderFactory() {
            return Optional.fromNullable((Object)((Object)this.builderFactory));
        }

        @Override
        public ParameterizedType getGeneratedBuilder() {
            if (this._unsetProperties.contains((Object)Property.GENERATED_BUILDER)) {
                throw new UnsupportedOperationException("generatedBuilder not set");
            }
            return this.generatedBuilder;
        }

        @Override
        public ParameterizedType getValueType() {
            if (this._unsetProperties.contains((Object)Property.VALUE_TYPE)) {
                throw new UnsupportedOperationException("valueType not set");
            }
            return this.valueType;
        }

        @Override
        public ParameterizedType getPartialType() {
            if (this._unsetProperties.contains((Object)Property.PARTIAL_TYPE)) {
                throw new UnsupportedOperationException("partialType not set");
            }
            return this.partialType;
        }

        @Override
        public ImmutableSet<QualifiedName> getVisibleNestedTypes() {
            return this.visibleNestedTypes;
        }

        @Override
        public ParameterizedType getPropertyEnum() {
            if (this._unsetProperties.contains((Object)Property.PROPERTY_ENUM)) {
                throw new UnsupportedOperationException("propertyEnum not set");
            }
            return this.propertyEnum;
        }

        @Override
        public ImmutableList<Metadata.Property> getProperties() {
            return this.properties;
        }

        @Override
        public ImmutableMap<Metadata.StandardMethod, Metadata.UnderrideLevel> getStandardMethodUnderrides() {
            return this.standardMethodUnderrides;
        }

        @Override
        public boolean isBuilderSerializable() {
            if (this._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE)) {
                throw new UnsupportedOperationException("builderSerializable not set");
            }
            return this.builderSerializable;
        }

        @Override
        public ImmutableList<Excerpt> getGeneratedBuilderAnnotations() {
            return this.generatedBuilderAnnotations;
        }

        @Override
        public ImmutableList<Excerpt> getValueTypeAnnotations() {
            return this.valueTypeAnnotations;
        }

        @Override
        public Metadata.Visibility getValueTypeVisibility() {
            if (this._unsetProperties.contains((Object)Property.VALUE_TYPE_VISIBILITY)) {
                throw new UnsupportedOperationException("valueTypeVisibility not set");
            }
            return this.valueTypeVisibility;
        }

        @Override
        public ImmutableList<Function<Metadata, Excerpt>> getNestedClasses() {
            return this.nestedClasses;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            if (!(this.type == other.type || this.type != null && this.type.equals(other.type))) {
                return false;
            }
            if (this.interfaceType != other.interfaceType) {
                return false;
            }
            if (!(this.optionalBuilder == other.optionalBuilder || this.optionalBuilder != null && this.optionalBuilder.equals(other.optionalBuilder))) {
                return false;
            }
            if (!(this.builderFactory == other.builderFactory || this.builderFactory != null && this.builderFactory.equals((Object)other.builderFactory))) {
                return false;
            }
            if (!(this.generatedBuilder == other.generatedBuilder || this.generatedBuilder != null && this.generatedBuilder.equals(other.generatedBuilder))) {
                return false;
            }
            if (!(this.valueType == other.valueType || this.valueType != null && this.valueType.equals(other.valueType))) {
                return false;
            }
            if (!(this.partialType == other.partialType || this.partialType != null && this.partialType.equals(other.partialType))) {
                return false;
            }
            if (!this.visibleNestedTypes.equals(other.visibleNestedTypes)) {
                return false;
            }
            if (!(this.propertyEnum == other.propertyEnum || this.propertyEnum != null && this.propertyEnum.equals(other.propertyEnum))) {
                return false;
            }
            if (!this.properties.equals(other.properties)) {
                return false;
            }
            if (!this.standardMethodUnderrides.equals(other.standardMethodUnderrides)) {
                return false;
            }
            if (this.builderSerializable != other.builderSerializable) {
                return false;
            }
            if (!this.generatedBuilderAnnotations.equals(other.generatedBuilderAnnotations)) {
                return false;
            }
            if (!this.valueTypeAnnotations.equals(other.valueTypeAnnotations)) {
                return false;
            }
            if (!(this.valueTypeVisibility == other.valueTypeVisibility || this.valueTypeVisibility != null && this.valueTypeVisibility.equals(other.valueTypeVisibility))) {
                return false;
            }
            if (!this.nestedClasses.equals(other.nestedClasses)) {
                return false;
            }
            return this._unsetProperties.equals(other._unsetProperties);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.type, this.interfaceType, this.optionalBuilder, this.builderFactory, this.generatedBuilder, this.valueType, this.partialType, this.visibleNestedTypes, this.propertyEnum, this.properties, this.standardMethodUnderrides, this.builderSerializable, this.generatedBuilderAnnotations, this.valueTypeAnnotations, this.valueTypeVisibility, this.nestedClasses, this._unsetProperties});
        }

        public String toString() {
            return "partial Metadata{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.TYPE) ? "type=" + this.type : null), (Object)(!this._unsetProperties.contains((Object)Property.INTERFACE_TYPE) ? "interfaceType=" + this.interfaceType : null), new Object[]{this.optionalBuilder != null ? "optionalBuilder=" + this.optionalBuilder : null, this.builderFactory != null ? "builderFactory=" + (Object)((Object)this.builderFactory) : null, !this._unsetProperties.contains((Object)Property.GENERATED_BUILDER) ? "generatedBuilder=" + this.generatedBuilder : null, !this._unsetProperties.contains((Object)Property.VALUE_TYPE) ? "valueType=" + this.valueType : null, !this._unsetProperties.contains((Object)Property.PARTIAL_TYPE) ? "partialType=" + this.partialType : null, "visibleNestedTypes=" + this.visibleNestedTypes, !this._unsetProperties.contains((Object)Property.PROPERTY_ENUM) ? "propertyEnum=" + this.propertyEnum : null, "properties=" + this.properties, "standardMethodUnderrides=" + this.standardMethodUnderrides, !this._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE) ? "builderSerializable=" + this.builderSerializable : null, "generatedBuilderAnnotations=" + this.generatedBuilderAnnotations, "valueTypeAnnotations=" + this.valueTypeAnnotations, !this._unsetProperties.contains((Object)Property.VALUE_TYPE_VISIBILITY) ? "valueTypeVisibility=" + this.valueTypeVisibility : null, "nestedClasses=" + this.nestedClasses}) + "}";
        }
    }

    private static final class Value
    extends Metadata {
        private final ParameterizedType type;
        private final boolean interfaceType;
        private final ParameterizedType optionalBuilder;
        private final BuilderFactory builderFactory;
        private final ParameterizedType generatedBuilder;
        private final ParameterizedType valueType;
        private final ParameterizedType partialType;
        private final ImmutableSet<QualifiedName> visibleNestedTypes;
        private final ParameterizedType propertyEnum;
        private final ImmutableList<Metadata.Property> properties;
        private final ImmutableMap<Metadata.StandardMethod, Metadata.UnderrideLevel> standardMethodUnderrides;
        private final boolean builderSerializable;
        private final ImmutableList<Excerpt> generatedBuilderAnnotations;
        private final ImmutableList<Excerpt> valueTypeAnnotations;
        private final Metadata.Visibility valueTypeVisibility;
        private final ImmutableList<Function<Metadata, Excerpt>> nestedClasses;

        private Value(Metadata_Builder builder) {
            this.type = builder.type;
            this.interfaceType = builder.interfaceType;
            this.optionalBuilder = builder.optionalBuilder;
            this.builderFactory = builder.builderFactory;
            this.generatedBuilder = builder.generatedBuilder;
            this.valueType = builder.valueType;
            this.partialType = builder.partialType;
            this.visibleNestedTypes = ImmutableSet.copyOf((Collection)builder.visibleNestedTypes);
            this.propertyEnum = builder.propertyEnum;
            this.properties = ImmutableList.copyOf((Collection)builder.properties);
            this.standardMethodUnderrides = ImmutableMap.copyOf((Map)builder.standardMethodUnderrides);
            this.builderSerializable = builder.builderSerializable;
            this.generatedBuilderAnnotations = ImmutableList.copyOf((Collection)builder.generatedBuilderAnnotations);
            this.valueTypeAnnotations = ImmutableList.copyOf((Collection)builder.valueTypeAnnotations);
            this.valueTypeVisibility = builder.valueTypeVisibility;
            this.nestedClasses = ImmutableList.copyOf((Collection)builder.nestedClasses);
        }

        @Override
        public ParameterizedType getType() {
            return this.type;
        }

        @Override
        public boolean isInterfaceType() {
            return this.interfaceType;
        }

        @Override
        public Optional<ParameterizedType> getOptionalBuilder() {
            return Optional.fromNullable((Object)this.optionalBuilder);
        }

        @Override
        public Optional<BuilderFactory> getBuilderFactory() {
            return Optional.fromNullable((Object)((Object)this.builderFactory));
        }

        @Override
        public ParameterizedType getGeneratedBuilder() {
            return this.generatedBuilder;
        }

        @Override
        public ParameterizedType getValueType() {
            return this.valueType;
        }

        @Override
        public ParameterizedType getPartialType() {
            return this.partialType;
        }

        @Override
        public ImmutableSet<QualifiedName> getVisibleNestedTypes() {
            return this.visibleNestedTypes;
        }

        @Override
        public ParameterizedType getPropertyEnum() {
            return this.propertyEnum;
        }

        @Override
        public ImmutableList<Metadata.Property> getProperties() {
            return this.properties;
        }

        @Override
        public ImmutableMap<Metadata.StandardMethod, Metadata.UnderrideLevel> getStandardMethodUnderrides() {
            return this.standardMethodUnderrides;
        }

        @Override
        public boolean isBuilderSerializable() {
            return this.builderSerializable;
        }

        @Override
        public ImmutableList<Excerpt> getGeneratedBuilderAnnotations() {
            return this.generatedBuilderAnnotations;
        }

        @Override
        public ImmutableList<Excerpt> getValueTypeAnnotations() {
            return this.valueTypeAnnotations;
        }

        @Override
        public Metadata.Visibility getValueTypeVisibility() {
            return this.valueTypeVisibility;
        }

        @Override
        public ImmutableList<Function<Metadata, Excerpt>> getNestedClasses() {
            return this.nestedClasses;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            if (!this.type.equals(other.type)) {
                return false;
            }
            if (this.interfaceType != other.interfaceType) {
                return false;
            }
            if (!(this.optionalBuilder == other.optionalBuilder || this.optionalBuilder != null && this.optionalBuilder.equals(other.optionalBuilder))) {
                return false;
            }
            if (!(this.builderFactory == other.builderFactory || this.builderFactory != null && this.builderFactory.equals((Object)other.builderFactory))) {
                return false;
            }
            if (!this.generatedBuilder.equals(other.generatedBuilder)) {
                return false;
            }
            if (!this.valueType.equals(other.valueType)) {
                return false;
            }
            if (!this.partialType.equals(other.partialType)) {
                return false;
            }
            if (!this.visibleNestedTypes.equals(other.visibleNestedTypes)) {
                return false;
            }
            if (!this.propertyEnum.equals(other.propertyEnum)) {
                return false;
            }
            if (!this.properties.equals(other.properties)) {
                return false;
            }
            if (!this.standardMethodUnderrides.equals(other.standardMethodUnderrides)) {
                return false;
            }
            if (this.builderSerializable != other.builderSerializable) {
                return false;
            }
            if (!this.generatedBuilderAnnotations.equals(other.generatedBuilderAnnotations)) {
                return false;
            }
            if (!this.valueTypeAnnotations.equals(other.valueTypeAnnotations)) {
                return false;
            }
            if (!this.valueTypeVisibility.equals(other.valueTypeVisibility)) {
                return false;
            }
            return this.nestedClasses.equals(other.nestedClasses);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.type, this.interfaceType, this.optionalBuilder, this.builderFactory, this.generatedBuilder, this.valueType, this.partialType, this.visibleNestedTypes, this.propertyEnum, this.properties, this.standardMethodUnderrides, this.builderSerializable, this.generatedBuilderAnnotations, this.valueTypeAnnotations, this.valueTypeVisibility, this.nestedClasses});
        }

        public String toString() {
            return "Metadata{" + COMMA_JOINER.join((Object)("type=" + this.type), (Object)("interfaceType=" + this.interfaceType), new Object[]{this.optionalBuilder != null ? "optionalBuilder=" + this.optionalBuilder : null, this.builderFactory != null ? "builderFactory=" + (Object)((Object)this.builderFactory) : null, "generatedBuilder=" + this.generatedBuilder, "valueType=" + this.valueType, "partialType=" + this.partialType, "visibleNestedTypes=" + this.visibleNestedTypes, "propertyEnum=" + this.propertyEnum, "properties=" + this.properties, "standardMethodUnderrides=" + this.standardMethodUnderrides, "builderSerializable=" + this.builderSerializable, "generatedBuilderAnnotations=" + this.generatedBuilderAnnotations, "valueTypeAnnotations=" + this.valueTypeAnnotations, "valueTypeVisibility=" + this.valueTypeVisibility, "nestedClasses=" + this.nestedClasses}) + "}";
        }
    }

    private static enum Property {
        TYPE("type"),
        INTERFACE_TYPE("interfaceType"),
        GENERATED_BUILDER("generatedBuilder"),
        VALUE_TYPE("valueType"),
        PARTIAL_TYPE("partialType"),
        PROPERTY_ENUM("propertyEnum"),
        BUILDER_SERIALIZABLE("builderSerializable"),
        VALUE_TYPE_VISIBILITY("valueTypeVisibility");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

