/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Excerpt;

abstract class Metadata_Property_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private TypeMirror type;
    @Nullable
    private TypeMirror boxedType = null;
    private String name;
    private String capitalizedName;
    private String allCapsName;
    private String getterName;
    @Nullable
    private PropertyCodeGenerator codeGenerator = null;
    private boolean fullyCheckedCast;
    private final ArrayList<Excerpt> accessorAnnotations = new ArrayList();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Metadata_Property_Builder() {
    }

    public Metadata.Property.Builder setType(TypeMirror type) {
        this.type = (TypeMirror)Preconditions.checkNotNull((Object)type);
        this._unsetProperties.remove((Object)Property.TYPE);
        return (Metadata.Property.Builder)this;
    }

    public TypeMirror getType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TYPE) ? 1 : 0) != 0, (Object)"type not set");
        return this.type;
    }

    public Metadata.Property.Builder setBoxedType(@Nullable TypeMirror boxedType) {
        this.boxedType = boxedType;
        return (Metadata.Property.Builder)this;
    }

    @Nullable
    public TypeMirror getBoxedType() {
        return this.boxedType;
    }

    public Metadata.Property.Builder setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (Metadata.Property.Builder)this;
    }

    public String getName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    public Metadata.Property.Builder setCapitalizedName(String capitalizedName) {
        this.capitalizedName = (String)Preconditions.checkNotNull((Object)capitalizedName);
        this._unsetProperties.remove((Object)Property.CAPITALIZED_NAME);
        return (Metadata.Property.Builder)this;
    }

    public String getCapitalizedName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.CAPITALIZED_NAME) ? 1 : 0) != 0, (Object)"capitalizedName not set");
        return this.capitalizedName;
    }

    public Metadata.Property.Builder setAllCapsName(String allCapsName) {
        this.allCapsName = (String)Preconditions.checkNotNull((Object)allCapsName);
        this._unsetProperties.remove((Object)Property.ALL_CAPS_NAME);
        return (Metadata.Property.Builder)this;
    }

    public String getAllCapsName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ALL_CAPS_NAME) ? 1 : 0) != 0, (Object)"allCapsName not set");
        return this.allCapsName;
    }

    public Metadata.Property.Builder setGetterName(String getterName) {
        this.getterName = (String)Preconditions.checkNotNull((Object)getterName);
        this._unsetProperties.remove((Object)Property.GETTER_NAME);
        return (Metadata.Property.Builder)this;
    }

    public String getGetterName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.GETTER_NAME) ? 1 : 0) != 0, (Object)"getterName not set");
        return this.getterName;
    }

    public Metadata.Property.Builder setCodeGenerator(@Nullable PropertyCodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
        return (Metadata.Property.Builder)this;
    }

    @Nullable
    public PropertyCodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public Metadata.Property.Builder setFullyCheckedCast(boolean fullyCheckedCast) {
        this.fullyCheckedCast = fullyCheckedCast;
        this._unsetProperties.remove((Object)Property.FULLY_CHECKED_CAST);
        return (Metadata.Property.Builder)this;
    }

    public boolean isFullyCheckedCast() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.FULLY_CHECKED_CAST) ? 1 : 0) != 0, (Object)"fullyCheckedCast not set");
        return this.fullyCheckedCast;
    }

    public Metadata.Property.Builder addAccessorAnnotations(Excerpt element) {
        this.accessorAnnotations.add((Excerpt)Preconditions.checkNotNull((Object)element));
        return (Metadata.Property.Builder)this;
    }

    public Metadata.Property.Builder addAccessorAnnotations(Excerpt ... elements) {
        this.accessorAnnotations.ensureCapacity(this.accessorAnnotations.size() + elements.length);
        for (Excerpt element : elements) {
            this.addAccessorAnnotations(element);
        }
        return (Metadata.Property.Builder)this;
    }

    public Metadata.Property.Builder addAllAccessorAnnotations(Iterable<? extends Excerpt> elements) {
        if (elements instanceof Collection) {
            this.accessorAnnotations.ensureCapacity(this.accessorAnnotations.size() + ((Collection)elements).size());
        }
        for (Excerpt excerpt : elements) {
            this.addAccessorAnnotations(excerpt);
        }
        return (Metadata.Property.Builder)this;
    }

    public Metadata.Property.Builder clearAccessorAnnotations() {
        this.accessorAnnotations.clear();
        return (Metadata.Property.Builder)this;
    }

    public List<Excerpt> getAccessorAnnotations() {
        return Collections.unmodifiableList(this.accessorAnnotations);
    }

    public Metadata.Property.Builder mergeFrom(Metadata.Property value) {
        this.setType(value.getType());
        this.setBoxedType(value.getBoxedType());
        this.setName(value.getName());
        this.setCapitalizedName(value.getCapitalizedName());
        this.setAllCapsName(value.getAllCapsName());
        this.setGetterName(value.getGetterName());
        this.setCodeGenerator(value.getCodeGenerator());
        this.setFullyCheckedCast(value.isFullyCheckedCast());
        this.addAllAccessorAnnotations((Iterable<? extends Excerpt>)value.getAccessorAnnotations());
        return (Metadata.Property.Builder)this;
    }

    public Metadata.Property.Builder mergeFrom(Metadata.Property.Builder template) {
        EnumSet<Property> _templateUnset = template._unsetProperties;
        if (!_templateUnset.contains((Object)Property.TYPE)) {
            this.setType(template.getType());
        }
        this.setBoxedType(template.getBoxedType());
        if (!_templateUnset.contains((Object)Property.NAME)) {
            this.setName(template.getName());
        }
        if (!_templateUnset.contains((Object)Property.CAPITALIZED_NAME)) {
            this.setCapitalizedName(template.getCapitalizedName());
        }
        if (!_templateUnset.contains((Object)Property.ALL_CAPS_NAME)) {
            this.setAllCapsName(template.getAllCapsName());
        }
        if (!_templateUnset.contains((Object)Property.GETTER_NAME)) {
            this.setGetterName(template.getGetterName());
        }
        this.setCodeGenerator(template.getCodeGenerator());
        if (!_templateUnset.contains((Object)Property.FULLY_CHECKED_CAST)) {
            this.setFullyCheckedCast(template.isFullyCheckedCast());
        }
        this.addAllAccessorAnnotations(template.accessorAnnotations);
        return (Metadata.Property.Builder)this;
    }

    public Metadata.Property.Builder clear() {
        Metadata.Property.Builder _template = new Metadata.Property.Builder();
        this.type = _template.type;
        this.boxedType = _template.boxedType;
        this.name = _template.name;
        this.capitalizedName = _template.capitalizedName;
        this.allCapsName = _template.allCapsName;
        this.getterName = _template.getterName;
        this.codeGenerator = _template.codeGenerator;
        this.fullyCheckedCast = _template.fullyCheckedCast;
        this.accessorAnnotations.clear();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_template._unsetProperties);
        return (Metadata.Property.Builder)this;
    }

    public Metadata.Property build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public Metadata.Property buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements Metadata.Property {
        private final TypeMirror type;
        @Nullable
        private final TypeMirror boxedType;
        private final String name;
        private final String capitalizedName;
        private final String allCapsName;
        private final String getterName;
        @Nullable
        private final PropertyCodeGenerator codeGenerator;
        private final boolean fullyCheckedCast;
        private final ImmutableList<Excerpt> accessorAnnotations;
        private final EnumSet<Property> _unsetProperties;

        Partial(Metadata_Property_Builder builder) {
            this.type = builder.type;
            this.boxedType = builder.boxedType;
            this.name = builder.name;
            this.capitalizedName = builder.capitalizedName;
            this.allCapsName = builder.allCapsName;
            this.getterName = builder.getterName;
            this.codeGenerator = builder.codeGenerator;
            this.fullyCheckedCast = builder.fullyCheckedCast;
            this.accessorAnnotations = ImmutableList.copyOf((Collection)builder.accessorAnnotations);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public TypeMirror getType() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        @Nullable
        public TypeMirror getBoxedType() {
            return this.boxedType;
        }

        @Override
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        public String getCapitalizedName() {
            if (this._unsetProperties.contains((Object)Property.CAPITALIZED_NAME)) {
                throw new UnsupportedOperationException("capitalizedName not set");
            }
            return this.capitalizedName;
        }

        @Override
        public String getAllCapsName() {
            if (this._unsetProperties.contains((Object)Property.ALL_CAPS_NAME)) {
                throw new UnsupportedOperationException("allCapsName not set");
            }
            return this.allCapsName;
        }

        @Override
        public String getGetterName() {
            if (this._unsetProperties.contains((Object)Property.GETTER_NAME)) {
                throw new UnsupportedOperationException("getterName not set");
            }
            return this.getterName;
        }

        @Override
        @Nullable
        public PropertyCodeGenerator getCodeGenerator() {
            return this.codeGenerator;
        }

        @Override
        public boolean isFullyCheckedCast() {
            if (this._unsetProperties.contains((Object)Property.FULLY_CHECKED_CAST)) {
                throw new UnsupportedOperationException("fullyCheckedCast not set");
            }
            return this.fullyCheckedCast;
        }

        @Override
        public ImmutableList<Excerpt> getAccessorAnnotations() {
            return this.accessorAnnotations;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            if (!(this.type == other.type || this.type != null && this.type.equals(other.type))) {
                return false;
            }
            if (!(this.boxedType == other.boxedType || this.boxedType != null && this.boxedType.equals(other.boxedType))) {
                return false;
            }
            if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
                return false;
            }
            if (!(this.capitalizedName == other.capitalizedName || this.capitalizedName != null && this.capitalizedName.equals(other.capitalizedName))) {
                return false;
            }
            if (!(this.allCapsName == other.allCapsName || this.allCapsName != null && this.allCapsName.equals(other.allCapsName))) {
                return false;
            }
            if (!(this.getterName == other.getterName || this.getterName != null && this.getterName.equals(other.getterName))) {
                return false;
            }
            if (!(this.codeGenerator == other.codeGenerator || this.codeGenerator != null && this.codeGenerator.equals(other.codeGenerator))) {
                return false;
            }
            if (this.fullyCheckedCast != other.fullyCheckedCast) {
                return false;
            }
            if (!this.accessorAnnotations.equals(other.accessorAnnotations)) {
                return false;
            }
            return this._unsetProperties.equals(other._unsetProperties);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.type, this.boxedType, this.name, this.capitalizedName, this.allCapsName, this.getterName, this.codeGenerator, this.fullyCheckedCast, this.accessorAnnotations, this._unsetProperties});
        }

        public String toString() {
            return "partial Property{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.TYPE) ? "type=" + this.type : null), (Object)(this.boxedType != null ? "boxedType=" + this.boxedType : null), new Object[]{!this._unsetProperties.contains((Object)Property.NAME) ? "name=" + this.name : null, !this._unsetProperties.contains((Object)Property.CAPITALIZED_NAME) ? "capitalizedName=" + this.capitalizedName : null, !this._unsetProperties.contains((Object)Property.ALL_CAPS_NAME) ? "allCapsName=" + this.allCapsName : null, !this._unsetProperties.contains((Object)Property.GETTER_NAME) ? "getterName=" + this.getterName : null, this.codeGenerator != null ? "codeGenerator=" + this.codeGenerator : null, !this._unsetProperties.contains((Object)Property.FULLY_CHECKED_CAST) ? "fullyCheckedCast=" + this.fullyCheckedCast : null, "accessorAnnotations=" + this.accessorAnnotations}) + "}";
        }
    }

    private static final class Value
    implements Metadata.Property {
        private final TypeMirror type;
        @Nullable
        private final TypeMirror boxedType;
        private final String name;
        private final String capitalizedName;
        private final String allCapsName;
        private final String getterName;
        @Nullable
        private final PropertyCodeGenerator codeGenerator;
        private final boolean fullyCheckedCast;
        private final ImmutableList<Excerpt> accessorAnnotations;

        private Value(Metadata_Property_Builder builder) {
            this.type = builder.type;
            this.boxedType = builder.boxedType;
            this.name = builder.name;
            this.capitalizedName = builder.capitalizedName;
            this.allCapsName = builder.allCapsName;
            this.getterName = builder.getterName;
            this.codeGenerator = builder.codeGenerator;
            this.fullyCheckedCast = builder.fullyCheckedCast;
            this.accessorAnnotations = ImmutableList.copyOf((Collection)builder.accessorAnnotations);
        }

        @Override
        public TypeMirror getType() {
            return this.type;
        }

        @Override
        @Nullable
        public TypeMirror getBoxedType() {
            return this.boxedType;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getCapitalizedName() {
            return this.capitalizedName;
        }

        @Override
        public String getAllCapsName() {
            return this.allCapsName;
        }

        @Override
        public String getGetterName() {
            return this.getterName;
        }

        @Override
        @Nullable
        public PropertyCodeGenerator getCodeGenerator() {
            return this.codeGenerator;
        }

        @Override
        public boolean isFullyCheckedCast() {
            return this.fullyCheckedCast;
        }

        @Override
        public ImmutableList<Excerpt> getAccessorAnnotations() {
            return this.accessorAnnotations;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            if (!this.type.equals(other.type)) {
                return false;
            }
            if (!(this.boxedType == other.boxedType || this.boxedType != null && this.boxedType.equals(other.boxedType))) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (!this.capitalizedName.equals(other.capitalizedName)) {
                return false;
            }
            if (!this.allCapsName.equals(other.allCapsName)) {
                return false;
            }
            if (!this.getterName.equals(other.getterName)) {
                return false;
            }
            if (!(this.codeGenerator == other.codeGenerator || this.codeGenerator != null && this.codeGenerator.equals(other.codeGenerator))) {
                return false;
            }
            if (this.fullyCheckedCast != other.fullyCheckedCast) {
                return false;
            }
            return this.accessorAnnotations.equals(other.accessorAnnotations);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.type, this.boxedType, this.name, this.capitalizedName, this.allCapsName, this.getterName, this.codeGenerator, this.fullyCheckedCast, this.accessorAnnotations});
        }

        public String toString() {
            return "Property{" + COMMA_JOINER.join((Object)("type=" + this.type), (Object)(this.boxedType != null ? "boxedType=" + this.boxedType : null), new Object[]{"name=" + this.name, "capitalizedName=" + this.capitalizedName, "allCapsName=" + this.allCapsName, "getterName=" + this.getterName, this.codeGenerator != null ? "codeGenerator=" + this.codeGenerator : null, "fullyCheckedCast=" + this.fullyCheckedCast, "accessorAnnotations=" + this.accessorAnnotations}) + "}";
        }
    }

    private static enum Property {
        TYPE("type"),
        NAME("name"),
        CAPITALIZED_NAME("capitalizedName"),
        ALL_CAPS_NAME("allCapsName"),
        GETTER_NAME("getterName"),
        FULLY_CHECKED_CAST("fullyCheckedCast");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

