/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.FreeBuilder;
import org.inferred.freebuilder.processor.Analyser;
import org.inferred.freebuilder.processor.CodeGenerator;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.MethodIntrospector;
import org.inferred.freebuilder.processor.util.CompilationUnitBuilder;
import org.inferred.freebuilder.processor.util.FilerUtils;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.RoundEnvironments;

@AutoService(value=javax.annotation.processing.Processor.class)
public class Processor
extends AbstractProcessor {
    private Analyser analyser;
    private final CodeGenerator codeGenerator = new CodeGenerator();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)FreeBuilder.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.analyser = new Analyser(processingEnv.getElementUtils(), processingEnv.getMessager(), MethodIntrospector.instance(processingEnv), processingEnv.getTypeUtils());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement type : ElementFilter.typesIn(RoundEnvironments.annotatedElementsIn(roundEnv, FreeBuilder.class))) {
            try {
                Metadata metadata = this.analyser.analyse(type);
                CompilationUnitBuilder code = new CompilationUnitBuilder(this.processingEnv, metadata.getGeneratedBuilder().getQualifiedName(), (Collection<QualifiedName>)metadata.getVisibleNestedTypes());
                this.codeGenerator.writeBuilderSource(code, metadata);
                FilerUtils.writeCompilationUnit(this.processingEnv.getFiler(), metadata.getGeneratedBuilder().getQualifiedName(), type, code.toString());
            }
            catch (Analyser.CannotGenerateCodeException e) {
            }
            catch (FilerException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Error producing Builder: " + e.getMessage(), type, (AnnotationMirror)ModelUtils.findAnnotationMirror((Element)type, "org.inferred.freebuilder.FreeBuilder").get());
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "I/O error: " + Throwables.getStackTraceAsString((Throwable)e), type, (AnnotationMirror)ModelUtils.findAnnotationMirror((Element)type, "org.inferred.freebuilder.FreeBuilder").get());
            }
            catch (RuntimeException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error: " + Throwables.getStackTraceAsString((Throwable)e), type, (AnnotationMirror)ModelUtils.findAnnotationMirror((Element)type, "org.inferred.freebuilder.FreeBuilder").get());
            }
        }
        return false;
    }
}

