/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSetMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.inferred.freebuilder.processor.excerpt.CheckedSet;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;

public class CheckedSetMultimap {
    private static final StaticExcerpt CHECKED_SET_MULTIMAP = new StaticExcerpt(StaticExcerpt.Type.TYPE, "CheckedSetMultimap"){

        @Override
        public void addTo(SourceBuilder code) {
            ParameterizedType biConsumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).biConsumer().orNull();
            if (biConsumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * A multimap implementation that delegates to a provided put method", new Object[0]).addLine(" * to perform entry validation and insertion into a backing multimap.", new Object[0]).addLine(" */", new Object[0]).addLine("private static class CheckedSetMultimap<K, V> extends %s<K, V> {", ForwardingSetMultimap.class).addLine("", new Object[0]).addLine("  private final %s<K, V> multimap;", SetMultimap.class).addLine("  private final %s<K, V> put;", biConsumer.getQualifiedName()).addLine("", new Object[0]).addLine("  CheckedSetMultimap(%s<K, V> multimap, %s<K, V> put) {", SetMultimap.class, biConsumer.getQualifiedName()).addLine("    this.multimap = multimap;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override protected %s<K, V> delegate() {", SetMultimap.class).addLine("    return multimap;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean put(@%1$s K key, @%1$s V value) {", Nullable.class).addLine("    put.accept(key, value);", new Object[0]).addLine("    return true;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean putAll(@%s K key, %s<? extends V> values) {", Nullable.class, Iterable.class).addLine("    boolean anyModified = false;", new Object[0]).addLine("    for (V value : values) {", new Object[0]).addLine("      put.accept(key, value);", new Object[0]).addLine("      anyModified = true;", new Object[0]).addLine("    }", new Object[0]).addLine("    return anyModified;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean putAll(%s<? extends K, ? extends V> multimap) {", Multimap.class).addLine("    boolean anyModified = false;", new Object[0]).addLine("    for (%s<? extends K, ? extends V> entry : multimap.entries()) {", Map.Entry.class).addLine("      put.accept(entry.getKey(), entry.getValue());", new Object[0]).addLine("      anyModified = true;", new Object[0]).addLine("    }", new Object[0]).addLine("    return anyModified;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override", new Object[0]).addLine("  public %s<V> replaceValues(@%s K key, %s<? extends V> values) {", Set.class, Nullable.class, Iterable.class).addLine("    %s.checkNotNull(values);", Preconditions.class).addLine("    %s<V> result = removeAll(key);", Set.class).addLine("    putAll(key, values);", new Object[0]).addLine("    return result;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<V> get(@%s K key) {", Set.class, Nullable.class).addLine("    return new CheckedSet<>(", new Object[0]).addLine("        multimap.get(key), value -> put.accept(key, value));", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<K, %s<V>> asMap() {", Map.class, Collection.class).addLine("    return %s.transformEntries(%s.asMap(multimap), (key, values) -> ", Maps.class, Multimaps.class).addLine("        (%s<V>) new CheckedSet<>(", Collection.class).addLine("            values, value -> put.accept(key, value)));", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }
    };

    public static Set<StaticExcerpt> excerpts() {
        return ImmutableSet.builder().addAll(CheckedSet.excerpts()).add((Object)CHECKED_SET_MULTIMAP).build();
    }
}

