/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import org.apache.commons.lang3.StringEscapeUtils;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;

public class AnnotationSource {
    public static void addSource(SourceBuilder code, AnnotationMirror annotation) {
        new ValueSourceAdder(code).visitAnnotation(annotation, null);
    }

    private static boolean hasSingleValueWithDefaultKey(AnnotationMirror annotation) {
        if (annotation.getElementValues().size() != 1) {
            return false;
        }
        ExecutableElement key = (ExecutableElement)Iterables.getOnlyElement(annotation.getElementValues().keySet());
        return key.getSimpleName().contentEquals("value");
    }

    private AnnotationSource() {
    }

    private static class ValueSourceAdder
    extends SimpleAnnotationValueVisitor6<Void, AnnotationValue> {
        private final SourceBuilder code;

        ValueSourceAdder(SourceBuilder code) {
            this.code = code;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror annotation, AnnotationValue unused) {
            this.code.add("@%s", QualifiedName.of(ModelUtils.asElement(annotation.getAnnotationType())));
            if (annotation.getElementValues().isEmpty()) {
                return null;
            }
            this.code.add("(", new Object[0]);
            if (AnnotationSource.hasSingleValueWithDefaultKey(annotation)) {
                AnnotationValue value = (AnnotationValue)Iterables.getOnlyElement(annotation.getElementValues().values());
                this.visit(value, value);
            } else {
                String separator = "";
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
                    this.code.add("%s%s = ", separator, entry.getKey().getSimpleName());
                    this.visit(entry.getValue(), entry.getValue());
                    separator = ", ";
                }
            }
            this.code.add(")", new Object[0]);
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, AnnotationValue unused) {
            if (vals.size() == 1) {
                AnnotationValue value = (AnnotationValue)Iterables.getOnlyElement(vals);
                this.visit(value, value);
            } else {
                this.code.add("{", new Object[0]);
                String separator = "";
                for (AnnotationValue annotationValue : vals) {
                    this.code.add(separator, new Object[0]);
                    this.visit(annotationValue, annotationValue);
                    separator = ", ";
                }
                this.code.add("}", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitString(String s, AnnotationValue p) {
            this.code.add("\"%s\"", StringEscapeUtils.escapeJava((String)s));
            return null;
        }

        @Override
        protected Void defaultAction(Object obj, AnnotationValue value) {
            this.code.add("%s", value.toString());
            return null;
        }

        @Override
        public Void visitUnknown(AnnotationValue value, AnnotationValue unused) {
            this.code.add("%s", value.toString());
            return null;
        }
    }
}

