/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import com.google.googlejavaformat.java.Formatter;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ImportManager;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceStringBuilder;
import org.inferred.freebuilder.processor.util.feature.EnvironmentFeatureSet;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureType;

public class CompilationUnitBuilder
implements SourceBuilder {
    private final ImportManager importManager;
    private final SourceBuilder source;
    private final QualifiedName classToWrite;

    public CompilationUnitBuilder(ProcessingEnvironment env, QualifiedName classToWrite, Collection<QualifiedName> nestedClasses) {
        this.classToWrite = classToWrite;
        ImportManager.Builder importManagerBuilder = new ImportManager.Builder();
        importManagerBuilder.addImplicitImport(classToWrite);
        PackageElement pkg = env.getElementUtils().getPackageElement(classToWrite.getPackage());
        for (TypeElement sibling : ElementFilter.typesIn(pkg.getEnclosedElements())) {
            importManagerBuilder.addImplicitImport(QualifiedName.of(sibling));
        }
        for (QualifiedName nestedClass : nestedClasses) {
            importManagerBuilder.addImplicitImport(nestedClass);
        }
        this.importManager = importManagerBuilder.build();
        this.source = new SourceStringBuilder(this.importManager, new EnvironmentFeatureSet(env));
    }

    @Override
    public CompilationUnitBuilder add(String fmt, Object ... args) {
        this.source.add(fmt, args);
        return this;
    }

    @Override
    public SourceBuilder add(Excerpt excerpt) {
        this.source.add(excerpt);
        return this;
    }

    @Override
    public CompilationUnitBuilder addLine(String fmt, Object ... args) {
        this.source.addLine(fmt, args);
        return this;
    }

    @Override
    public SourceStringBuilder subBuilder() {
        return this.source.subBuilder();
    }

    @Override
    public <T extends Feature<T>> T feature(FeatureType<T> feature) {
        return this.source.feature(feature);
    }

    public String toString() {
        StringBuilder unit = new StringBuilder();
        unit.append("// Autogenerated code. Do not modify.\n").append("package ").append(this.classToWrite.getPackage()).append(";\n").append("\n");
        if (!this.importManager.getClassImports().isEmpty()) {
            for (String classImport : this.importManager.getClassImports()) {
                unit.append("import ").append(classImport).append(";\n");
            }
            unit.append("\n");
        }
        unit.append(CompilationUnitBuilder.formatSource(this.source.toString()));
        return unit.toString();
    }

    private static String formatSource(String source) {
        try {
            return new Formatter().formatSource(source);
        }
        catch (UnsupportedClassVersionError e) {
            return source;
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder().append("Formatter failed:\n").append(e.getMessage()).append("\nGenerated source:");
            int lineNo = 0;
            for (String line : source.split("\n")) {
                message.append("\n").append(++lineNo).append(": ").append(line);
            }
            throw new RuntimeException(message.toString());
        }
    }
}

