/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import org.inferred.freebuilder.processor.util.QualifiedName;

public class FilerUtils {
    private static final Method ADD_SUPPRESSED;

    public static void writeCompilationUnit(Filer filer, QualifiedName classToWrite, Element originatingElement, String source) throws IOException {
        Writer writer = filer.createSourceFile(classToWrite.toString(), originatingElement).openWriter();
        try {
            writer.append(source);
        }
        catch (Throwable e) {
            if (ADD_SUPPRESSED != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {
                    try {
                        ADD_SUPPRESSED.invoke((Object)e, t);
                    }
                    catch (Exception x) {
                        throw new RuntimeException("Failed to add suppressed exception: " + x.getMessage(), e);
                    }
                }
            } else {
                try {
                    writer.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            Throwables.propagateIfPossible((Throwable)e, IOException.class);
            throw Throwables.propagate((Throwable)e);
        }
        writer.close();
    }

    private FilerUtils() {
    }

    static {
        Method addSuppressed;
        try {
            addSuppressed = Throwable.class.getMethod("addSuppressed", Throwable.class);
        }
        catch (NoSuchMethodException e) {
            addSuppressed = null;
        }
        ADD_SUPPRESSED = addSuppressed;
    }
}

