/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceStringBuilder;
import org.inferred.freebuilder.processor.util.TypeShortener;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;
import org.inferred.freebuilder.processor.util.feature.StaticFeatureSet;

public class ParameterizedType
extends ValueType
implements Excerpt {
    private final QualifiedName qualifiedName;
    private final List<?> typeParameters;

    public static ParameterizedType from(TypeElement typeElement) {
        return new ParameterisedTypeForElementVisitor().visitType(typeElement, null);
    }

    public static ParameterizedType from(DeclaredType declaredType) {
        return new ParameterisedTypeForMirrorVisitor().visitDeclared(declaredType, null);
    }

    public static ParameterizedType from(Class<?> cls) {
        return new ParameterizedType(QualifiedName.of(cls), Arrays.asList(cls.getTypeParameters()));
    }

    ParameterizedType(QualifiedName qualifiedName, List<?> typeParameters) {
        this.qualifiedName = (QualifiedName)Preconditions.checkNotNull((Object)qualifiedName);
        this.typeParameters = (List)Preconditions.checkNotNull(typeParameters);
    }

    public String getSimpleName() {
        return this.qualifiedName.getSimpleName();
    }

    public QualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    public boolean isParameterized() {
        return !this.typeParameters.isEmpty();
    }

    @Override
    public void addTo(SourceBuilder source) {
        source.add("%s%s", this.qualifiedName, this.typeParameters());
    }

    public ParameterizedType withParameters(TypeMirror ... parameters) {
        Preconditions.checkArgument((this.typeParameters.size() == parameters.length ? 1 : 0) != 0, (String)"Need %s parameters for %s but got %s", (Object[])new Object[]{this.typeParameters.size(), this, parameters.length});
        return new ParameterizedType(this.qualifiedName, (List<?>)ImmutableList.copyOf((Object[])parameters));
    }

    public ParameterizedType withWildcards() {
        if (this.typeParameters.isEmpty()) {
            return this;
        }
        return new ParameterizedType(this.qualifiedName, Collections.nCopies(this.typeParameters.size(), "?"));
    }

    public Excerpt constructor() {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder source) {
                if (ParameterizedType.this.isParameterized() && source.feature(SourceLevel.SOURCE_LEVEL).supportsDiamondOperator()) {
                    source.add("new %s<>", ParameterizedType.this.qualifiedName);
                } else {
                    source.add("new %s", ParameterizedType.this);
                }
            }
        };
    }

    public Excerpt declaration() {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder source) {
                source.add("%s%s", ParameterizedType.this.qualifiedName.getSimpleName(), ParameterizedType.this.declarationParameters());
            }
        };
    }

    public Excerpt typeParameters() {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder source) {
                if (!ParameterizedType.this.typeParameters.isEmpty()) {
                    String prefix = "<";
                    for (Object typeParameter : ParameterizedType.this.typeParameters) {
                        source.add("%s%s", prefix, typeParameter);
                        prefix = ", ";
                    }
                    source.add(">", new Object[0]);
                }
            }
        };
    }

    public Excerpt declarationParameters() {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder source) {
                if (!ParameterizedType.this.typeParameters.isEmpty()) {
                    String prefix = "<";
                    for (Object typeParameter : ParameterizedType.this.typeParameters) {
                        source.add("%s%s", prefix, typeParameter);
                        if (typeParameter instanceof TypeParameterElement) {
                            TypeParameterElement element = (TypeParameterElement)typeParameter;
                            String separator = " extends ";
                            for (TypeMirror typeMirror : element.getBounds()) {
                                source.add("%s%s", separator, typeMirror);
                                separator = " & ";
                            }
                        }
                        prefix = ", ";
                    }
                    source.add(">", new Object[0]);
                }
            }
        };
    }

    public Excerpt javadocLink() {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder source) {
                source.add("{@link %s}", ParameterizedType.this.getQualifiedName());
            }
        };
    }

    public Excerpt javadocNoArgMethodLink(final String memberName) {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder source) {
                source.add("{@link %s#%s()}", ParameterizedType.this.getQualifiedName(), memberName);
            }
        };
    }

    @Override
    public String toString() {
        return new SourceStringBuilder(new TypeShortener.NeverShorten(), new StaticFeatureSet(new Feature[0])).add(this).toString();
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("qualifiedName", this.qualifiedName);
        fields.add("typeParameters", this.typeParameters);
    }

    private static final class ParameterisedTypeForMirrorVisitor
    extends SimpleTypeVisitor6<Object, Void>
    implements Function<TypeMirror, Object> {
        private ParameterisedTypeForMirrorVisitor() {
        }

        public Object apply(TypeMirror t) {
            return this.visit(t);
        }

        @Override
        public ParameterizedType visitDeclared(DeclaredType t, Void p) {
            return new ParameterizedType(QualifiedName.of((TypeElement)t.asElement()), (List<?>)ImmutableList.copyOf((Iterable)Iterables.transform(t.getTypeArguments(), (Function)this)));
        }

        @Override
        protected Object defaultAction(TypeMirror e, Void p) {
            return e;
        }
    }

    private static final class ParameterisedTypeForElementVisitor
    extends SimpleElementVisitor6<Object, Void>
    implements Function<Element, Object> {
        private ParameterisedTypeForElementVisitor() {
        }

        public Object apply(Element e) {
            return this.visit(e, null);
        }

        @Override
        public ParameterizedType visitType(TypeElement e, Void p) {
            return new ParameterizedType(QualifiedName.of(e), (List<?>)ImmutableList.copyOf((Iterable)Iterables.transform(e.getTypeParameters(), (Function)this)));
        }

        @Override
        protected Object defaultAction(Element e, Void p) {
            return e;
        }
    }
}

