/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceStringBuilder;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public class PreconditionExcerpts {
    private static final Escaper JAVA_STRING_ESCAPER = Escapers.builder().addEscape('\"', "\"").addEscape('\\', "\\\\").addEscape('\n', "\\n").build();
    private static final Pattern ANY_OPERATOR = Pattern.compile("[+=<>!&^|?:]|\\binstanceof\\b");

    public static Excerpt checkNotNullPreamble(final Object reference) {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder code) {
                if (!code.feature(GuavaLibrary.GUAVA).isAvailable() && !code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                    code.addLine("if (%s == null) {", reference).addLine("  throw new NullPointerException();", new Object[0]).addLine("}", new Object[0]);
                }
            }
        };
    }

    public static Excerpt checkNotNullInline(final Object reference) {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder code) {
                if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                    code.add("%s.checkNotNull(%s)", Preconditions.class, reference);
                } else if (code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                    code.add("%s.requireNonNull(%s)", code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().get(), reference);
                } else {
                    code.add("%s", reference);
                }
            }
        };
    }

    public static Excerpt checkNotNull(final Object reference) {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder code) {
                if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                    code.addLine("%s.checkNotNull(%s);", Preconditions.class, reference);
                } else if (code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                    code.addLine("%s.requireNonNull(%s);", code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().get(), reference);
                } else {
                    code.addLine("if (%s == null) {", reference).addLine("  throw new NullPointerException();", new Object[0]).addLine("}", new Object[0]);
                }
            }
        };
    }

    public static Excerpt checkArgument(Object condition, String message, Object ... args) {
        return PreconditionExcerpts.guavaCheckExcerpt("checkArgument", IllegalArgumentException.class, condition, message, args);
    }

    public static Excerpt checkState(Object condition, String message, Object ... args) {
        return PreconditionExcerpts.guavaCheckExcerpt("checkState", IllegalStateException.class, condition, message, args);
    }

    private static Excerpt guavaCheckExcerpt(final String methodName, final Class<? extends RuntimeException> exceptionType, final Object condition, final String message, final Object ... args) {
        return new Excerpt(){

            @Override
            public void addTo(SourceBuilder code) {
                if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                    code.add("%s.%s(%s, \"%s\"", Preconditions.class, methodName, condition, JAVA_STRING_ESCAPER.escape(message));
                    for (Object arg : args) {
                        code.add(", %s", arg);
                    }
                    code.add(");\n", new Object[0]);
                } else {
                    ArrayList<1> escapedArgs = new ArrayList<1>();
                    for (final Object arg : args) {
                        escapedArgs.add(new Excerpt(){

                            @Override
                            public void addTo(SourceBuilder source) {
                                source.add("\" + %s + \"", arg);
                            }
                        });
                    }
                    String messageConcatenated = code.subBuilder().add("\"" + JAVA_STRING_ESCAPER.escape(message) + "\"", escapedArgs.toArray()).toString().replace("\"\" + ", "").replace(" + \"\"", "");
                    code.addLine("if (%s) {", PreconditionExcerpts.negate(code, condition)).addLine("  throw new %s(%s);", exceptionType, messageConcatenated).addLine("}", new Object[0]);
                }
            }
        };
    }

    private static String negate(SourceBuilder code, Object condition) {
        SourceStringBuilder subBuilder = code.subBuilder();
        subBuilder.add("%s", condition);
        String conditionText = subBuilder.toString();
        if (conditionText.startsWith("!")) {
            return conditionText.substring(1);
        }
        if (ANY_OPERATOR.matcher(conditionText).find()) {
            return "!(" + conditionText + ")";
        }
        return "!" + conditionText;
    }

    private PreconditionExcerpts() {
    }
}

