/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.annotation.processing.ProcessingEnvironment;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureSet;
import org.inferred.freebuilder.processor.util.feature.FeatureType;

public class EnvironmentFeatureSet
implements FeatureSet {
    private final LoadingCache<FeatureType<?>, Feature<?>> featuresByType;

    public EnvironmentFeatureSet(ProcessingEnvironment env) {
        this.featuresByType = CacheBuilder.newBuilder().concurrencyLevel(1).build((CacheLoader)new FeatureFromEnvironmentLoader(env));
    }

    @Override
    public <T extends Feature<T>> T get(FeatureType<T> featureType) {
        Feature feature = (Feature)this.featuresByType.getUnchecked(featureType);
        return (T)feature;
    }

    private static class FeatureFromEnvironmentLoader
    extends CacheLoader<FeatureType<?>, Feature<?>> {
        private final ProcessingEnvironment env;

        private FeatureFromEnvironmentLoader(ProcessingEnvironment env) {
            this.env = env;
        }

        public Feature<?> load(FeatureType<?> featureType) {
            return featureType.forEnvironment(this.env);
        }
    }
}

