/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util.feature;

import com.google.common.base.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureType;

public enum SourceLevel implements Feature<SourceLevel>
{
    JAVA_6,
    JAVA_7;

    public static final FeatureType<SourceLevel> SOURCE_LEVEL;

    public Optional<QualifiedName> javaUtilObjects() {
        switch (this) {
            case JAVA_6: {
                return Optional.absent();
            }
        }
        return Optional.of((Object)QualifiedName.of("java.util", "Objects", new String[0]));
    }

    public boolean supportsDiamondOperator() {
        return this.compareTo(JAVA_7) >= 0;
    }

    static {
        SOURCE_LEVEL = new FeatureType<SourceLevel>(){

            @Override
            protected SourceLevel testDefault() {
                return JAVA_6;
            }

            @Override
            protected SourceLevel forEnvironment(ProcessingEnvironment env) {
                if (env.getSourceVersion().compareTo(SourceVersion.RELEASE_6) <= 0) {
                    return JAVA_6;
                }
                return JAVA_7;
            }
        };
    }
}

