/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util.feature;

import com.google.common.collect.ImmutableMap;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureSet;
import org.inferred.freebuilder.processor.util.feature.FeatureType;

public class StaticFeatureSet
implements FeatureSet {
    private final ImmutableMap<Class<? extends Feature>, Feature<?>> featuresByType;

    public StaticFeatureSet(Feature<?> ... features) {
        ImmutableMap.Builder featuresBuilder = ImmutableMap.builder();
        for (Feature<?> feature : features) {
            featuresBuilder.put(feature.getClass(), feature);
        }
        this.featuresByType = featuresBuilder.build();
    }

    @Override
    public <T extends Feature<T>> T get(FeatureType<T> featureType) {
        Feature feature = (Feature)this.featuresByType.get(featureType.type());
        if (feature != null) {
            return (T)feature;
        }
        return featureType.testDefault();
    }
}

