/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;

public class BuildablePropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final Predicate<Element> IS_BUILDER_TYPE = new Predicate<Element>(){

        public boolean apply(Element element) {
            return element.getSimpleName().contentEquals("Builder") && element.getModifiers().contains((Object)Modifier.PUBLIC);
        }
    };

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        MergeBuilderMethod mergeFromBuilderMethod;
        DeclaredType type = (DeclaredType)ModelUtils.maybeDeclared(config.getProperty().getType()).orNull();
        if (type == null) {
            return Optional.absent();
        }
        TypeElement element = ModelUtils.asElement(type);
        Optional builder = Iterables.tryFind(ElementFilter.typesIn(element.getEnclosedElements()), IS_BUILDER_TYPE);
        if (!builder.isPresent()) {
            return Optional.absent();
        }
        Optional<BuilderFactory> builderFactory = BuilderFactory.from((TypeElement)builder.get());
        if (!builderFactory.isPresent()) {
            return Optional.absent();
        }
        if (ModelUtils.findAnnotationMirror((Element)element, "org.inferred.freebuilder.FreeBuilder").isPresent()) {
            mergeFromBuilderMethod = MergeBuilderMethod.MERGE_DIRECTLY;
        } else {
            ImmutableList methods = FluentIterable.from(config.getElements().getAllMembers((TypeElement)builder.get())).filter(ExecutableElement.class).filter((Predicate)new IsCallableMethod()).toList();
            if (!Iterables.any((Iterable)methods, (Predicate)new IsBuildMethod("build", type, config.getTypes()))) {
                return Optional.absent();
            }
            if (!Iterables.any((Iterable)methods, (Predicate)new IsBuildMethod("buildPartial", type, config.getTypes()))) {
                return Optional.absent();
            }
            if (!Iterables.any((Iterable)methods, (Predicate)new IsClearMethod())) {
                return Optional.absent();
            }
            if (!Iterables.any((Iterable)methods, (Predicate)new IsMergeFromMethod(type, config.getTypes()))) {
                return Optional.absent();
            }
            mergeFromBuilderMethod = Iterables.any((Iterable)methods, (Predicate)new IsMergeFromMethod(((TypeElement)builder.get()).asType(), config.getTypes())) ? MergeBuilderMethod.MERGE_DIRECTLY : MergeBuilderMethod.BUILD_PARTIAL_AND_MERGE;
        }
        return Optional.of((Object)new CodeGenerator(config.getMetadata(), config.getProperty(), ParameterizedType.from((TypeElement)builder.get()), (BuilderFactory)((Object)builderFactory.get()), mergeFromBuilderMethod));
    }

    private static final class IsMergeFromMethod
    implements Predicate<ExecutableElement> {
        final TypeMirror builderType;
        final Types types;

        IsMergeFromMethod(TypeMirror sourceType, Types types) {
            this.builderType = sourceType;
            this.types = types;
        }

        public boolean apply(ExecutableElement element) {
            if (element.getParameters().size() != 1) {
                return false;
            }
            if (!element.getSimpleName().contentEquals("mergeFrom")) {
                return false;
            }
            return this.types.isSubtype(this.builderType, element.getParameters().get(0).asType());
        }
    }

    private static final class IsClearMethod
    implements Predicate<ExecutableElement> {
        private IsClearMethod() {
        }

        public boolean apply(ExecutableElement element) {
            if (!element.getParameters().isEmpty()) {
                return false;
            }
            return element.getSimpleName().contentEquals("clear");
        }
    }

    private static final class IsBuildMethod
    implements Predicate<ExecutableElement> {
        final String methodName;
        final TypeMirror builtType;
        final Types types;

        IsBuildMethod(String methodName, TypeMirror builtType, Types types) {
            this.methodName = methodName;
            this.builtType = builtType;
            this.types = types;
        }

        public boolean apply(ExecutableElement element) {
            if (!element.getParameters().isEmpty()) {
                return false;
            }
            if (!element.getSimpleName().contentEquals(this.methodName)) {
                return false;
            }
            return this.types.isSubtype(element.getReturnType(), this.builtType);
        }
    }

    private static final class IsCallableMethod
    implements Predicate<ExecutableElement> {
        private IsCallableMethod() {
        }

        public boolean apply(ExecutableElement element) {
            boolean isMethod = element.getKind() == ElementKind.METHOD;
            boolean isPublic = element.getModifiers().contains((Object)Modifier.PUBLIC);
            boolean isNotStatic = !element.getModifiers().contains((Object)Modifier.STATIC);
            boolean declaresNoExceptions = element.getThrownTypes().isEmpty();
            return isMethod && isPublic && isNotStatic && declaresNoExceptions;
        }
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        final ParameterizedType builderType;
        final BuilderFactory builderFactory;
        final MergeBuilderMethod mergeFromBuilderMethod;

        CodeGenerator(Metadata metadata, Metadata.Property property, ParameterizedType builderType, BuilderFactory builderFactory, MergeBuilderMethod mergeFromBuilderMethod) {
            super(metadata, property);
            this.builderType = builderType;
            this.builderFactory = builderFactory;
            this.mergeFromBuilderMethod = mergeFromBuilderMethod;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("private final %s %s = %s;", this.builderType, this.property.getName(), this.builderFactory.newBuilder(this.builderType, BuilderFactory.TypeInference.INFERRED_TYPES));
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code) {
            this.addSetter(code, this.metadata);
            this.addSetterTakingBuilder(code, this.metadata);
            this.addMutate(code, this.metadata);
            this.addGetter(code, this.metadata);
        }

        private void addSetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName()).addLine(" */", new Object[0]);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s %s) {", metadata.getBuilder(), BuilderMethods.setter(this.property), this.property.getType(), this.property.getName()).addLine("  this.%s.clear();", this.property.getName()).addLine("  this.%1$s.mergeFrom(%2$s.checkNotNull(%1$s));", this.property.getName(), Preconditions.class).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addSetterTakingBuilder(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code builder} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s builder) {", metadata.getBuilder(), BuilderMethods.setter(this.property), this.builderType).addLine("  return %s(builder.build());", BuilderMethods.setter(this.property)).addLine("}", new Object[0]);
        }

        private void addMutate(SourceBuilder code, Metadata metadata) {
            ParameterizedType consumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).consumer().orNull();
            if (consumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the builder for the value that will be", new Object[0]).addLine(" * returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the builder in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s<%s> mutator) {", metadata.getBuilder(), BuilderMethods.mutator(this.property), consumer.getQualifiedName(), this.builderType).addLine("  mutator.accept(%s);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns a builder for the value that will be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" */", new Object[0]).addLine("public %s %s() {", this.builderType, BuilderMethods.getBuilderMethod(this.property)).addLine("  return %s;", this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.%s.build();", finalField, builder, this.property.getName());
        }

        @Override
        public void addPartialFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.%s.buildPartial();", finalField, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(Block code, String value) {
            String propertyName = this.property.getName();
            if (propertyName.equals(value)) {
                propertyName = "this." + propertyName;
            }
            code.addLine("%s.mergeFrom(%s.%s());", propertyName, value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(Block code, String builder) {
            String propertyName = this.property.getName();
            if (propertyName.equals(builder)) {
                propertyName = "this." + propertyName;
            }
            code.add("%s.mergeFrom(%s.%s()", propertyName, builder, BuilderMethods.getBuilderMethod(this.property));
            if (this.mergeFromBuilderMethod == MergeBuilderMethod.BUILD_PARTIAL_AND_MERGE) {
                code.add(".buildPartial()", new Object[0]);
            }
            code.add(");\n", new Object[0]);
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
        }

        @Override
        public void addClearField(Block code) {
            code.addLine("%s.clear();", this.property.getName());
        }
    }

    private static enum MergeBuilderMethod {
        MERGE_DIRECTLY,
        BUILD_PARTIAL_AND_MERGE;

    }
}

