/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import javax.annotation.Nullable;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;

public class OptionalPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final SimpleTypeVisitor6<Boolean, Void> HAS_WILDCARD = new SimpleTypeVisitor6<Boolean, Void>(){

        @Override
        protected Boolean defaultAction(TypeMirror e, Void p) {
            return false;
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                if (!((Boolean)this.visit(typeMirror)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitWildcard(WildcardType t, Void p) {
            return true;
        }
    };

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        DeclaredType type = (DeclaredType)ModelUtils.maybeDeclared(config.getProperty().getType()).orNull();
        if (type == null) {
            return Optional.absent();
        }
        OptionalType optionalType = (OptionalType)((Object)OptionalPropertyFactory.maybeOptional(type).orNull());
        if (optionalType == null) {
            return Optional.absent();
        }
        TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
        Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
        boolean requiresExplicitTypeParameters = (Boolean)HAS_WILDCARD.visit(elementType);
        return Optional.of((Object)new CodeGenerator(config.getMetadata(), config.getProperty(), optionalType, elementType, unboxedType, requiresExplicitTypeParameters));
    }

    private static Optional<OptionalType> maybeOptional(DeclaredType type) {
        for (OptionalType optionalType : OptionalType.values()) {
            if (!Util.erasesToAnyOf(type, optionalType.cls)) continue;
            return Optional.of((Object)((Object)optionalType));
        }
        return Optional.absent();
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        private final OptionalType optional;
        private final TypeMirror elementType;
        private final Optional<TypeMirror> unboxedType;
        private final boolean requiresExplicitTypeParameters;

        @VisibleForTesting
        CodeGenerator(Metadata metadata, Metadata.Property property, OptionalType optional, TypeMirror elementType, Optional<TypeMirror> unboxedType, boolean requiresExplicitTypeParametersInJava7) {
            super(metadata, property);
            this.optional = optional;
            this.elementType = elementType;
            this.unboxedType = unboxedType;
            this.requiresExplicitTypeParameters = requiresExplicitTypeParametersInJava7;
        }

        @Override
        public PropertyCodeGenerator.Type getType() {
            return PropertyCodeGenerator.Type.OPTIONAL;
        }

        @Override
        public void addValueFieldDeclaration(SourceBuilder code, String finalField) {
            code.addLine("// Store a nullable object instead of an Optional. Escape analysis then", new Object[0]).addLine("// allows the JVM to optimize away the Optional objects created by our", new Object[0]).addLine("// getter method.", new Object[0]).addLine("private final %s %s;", this.elementType, finalField);
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("// Store a nullable object instead of an Optional. Escape analysis then", new Object[0]).addLine("// allows the JVM to optimize away the Optional objects created by and", new Object[0]).addLine("// passed to our API.", new Object[0]).addLine("private %s %s = null;", this.elementType, this.property.getName());
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code) {
            this.addSetter(code, this.metadata);
            this.addOptionalSetter(code, this.metadata);
            this.addNullableSetter(code, this.metadata);
            this.addMapper(code, this.metadata);
            this.addClear(code, this.metadata);
            this.addGetter(code, this.metadata);
        }

        private void addSetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName());
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s %s) {", metadata.getBuilder(), BuilderMethods.setter(this.property), this.unboxedType.or((Object)this.elementType), this.property.getName());
            if (this.unboxedType.isPresent()) {
                code.addLine("  this.%1$s = %1$s;", this.property.getName());
            } else {
                code.add(PreconditionExcerpts.checkNotNullPreamble(this.property.getName())).addLine("  this.%s = %s;", this.property.getName(), PreconditionExcerpts.checkNotNullInline(this.property.getName()));
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addOptionalSetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s<? extends %s> %s) {", metadata.getBuilder(), BuilderMethods.setter(this.property), this.optional.cls, this.elementType, this.property.getName()).addLine("  if (%s.isPresent()) {", this.property.getName()).addLine("    return %s(%s.get());", BuilderMethods.setter(this.property), this.property.getName()).addLine("  } else {", new Object[0]).addLine("    return %s();", BuilderMethods.clearMethod(this.property)).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        private void addNullableSetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s(@%s %s %s) {", metadata.getBuilder(), BuilderMethods.nullableSetter(this.property), Nullable.class, this.elementType, this.property.getName()).addLine("  if (%s != null) {", this.property.getName()).addLine("    return %s(%s);", BuilderMethods.setter(this.property), this.property.getName()).addLine("  } else {", new Object[0]).addLine("    return %s();", BuilderMethods.clearMethod(this.property)).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        private void addMapper(SourceBuilder code, Metadata metadata) {
            ParameterizedType unaryOperator = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).unaryOperator().orNull();
            if (unaryOperator == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * If the value to be returned by %s is present,", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * replaces it by applying {@code mapper} to it and using the result.", new Object[0]).addLine(" *", new Object[0]).addLine(" * <p>If the result is null, clears the value.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mapper} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mapper) {", metadata.getBuilder(), BuilderMethods.mapper(this.property), unaryOperator.withParameters(this.elementType));
            this.optional.applyMapper(code, metadata, this.property);
            code.addLine("}", new Object[0]);
        }

        private void addClear(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * to {@link %1$s#%2$s() Optional.%2$s()}.", this.optional.cls, this.optional.empty).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", metadata.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  this.%s = null;", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" */", new Object[0]).addLine("public %s %s() {", this.property.getType(), BuilderMethods.getter(this.property));
            code.add("  return %s.", this.optional.cls);
            if (this.requiresExplicitTypeParameters) {
                code.add("<%s>", this.elementType);
            }
            code.add("%s(%s);\n", this.optional.ofNullable, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.%s;", finalField, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(Block code, String value) {
            String propertyValue = value + "." + this.property.getGetterName() + "()";
            this.optional.invokeIfPresent(code, propertyValue, BuilderMethods.setter(this.property));
        }

        @Override
        public void addMergeFromBuilder(Block code, String builder) {
            String propertyValue = builder + "." + BuilderMethods.getter(this.property) + "()";
            this.optional.invokeIfPresent(code, propertyValue, BuilderMethods.setter(this.property));
        }

        @Override
        public void addReadValueFragment(SourceBuilder code, String finalField) {
            code.add("%s.", this.optional.cls);
            if (this.requiresExplicitTypeParameters) {
                code.add("<%s>", this.elementType);
            }
            code.add("%s(%s)", this.optional.ofNullable, finalField);
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
        }

        @Override
        public void addClearField(Block code) {
            Optional<Excerpt> defaults = Declarations.freshBuilder(code, this.metadata);
            if (defaults.isPresent()) {
                code.addLine("%1$s = %2$s.%1$s;", this.property.getName(), defaults.get());
            } else {
                code.addLine("%s = null;", this.property.getName());
            }
        }
    }

    @VisibleForTesting
    static enum OptionalType {
        GUAVA(QualifiedName.of(Optional.class), "absent", "fromNullable"){

            @Override
            protected void applyMapper(SourceBuilder code, Metadata metadata, Metadata.Property property) {
                code.add(PreconditionExcerpts.checkNotNull("mapper")).addLine("  %s old%s = %s();", property.getType(), property.getCapitalizedName(), BuilderMethods.getter(property)).addLine("  if (old%s.isPresent()) {", property.getCapitalizedName()).addLine("     %s(mapper.apply(old%s.get()));", BuilderMethods.nullableSetter(property), property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder());
            }

            @Override
            protected void invokeIfPresent(SourceBuilder code, String value, String method) {
                code.addLine("if (%s.isPresent()) {", value).addLine("  %s(%s.get());", method, value).addLine("}", new Object[0]);
            }
        }
        ,
        JAVA8(QualifiedName.of("java.util", "Optional", new String[0]), "empty", "ofNullable"){

            @Override
            protected void applyMapper(SourceBuilder code, Metadata metadata, Metadata.Property property) {
                code.addLine("  return %s(%s().map(mapper));", BuilderMethods.setter(property), BuilderMethods.getter(property));
            }

            @Override
            protected void invokeIfPresent(SourceBuilder code, String value, String method) {
                code.addLine("%s.ifPresent(this::%s);", value, method);
            }
        };

        private final QualifiedName cls;
        private final String empty;
        private final String ofNullable;

        private OptionalType(QualifiedName cls, String empty, String ofNullable) {
            this.cls = cls;
            this.empty = empty;
            this.ofNullable = ofNullable;
        }

        protected abstract void applyMapper(SourceBuilder var1, Metadata var2, Metadata.Property var3);

        protected abstract void invokeIfPresent(SourceBuilder var1, String var2, String var3);
    }
}

