/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;

public abstract class PropertyCodeGenerator {
    protected final Metadata metadata;
    protected final Metadata.Property property;

    public PropertyCodeGenerator(Metadata metadata, Metadata.Property property) {
        this.metadata = metadata;
        this.property = property;
    }

    public Type getType() {
        return Type.HAS_DEFAULT;
    }

    public void addValueFieldDeclaration(SourceBuilder code, String finalField) {
        code.addLine("private final %s %s;", this.property.getType(), finalField);
    }

    public abstract void addBuilderFieldDeclaration(SourceBuilder var1);

    public abstract void addBuilderFieldAccessors(SourceBuilder var1);

    public abstract void addFinalFieldAssignment(SourceBuilder var1, String var2, String var3);

    public void addPartialFieldAssignment(SourceBuilder code, String finalField, String builder) {
        this.addFinalFieldAssignment(code, finalField, builder);
    }

    public abstract void addMergeFromValue(Block var1, String var2);

    public abstract void addMergeFromBuilder(Block var1, String var2);

    public void addGetterAnnotations(SourceBuilder code) {
    }

    public void addReadValueFragment(SourceBuilder code, String finalField) {
        code.add("%s", finalField);
    }

    public abstract void addSetFromResult(SourceBuilder var1, String var2, String var3);

    public abstract void addClearField(Block var1);

    public Set<? extends StaticExcerpt> getStaticExcerpts() {
        return ImmutableSet.of();
    }

    protected void addAccessorAnnotations(SourceBuilder code) {
        for (Excerpt annotation : this.property.getAccessorAnnotations()) {
            code.add(annotation);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().isInstance(obj)) {
            return false;
        }
        PropertyCodeGenerator other = (PropertyCodeGenerator)obj;
        return this.fieldValues().equals(other.fieldValues());
    }

    public int hashCode() {
        return ImmutableList.copyOf(this.fieldValues().values()).hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this);
        for (Map.Entry<String, Object> fieldValue : this.fieldValues().entrySet()) {
            stringHelper.add(fieldValue.getKey(), fieldValue.getValue());
        }
        return stringHelper.toString();
    }

    private Map<String, Object> fieldValues() {
        ImmutableMap.Builder valuesBuilder = ImmutableMap.builder();
        this.addFieldValues(this.getClass(), (ImmutableMap.Builder<String, Object>)valuesBuilder);
        return valuesBuilder.build();
    }

    private void addFieldValues(Class<?> cls, ImmutableMap.Builder<String, Object> valuesBuilder) {
        try {
            if (cls.getSuperclass() != null) {
                this.addFieldValues(cls.getSuperclass(), valuesBuilder);
            }
            for (Field field : cls.getDeclaredFields()) {
                field.setAccessible(true);
                valuesBuilder.put((Object)field.getName(), field.get(this));
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum Type {
        REQUIRED,
        OPTIONAL,
        HAS_DEFAULT;

    }

    static interface Factory {
        public Optional<? extends PropertyCodeGenerator> create(Config var1);
    }

    static interface Config {
        public Metadata getMetadata();

        public Metadata.Property getProperty();

        public List<? extends AnnotationMirror> getAnnotations();

        public TypeElement getBuilder();

        public Set<String> getMethodsInvokedInBuilderConstructor();

        public Elements getElements();

        public Types getTypes();
    }
}

