/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.excerpt.CheckedSet;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public class SetPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final StaticExcerpt IMMUTABLE_SET = new StaticExcerpt(StaticExcerpt.Type.METHOD, "immutableSet"){

        @Override
        public void addTo(SourceBuilder code) {
            if (!code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("", new Object[0]).addLine("private static <E> %1$s<E> immutableSet(%1$s<E> elements) {", Set.class, Class.class).addLine("  switch (elements.size()) {", new Object[0]).addLine("  case 0:", new Object[0]).addLine("    return %s.emptySet();", Collections.class).addLine("  case 1:", new Object[0]).addLine("    return %s.singleton(elements.iterator().next());", Collections.class).addLine("  default:", new Object[0]).addLine("    return %s.unmodifiableSet(new %s%s(elements));", Collections.class, LinkedHashSet.class, SourceLevel.diamondOperator("E")).addLine("  }", new Object[0]).addLine("}", new Object[0]);
            }
        }
    };

    public Optional<CodeGenerator> create(PropertyCodeGenerator.Config config) {
        DeclaredType type = (DeclaredType)ModelUtils.maybeDeclared(config.getProperty().getType()).orNull();
        if (type == null || !Util.erasesToAnyOf(type, Set.class, ImmutableSet.class)) {
            return Optional.absent();
        }
        TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
        Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
        boolean overridesAddMethod = SetPropertyFactory.hasAddMethodOverride(config, (TypeMirror)unboxedType.or((Object)elementType));
        return Optional.of((Object)new CodeGenerator(config.getMetadata(), config.getProperty(), elementType, unboxedType, overridesAddMethod));
    }

    private static boolean hasAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror elementType) {
        return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), elementType);
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        private static final ParameterizedType COLLECTION = QualifiedName.of(Collection.class).withParameters("E");
        private final TypeMirror elementType;
        private final Optional<TypeMirror> unboxedType;
        private final boolean overridesAddMethod;

        CodeGenerator(Metadata metadata, Metadata.Property property, TypeMirror elementType, Optional<TypeMirror> unboxedType, boolean overridesAddMethod) {
            super(metadata, property);
            this.elementType = elementType;
            this.unboxedType = unboxedType;
            this.overridesAddMethod = overridesAddMethod;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("private %s<%s> %s = %s.of();", Set.class, this.elementType, this.property.getName(), ImmutableSet.class);
            } else {
                code.addLine("private final %1$s<%2$s> %3$s = new %1$s%4$s();", LinkedHashSet.class, this.elementType, this.property.getName(), SourceLevel.diamondOperator(this.elementType));
            }
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code) {
            this.addAdd(code, this.metadata);
            this.addVarargsAdd(code, this.metadata);
            this.addAddAllMethods(code, this.metadata);
            this.addRemove(code, this.metadata);
            this.addMutator(code, this.metadata);
            this.addClear(code, this.metadata);
            this.addGetter(code, this.metadata);
        }

        private void addAdd(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the set to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * If the set already contains {@code element}, then {@code %s}", BuilderMethods.addMethod(this.property)).addLine(" * has no effect (only the previously added element is retained).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", metadata.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.or((Object)this.elementType));
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("  if (this.%s instanceof %s) {", this.property.getName(), ImmutableSet.class).addLine("    this.%1$s = new %2$s%3$s(this.%1$s);", this.property.getName(), LinkedHashSet.class, SourceLevel.diamondOperator(this.elementType)).addLine("  }", new Object[0]);
            }
            if (this.unboxedType.isPresent()) {
                code.addLine("  this.%s.add(element);", this.property.getName());
            } else {
                code.add(PreconditionExcerpts.checkNotNullPreamble("element")).addLine("  this.%s.add(%s);", this.property.getName(), PreconditionExcerpts.checkNotNullInline("element"));
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addVarargsAdd(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the set to be returned from", new Object[0]).addLine(" * %s, ignoring duplicate elements", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate element is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s... elements) {", metadata.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.or((Object)this.elementType));
            Optional<Class<?>> arrayUtils = code.feature(GuavaLibrary.GUAVA).arrayUtils((TypeMirror)this.unboxedType.or((Object)this.elementType));
            if (arrayUtils.isPresent()) {
                code.addLine("  return %s(%s.asList(elements));", BuilderMethods.addAllMethod(this.property), arrayUtils.get());
            } else {
                code.addLine("  for (%s element : elements) {", this.elementType).addLine("    %s(element);", BuilderMethods.addMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder());
            }
            code.addLine("}", new Object[0]);
        }

        private void addAddAllMethods(SourceBuilder code, Metadata metadata) {
            if (code.feature(SourceLevel.SOURCE_LEVEL).stream().isPresent()) {
                this.addSpliteratorAddAll(code, metadata);
                this.addStreamAddAll(code, metadata);
            }
            this.addIterableAddAll(code, metadata);
        }

        private void addSpliteratorAddAll(SourceBuilder code, Metadata metadata) {
            QualifiedName spliterator = (QualifiedName)code.feature(SourceLevel.SOURCE_LEVEL).spliterator().get();
            this.addJavadocForAddAll(code, metadata);
            code.addLine("public %s %s(%s<? extends %s> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), spliterator, this.elementType).addLine("  elements.forEachRemaining(this::%s);", BuilderMethods.addMethod(this.property)).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addStreamAddAll(SourceBuilder code, Metadata metadata) {
            QualifiedName baseStream = (QualifiedName)code.feature(SourceLevel.SOURCE_LEVEL).baseStream().get();
            this.addJavadocForAddAll(code, metadata);
            code.addLine("public %s %s(%s<? extends %s, ?> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), baseStream, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
        }

        private void addIterableAddAll(SourceBuilder code, Metadata metadata) {
            this.addJavadocForAddAll(code, metadata);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s<? extends %s> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType).add(Excerpts.forEach((TypeMirror)this.unboxedType.or((Object)this.elementType), "elements", BuilderMethods.addMethod(this.property))).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addJavadocForAddAll(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the set to be returned from", new Object[0]).addLine(" * %s, ignoring duplicate elements", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate element is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
        }

        private void addRemove(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes {@code element} from the set to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Does nothing if {@code element} is not a member of the set.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", metadata.getBuilder(), BuilderMethods.removeMethod(this.property), this.unboxedType.or((Object)this.elementType));
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("  if (this.%s instanceof %s) {", this.property.getName(), ImmutableSet.class).addLine("    this.%1$s = new %2$s%3$s(this.%1$s);", this.property.getName(), LinkedHashSet.class, SourceLevel.diamondOperator(this.elementType)).addLine("  }", new Object[0]);
            }
            if (this.unboxedType.isPresent()) {
                code.addLine("  this.%s.remove(element);", this.property.getName());
            } else {
                code.add(PreconditionExcerpts.checkNotNullPreamble("element")).addLine("  this.%s.remove(%s);", this.property.getName(), PreconditionExcerpts.checkNotNullInline("element"));
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addMutator(SourceBuilder code, Metadata metadata) {
            Optional<ParameterizedType> consumer = code.feature(FunctionPackage.FUNCTION_PACKAGE).consumer();
            if (consumer.isPresent()) {
                code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the set to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the set in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", COLLECTION.javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s<? super %s<%s>> mutator) {", metadata.getBuilder(), BuilderMethods.mutator(this.property), ((ParameterizedType)consumer.get()).getQualifiedName(), Set.class, this.elementType);
                if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                    code.addLine("  if (%s instanceof %s) {", this.property.getName(), ImmutableSet.class).addLine("    %1$s = new %2$s%3$s(%1$s);", this.property.getName(), LinkedHashSet.class, SourceLevel.diamondOperator(this.elementType)).addLine("  }", new Object[0]);
                }
                if (this.overridesAddMethod) {
                    code.addLine("  mutator.accept(new CheckedSet<%s>(%s, this::%s));", this.elementType, this.property.getName(), BuilderMethods.addMethod(this.property));
                } else {
                    code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.addMethod(this.property)).addLine("  mutator.accept(%s);", this.property.getName());
                }
                code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
            }
        }

        private void addClear(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the set to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", metadata.getBuilder(), BuilderMethods.clearMethod(this.property));
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("if (%s instanceof %s) {", this.property.getName(), ImmutableSet.class).addLine("  %s = %s.of();", this.property.getName(), ImmutableSet.class).addLine("} else {", new Object[0]);
            }
            code.addLine("%s.clear();", this.property.getName());
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("}", new Object[0]);
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the set that will be returned by", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s() {", Set.class, this.elementType, BuilderMethods.getter(this.property));
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("  if (%s instanceof %s) {", this.property.getName(), ImmutableSet.class).addLine("    %1$s = new %2$s%3$s(%1$s);", this.property.getName(), LinkedHashSet.class, SourceLevel.diamondOperator(this.elementType)).addLine("  }", new Object[0]);
            }
            code.addLine("  return %s.unmodifiableSet(%s);", Collections.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.add("%s = ", finalField);
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.add("%s.copyOf", ImmutableSet.class);
            } else {
                code.add("immutableSet", new Object[0]);
            }
            code.add("(%s.%s);\n", builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(Block code, String value) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("if (%s instanceof %s && %s == %s.<%s>of()) {", value, this.metadata.getValueType(), this.property.getName(), ImmutableSet.class, this.elementType).addLine("  %s = %s.copyOf(%s.%s());", this.property.getName(), ImmutableSet.class, value, this.property.getGetterName()).addLine("} else {", new Object[0]);
            }
            code.addLine("%s(%s.%s());", BuilderMethods.addAllMethod(this.property), value, this.property.getGetterName());
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("}", new Object[0]);
            }
        }

        @Override
        public void addMergeFromBuilder(Block code, String builder) {
            code.addLine("%s(((%s) %s).%s);", BuilderMethods.addAllMethod(this.property), this.metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, BuilderMethods.addAllMethod(this.property), variable);
        }

        @Override
        public void addClearField(Block code) {
            code.addLine("%s();", BuilderMethods.clearMethod(this.property));
        }

        public Set<StaticExcerpt> getStaticExcerpts() {
            ImmutableSet.Builder staticMethods = ImmutableSet.builder();
            staticMethods.add((Object)IMMUTABLE_SET);
            if (this.overridesAddMethod) {
                staticMethods.addAll(CheckedSet.excerpts());
            }
            return staticMethods.build();
        }
    }
}

