/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;

public class CheckedMap {
    private static final StaticExcerpt CHECKED_ENTRY = new StaticExcerpt(StaticExcerpt.Type.TYPE, "CheckedEntry"){

        @Override
        public void addTo(SourceBuilder code) {
            ParameterizedType biConsumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).biConsumer().orNull();
            if (biConsumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("private static class CheckedEntry<K, V> implements %s<K, V> {", Map.Entry.class).addLine("", new Object[0]).addLine("  private final %s<K, V> entry;", Map.Entry.class).addLine("  private final %s<K, V> put;", biConsumer.getQualifiedName()).addLine("", new Object[0]).addLine("  CheckedEntry(%s<K, V> entry, %s<K, V> put) {", Map.Entry.class, biConsumer.getQualifiedName()).addLine("    this.entry = entry;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public K getKey() {", new Object[0]).addLine("    return entry.getKey();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V getValue() {", new Object[0]).addLine("    return entry.getValue();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V setValue(V value) {", new Object[0]).add(PreconditionExcerpts.checkNotNull("value")).addLine("    V oldValue = entry.getValue();", new Object[0]).addLine("    put.accept(entry.getKey(), value);", new Object[0]).addLine("    return oldValue;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean equals(Object o) {", new Object[0]).addLine("    return entry.equals(o);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int hashCode() {", new Object[0]).addLine("    return entry.hashCode();", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }
    };
    private static final StaticExcerpt CHECKED_ENTRY_ITERATOR = new StaticExcerpt(StaticExcerpt.Type.TYPE, "CheckedEntryIterator"){

        @Override
        public void addTo(SourceBuilder code) {
            ParameterizedType biConsumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).biConsumer().orNull();
            if (biConsumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("private static class CheckedEntryIterator<K, V> implements %s<%s<K, V>> {", Iterator.class, Map.Entry.class).addLine("", new Object[0]).addLine("  private final %s<%s<K, V>> iterator;", Iterator.class, Map.Entry.class).addLine("  private final %s<K, V> put;", biConsumer.getQualifiedName()).addLine("", new Object[0]).addLine("  CheckedEntryIterator(", new Object[0]).addLine("      %s<%s<K, V>> iterator,", Iterator.class, Map.Entry.class).addLine("      %s<K, V> put) {", biConsumer.getQualifiedName()).addLine("    this.iterator = iterator;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean hasNext() {", new Object[0]).addLine("    return iterator.hasNext();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<K, V> next() {", Map.Entry.class).addLine("    return new CheckedEntry<K, V>(iterator.next(), put);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void remove() {", new Object[0]).addLine("    iterator.remove();", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }
    };
    private static final StaticExcerpt CHECKED_ENTRY_SET = new StaticExcerpt(StaticExcerpt.Type.TYPE, "CheckedEntrySet"){

        @Override
        public void addTo(SourceBuilder code) {
            ParameterizedType biConsumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).biConsumer().orNull();
            if (biConsumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("private static class CheckedEntrySet<K, V> extends %s<%s<K, V>> {", AbstractSet.class, Map.Entry.class).addLine("", new Object[0]).addLine("  private final %s<%s<K, V>> set;", Set.class, Map.Entry.class).addLine("  private final %s<K, V> put;", biConsumer.getQualifiedName()).addLine("", new Object[0]).addLine("  CheckedEntrySet(%s<%s<K, V>> set, %s<K, V> put) {", Set.class, Map.Entry.class, biConsumer.getQualifiedName()).addLine("    this.set = set;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int size() {", new Object[0]).addLine("    return set.size();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<%s<K, V>> iterator() {", Iterator.class, Map.Entry.class).addLine("    return new CheckedEntryIterator<K, V>(set.iterator(), put);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean contains(Object o) {", new Object[0]).addLine("    return set.contains(o);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean remove(Object o) {", new Object[0]).addLine("    return set.remove(o);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void clear() {", new Object[0]).addLine("    set.clear();", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }
    };
    private static final StaticExcerpt CHECKED_MAP = new StaticExcerpt(StaticExcerpt.Type.TYPE, "CheckedMap"){

        @Override
        public void addTo(SourceBuilder code) {
            ParameterizedType biConsumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).biConsumer().orNull();
            if (biConsumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * A map implementation that delegates to a provided put method", new Object[0]).addLine(" * to perform entry validation and insertion into a backing map.", new Object[0]).addLine(" */", new Object[0]).addLine("private static class CheckedMap<K, V> extends %s<K, V> {", AbstractMap.class).addLine("", new Object[0]).addLine("  private final %s<K, V> map;", Map.class).addLine("  private final %s<K, V> put;", biConsumer.getQualifiedName()).addLine("", new Object[0]).addLine("  CheckedMap(%s<K, V> map, %s<K, V> put) {", Map.class, biConsumer.getQualifiedName()).addLine("    this.map = map;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V get(Object key) {", new Object[0]).addLine("    return map.get(key);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean containsKey(Object key) {", new Object[0]).addLine("    return map.containsKey(key);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V put(K key, V value) {", new Object[0]).addLine("    V oldValue = map.get(key);", new Object[0]).addLine("    put.accept(key, value);", new Object[0]).addLine("    return oldValue;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V remove(Object key) {", new Object[0]).addLine("    return map.remove(key);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void clear() {", new Object[0]).addLine("    map.clear();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<%s<K, V>> entrySet() {", Set.class, Map.Entry.class).addLine("    return new CheckedEntrySet<>(map.entrySet(), put);", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }
    };

    public static final Set<StaticExcerpt> excerpts() {
        return ImmutableSet.of((Object)CHECKED_ENTRY, (Object)CHECKED_ENTRY_ITERATOR, (Object)CHECKED_ENTRY_SET, (Object)CHECKED_MAP);
    }
}

