/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.naming;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.naming.NamingConvention;
import org.inferred.freebuilder.processor.util.ModelUtils;

class PrefixlessConvention
implements NamingConvention {
    private final Messager messager;
    private final Types types;

    PrefixlessConvention(Messager messager, Types types) {
        this.messager = messager;
        this.types = types;
    }

    @Override
    public Optional<Metadata.Property.Builder> getPropertyNames(TypeElement valueType, ExecutableElement method) {
        if (!this.methodIsAbstractGetter(valueType, method)) {
            return Optional.absent();
        }
        String name = method.getSimpleName().toString();
        String capitalizedName = name.substring(0, 1).toUpperCase() + name.substring(1);
        return Optional.of((Object)new Metadata.Property.Builder().setUsingBeanConvention(false).setName(name).setCapitalizedName(capitalizedName).setGetterName(name));
    }

    private boolean methodIsAbstractGetter(TypeElement valueType, ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        boolean declaredOnValueType = method.getEnclosingElement().equals(valueType);
        TypeMirror returnType = ModelUtils.getReturnType(valueType, method, this.types);
        if (returnType.getKind() == TypeKind.VOID || !method.getParameters().isEmpty()) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Only getter methods may be declared abstract on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return false;
        }
        return true;
    }

    private void printNoImplementationMessage(TypeElement valueType, ExecutableElement method) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, "No implementation found for non-getter method '" + method + "'; cannot generate @FreeBuilder implementation", valueType);
    }
}

