/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.ArrayList;
import java.util.List;

public abstract class ValueType {
    protected abstract void addFields(FieldReceiver var1);

    public final boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ReceiverIntoList a = new ReceiverIntoList();
        ReceiverIntoList b = new ReceiverIntoList();
        this.addFields(a);
        ((ValueType)obj).addFields(b);
        return a.get().equals(b.get());
    }

    public final int hashCode() {
        ReceiverIntoHashCode receiver = new ReceiverIntoHashCode();
        this.addFields(receiver);
        return receiver.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("{");
        this.addFields(new ReceiverIntoStringBuilder(builder));
        return builder.append("}").toString();
    }

    private static final class ReceiverIntoStringBuilder
    implements FieldReceiver {
        private final StringBuilder builder;
        private String delimiter;

        ReceiverIntoStringBuilder(StringBuilder builder) {
            this.builder = builder;
            this.delimiter = "";
        }

        @Override
        public void add(String name, Object value) {
            this.builder.append(this.delimiter);
            this.delimiter = ", ";
            this.builder.append(name).append("=").append(value);
        }
    }

    private static final class ReceiverIntoHashCode
    implements FieldReceiver {
        private int hashCode = 1;

        private ReceiverIntoHashCode() {
        }

        private void add(Object value) {
            this.hashCode *= 31;
            this.hashCode += value == null ? 0 : value.hashCode();
        }

        @Override
        public void add(String name, Object value) {
            this.add(name);
            this.add(value);
        }

        public int get() {
            return this.hashCode;
        }
    }

    private static final class ReceiverIntoList
    implements FieldReceiver {
        private final List<Object> list = new ArrayList<Object>();

        private ReceiverIntoList() {
        }

        @Override
        public void add(String name, Object value) {
            this.list.add(name);
            this.list.add(value);
        }

        public List<Object> get() {
            return this.list;
        }
    }

    public static interface FieldReceiver {
        public void add(String var1, Object var2);
    }
}

