/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util.feature;

import com.google.common.base.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.Shading;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureSet;
import org.inferred.freebuilder.processor.util.feature.FeatureType;

public enum SourceLevel implements Feature<SourceLevel>
{
    JAVA_6("Java 6"),
    JAVA_7("Java 7"),
    JAVA_8("Java 8+");

    public static final FeatureType<SourceLevel> SOURCE_LEVEL;
    private static final QualifiedName STREAM;
    private static final String ECLIPSE_DISPATCHER;
    private final String humanReadableFormat;

    public static Excerpt diamondOperator(Object type) {
        return new DiamondOperator(type);
    }

    private SourceLevel(String humanReadableFormat) {
        this.humanReadableFormat = humanReadableFormat;
    }

    public Optional<QualifiedName> javaUtilObjects() {
        switch (this) {
            case JAVA_6: {
                return Optional.absent();
            }
        }
        return Optional.of((Object)QualifiedName.of("java.util", "Objects", new String[0]));
    }

    public boolean hasLambdas() {
        return this.compareTo(JAVA_8) >= 0;
    }

    public Optional<QualifiedName> baseStream() {
        switch (this) {
            case JAVA_6: 
            case JAVA_7: {
                return Optional.absent();
            }
        }
        return Optional.of((Object)QualifiedName.of("java.util.stream", "BaseStream", new String[0]));
    }

    public Optional<QualifiedName> stream() {
        switch (this) {
            case JAVA_6: 
            case JAVA_7: {
                return Optional.absent();
            }
        }
        return Optional.of((Object)STREAM);
    }

    public Optional<QualifiedName> spliterator() {
        switch (this) {
            case JAVA_6: 
            case JAVA_7: {
                return Optional.absent();
            }
        }
        return Optional.of((Object)QualifiedName.of("java.util", "Spliterator", new String[0]));
    }

    public String toString() {
        return this.humanReadableFormat;
    }

    private static boolean hasType(Elements elements, QualifiedName type) {
        return elements.getTypeElement(type.toString()) != null;
    }

    private static boolean runningInEclipse() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        for (StackTraceElement method : t.getStackTrace()) {
            if (method.getClassName().equals(ECLIPSE_DISPATCHER)) {
                return true;
            }
            if (method.getClassName().startsWith("org.inferred")) continue;
            return false;
        }
        return false;
    }

    static {
        SOURCE_LEVEL = new FeatureType<SourceLevel>(){

            @Override
            protected SourceLevel testDefault(FeatureSet features) {
                return JAVA_6;
            }

            @Override
            protected SourceLevel forEnvironment(ProcessingEnvironment env, FeatureSet features) {
                int sourceVersion = env.getSourceVersion().ordinal();
                if (sourceVersion <= 6) {
                    return JAVA_6;
                }
                if (sourceVersion >= 8) {
                    return JAVA_8;
                }
                if (SourceLevel.runningInEclipse()) {
                    return SourceLevel.hasType(env.getElementUtils(), STREAM) ? JAVA_8 : JAVA_7;
                }
                return JAVA_7;
            }
        };
        STREAM = QualifiedName.of("java.util.stream", "Stream", new String[0]);
        ECLIPSE_DISPATCHER = Shading.unshadedName("org.eclipse.jdt.internal.compiler.apt.dispatch.RoundDispatcher");
    }

    private static final class DiamondOperator
    extends Excerpt {
        private final Object type;

        private DiamondOperator(Object type) {
            this.type = type;
        }

        @Override
        public void addTo(SourceBuilder source) {
            if (source.feature(SOURCE_LEVEL).compareTo(JAVA_7) >= 0) {
                source.add("<>", new Object[0]);
            } else {
                source.add("<%s>", this.type);
            }
        }

        @Override
        public String toString() {
            return "diamondOperator(" + this.type + ")";
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("type", this.type);
        }
    }
}

