/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;

class GwtSupport {
    private static final QualifiedName CUSTOM_FIELD_SERIALIZER = QualifiedName.of("com.google.gwt.user.client.rpc", "CustomFieldSerializer", new String[0]);
    private static final QualifiedName SERIALIZATION_EXCEPTION = QualifiedName.of("com.google.gwt.user.client.rpc", "SerializationException", new String[0]);
    private static final QualifiedName SERIALIZATION_STREAM_READER = QualifiedName.of("com.google.gwt.user.client.rpc", "SerializationStreamReader", new String[0]);
    private static final QualifiedName SERIALIZATION_STREAM_WRITER = QualifiedName.of("com.google.gwt.user.client.rpc", "SerializationStreamWriter", new String[0]);

    GwtSupport() {
    }

    public static Metadata.Builder gwtMetadata(TypeElement type, Metadata metadata) {
        Metadata.Builder extraMetadata = new Metadata.Builder();
        Optional<AnnotationMirror> annotation = ModelUtils.findAnnotationMirror((Element)type, GwtCompatible.class);
        if (annotation.isPresent()) {
            extraMetadata.addGeneratedBuilderAnnotations(Excerpts.add("@%s%n", GwtCompatible.class));
            Optional<AnnotationValue> serializable = ModelUtils.findProperty((AnnotationMirror)annotation.get(), "serializable");
            if (serializable.isPresent() && ((AnnotationValue)serializable.get()).getValue().equals(Boolean.TRUE)) {
                extraMetadata.setValueTypeVisibility(Metadata.Visibility.PACKAGE);
                extraMetadata.addValueTypeAnnotations(Excerpts.add("@%s(serializable = true)%n", GwtCompatible.class));
                extraMetadata.addNestedClasses(new CustomValueSerializer());
                extraMetadata.addNestedClasses(new GwtWhitelist());
                QualifiedName builderName = metadata.getGeneratedBuilder().getQualifiedName();
                extraMetadata.addVisibleNestedTypes(new QualifiedName[]{builderName.nestedType("Value_CustomFieldSerializer"), builderName.nestedType("GwtWhitelist")});
            }
        }
        return extraMetadata;
    }

    private static String withInitialCapital(Object obj) {
        String s = obj.toString();
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static final class GwtWhitelistExcerpt
    extends Excerpt {
        private final Metadata metadata;

        private GwtWhitelistExcerpt(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("/** This class exists solely to ensure GWT whitelists all required types. */", new Object[0]).addLine("@%s(serializable = true)", GwtCompatible.class).addLine("static final class GwtWhitelist%s %s %s {", this.metadata.getType().declarationParameters(), this.metadata.isInterfaceType() ? "implements " : "extends ", this.metadata.getType()).addLine("", new Object[0]);
            for (Metadata.Property property : this.metadata.getProperties()) {
                code.addLine("  %s %s;", property.getType(), property.getName());
            }
            code.addLine("", new Object[0]).addLine("  private GwtWhitelist() {", new Object[0]).addLine("    throw new %s();", UnsupportedOperationException.class).addLine("   }", new Object[0]);
            for (Metadata.Property property : this.metadata.getProperties()) {
                code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s %s() {", property.getType(), property.getGetterName()).addLine("    throw new %s();", UnsupportedOperationException.class).addLine("  }", new Object[0]);
            }
            code.addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("metadata", this.metadata);
        }
    }

    private static final class GwtWhitelist
    implements Function<Metadata, Excerpt> {
        private GwtWhitelist() {
        }

        public Excerpt apply(Metadata metadata) {
            return new GwtWhitelistExcerpt(metadata);
        }
    }

    private static final class CustomValueSerializerExcerpt
    extends Excerpt {
        private final Metadata metadata;

        private CustomValueSerializerExcerpt(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("@%s", GwtCompatible.class);
            if (this.metadata.getType().isParameterized()) {
                code.addLine("@%s(\"unchecked\")", SuppressWarnings.class);
            }
            code.addLine("public static class Value_CustomFieldSerializer", new Object[0]).addLine("    extends %s<%s> {", CUSTOM_FIELD_SERIALIZER, this.metadata.getValueType()).addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public void deserializeInstance(%s reader, %s instance) { }", SERIALIZATION_STREAM_READER, this.metadata.getValueType()).addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean hasCustomInstantiateInstance() {", new Object[0]).addLine("    return true;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s instantiateInstance(%s reader)", this.metadata.getValueType(), SERIALIZATION_STREAM_READER).addLine("      throws %s {", SERIALIZATION_EXCEPTION).addLine("    %1$s builder = new %1$s();", this.metadata.getBuilder());
            for (Metadata.Property property : this.metadata.getProperties()) {
                if (property.getType().getKind().isPrimitive()) {
                    code.addLine("      %s %s = reader.read%s();", property.getType(), property.getName(), GwtSupport.withInitialCapital(property.getType()));
                    property.getCodeGenerator().addSetFromResult(code, "builder", property.getName());
                    continue;
                }
                if (String.class.getName().equals(property.getType().toString())) {
                    code.addLine("      %s %s = reader.readString();", property.getType(), property.getName());
                    property.getCodeGenerator().addSetFromResult(code, "builder", property.getName());
                    continue;
                }
                code.addLine("    try {", new Object[0]);
                if (!property.isFullyCheckedCast()) {
                    code.addLine("      @SuppressWarnings(\"unchecked\")", new Object[0]);
                }
                code.addLine("      %1$s %2$s = (%1$s) reader.readObject();", property.getType(), property.getName());
                property.getCodeGenerator().addSetFromResult(code, "builder", property.getName());
                code.addLine("    } catch (%s e) {", ClassCastException.class).addLine("      throw new %s(", SERIALIZATION_EXCEPTION).addLine("          \"Wrong type for property '%s'\", e);", property.getName()).addLine("    }", new Object[0]);
            }
            code.addLine("    return (%s) builder.build();", this.metadata.getValueType()).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public void serializeInstance(%s writer, %s instance)", SERIALIZATION_STREAM_WRITER, this.metadata.getValueType()).addLine("      throws %s {", SERIALIZATION_EXCEPTION);
            for (Metadata.Property property : this.metadata.getProperties()) {
                if (property.getType().getKind().isPrimitive()) {
                    code.add("    writer.write%s(", GwtSupport.withInitialCapital(property.getType()), property.getName());
                } else if (String.class.getName().equals(property.getType().toString())) {
                    code.add("    writer.writeString(", property.getName());
                } else {
                    code.add("    writer.writeObject(", property.getName());
                }
                property.getCodeGenerator().addReadValueFragment(code, "instance." + property.getName());
                code.add(");\n", new Object[0]);
            }
            code.addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  private static final Value_CustomFieldSerializer INSTANCE = new Value_CustomFieldSerializer();", new Object[0]).addLine("", new Object[0]).addLine("  public static void deserialize(%s reader, %s instance) {", SERIALIZATION_STREAM_READER, this.metadata.getValueType()).addLine("    INSTANCE.deserializeInstance(reader, instance);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  public static %s instantiate(%s reader)", this.metadata.getValueType(), SERIALIZATION_STREAM_READER).addLine("      throws %s {", SERIALIZATION_EXCEPTION).addLine("    return INSTANCE.instantiateInstance(reader);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  public static void serialize(%s writer, %s instance)", SERIALIZATION_STREAM_WRITER, this.metadata.getValueType()).addLine("      throws %s {", SERIALIZATION_EXCEPTION).addLine("    INSTANCE.serializeInstance(writer, instance);", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("metadata", this.metadata);
        }
    }

    private static final class CustomValueSerializer
    implements Function<Metadata, Excerpt> {
        private CustomValueSerializer() {
        }

        public Excerpt apply(Metadata metadata) {
            return new CustomValueSerializerExcerpt(metadata);
        }
    }
}

