/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Metadata_Builder;
import org.inferred.freebuilder.processor.Metadata_Property_Builder;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;

public abstract class Metadata {
    public static final Function<Property, PropertyCodeGenerator> GET_CODE_GENERATOR = new Function<Property, PropertyCodeGenerator>(){

        public PropertyCodeGenerator apply(Property input) {
            return input.getCodeGenerator();
        }
    };

    public abstract ParameterizedType getType();

    public abstract boolean isInterfaceType();

    abstract Optional<ParameterizedType> getOptionalBuilder();

    public boolean hasBuilder() {
        return this.getOptionalBuilder().isPresent();
    }

    public ParameterizedType getBuilder() {
        return (ParameterizedType)this.getOptionalBuilder().get();
    }

    public abstract Optional<BuilderFactory> getBuilderFactory();

    public abstract ParameterizedType getGeneratedBuilder();

    public abstract ParameterizedType getValueType();

    public abstract ParameterizedType getPartialType();

    public abstract ImmutableSet<QualifiedName> getVisibleNestedTypes();

    public abstract ParameterizedType getPropertyEnum();

    public abstract ImmutableList<Property> getProperties();

    public UnderrideLevel standardMethodUnderride(StandardMethod standardMethod) {
        UnderrideLevel underrideLevel = (UnderrideLevel)((Object)this.getStandardMethodUnderrides().get((Object)standardMethod));
        return underrideLevel == null ? UnderrideLevel.ABSENT : underrideLevel;
    }

    public abstract ImmutableMap<StandardMethod, UnderrideLevel> getStandardMethodUnderrides();

    public abstract boolean isBuilderSerializable();

    public abstract ImmutableList<Excerpt> getGeneratedBuilderAnnotations();

    public abstract ImmutableList<Excerpt> getValueTypeAnnotations();

    public abstract Visibility getValueTypeVisibility();

    public abstract ImmutableList<Function<Metadata, Excerpt>> getNestedClasses();

    public Builder toBuilder() {
        return new Builder().mergeFrom(this);
    }

    public static class Builder
    extends Metadata_Builder {
        public Builder() {
            super.setValueTypeVisibility(Visibility.PRIVATE);
        }

        @Override
        public Builder setValueTypeVisibility(Visibility visibility) {
            return super.setValueTypeVisibility(Visibility.mostVisible(this.getValueTypeVisibility(), visibility));
        }

        public Builder setBuilder(Optional<ParameterizedType> builder) {
            return this.setOptionalBuilder((Optional)builder);
        }

        public Builder setBuilder(ParameterizedType builder) {
            return this.setOptionalBuilder(builder);
        }

        @Override
        public Metadata build() {
            Metadata metadata = super.build();
            QualifiedName generatedBuilder = metadata.getGeneratedBuilder().getQualifiedName();
            Preconditions.checkState((boolean)metadata.getValueType().getQualifiedName().getEnclosingType().equals(generatedBuilder), (String)"%s not a nested class of %s", (Object[])new Object[]{metadata.getValueType(), generatedBuilder});
            Preconditions.checkState((boolean)metadata.getPartialType().getQualifiedName().getEnclosingType().equals(generatedBuilder), (String)"%s not a nested class of %s", (Object[])new Object[]{metadata.getPartialType(), generatedBuilder});
            Preconditions.checkState((boolean)metadata.getPropertyEnum().getQualifiedName().getEnclosingType().equals(generatedBuilder), (String)"%s not a nested class of %s", (Object[])new Object[]{metadata.getPropertyEnum(), generatedBuilder});
            return metadata;
        }
    }

    public static abstract class Property {
        public abstract TypeMirror getType();

        @Nullable
        public abstract TypeMirror getBoxedType();

        public abstract String getName();

        public abstract String getCapitalizedName();

        public abstract String getAllCapsName();

        public abstract boolean isUsingBeanConvention();

        public abstract String getGetterName();

        @Nullable
        public abstract PropertyCodeGenerator getCodeGenerator();

        public abstract boolean isFullyCheckedCast();

        public abstract ImmutableList<Excerpt> getAccessorAnnotations();

        public Builder toBuilder() {
            return new Builder().mergeFrom(this);
        }

        public static class Builder
        extends Metadata_Property_Builder {
        }
    }

    public static class Visibility
    extends Excerpt {
        public static final Visibility PUBLIC = new Visibility(0, "PUBLIC", "public ");
        public static final Visibility PROTECTED = new Visibility(1, "PROTECTED", "protected ");
        public static final Visibility PACKAGE = new Visibility(2, "PACKAGE", "");
        public static final Visibility PRIVATE = new Visibility(3, "PRIVATE", "private ");
        private final int order;
        private final String name;
        private final String excerpt;

        Visibility(int order, String name, String excerpt) {
            this.order = order;
            this.name = name;
            this.excerpt = excerpt;
        }

        public static Visibility mostVisible(Visibility a, Visibility b) {
            return a.order < b.order ? a : b;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.add(this.excerpt, new Object[0]);
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("excerpt", this.excerpt);
        }
    }

    public static enum UnderrideLevel {
        ABSENT,
        OVERRIDEABLE,
        FINAL;

    }

    public static enum StandardMethod {
        TO_STRING,
        HASH_CODE,
        EQUALS;

    }
}

