/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.inferred.freebuilder.processor.Analyser;

public class MethodFinder {
    public static ImmutableSet<ExecutableElement> methodsOn(TypeElement type, Elements elements) throws Analyser.CannotGenerateCodeException {
        TypeElement objectType = elements.getTypeElement(Object.class.getCanonicalName());
        LinkedHashMultimap methods = LinkedHashMultimap.create();
        for (TypeElement supertype : MethodFinder.getSupertypes(type)) {
            for (ExecutableElement method : ElementFilter.methodsIn(supertype.getEnclosedElements())) {
                if (method.getEnclosingElement().equals(objectType)) continue;
                Signature signature = new Signature(method);
                Iterator iterator = methods.get((Object)signature).iterator();
                while (iterator.hasNext()) {
                    ExecutableElement otherMethod = (ExecutableElement)iterator.next();
                    if (!elements.overrides(method, otherMethod, type) && !method.getParameters().equals(otherMethod.getParameters())) continue;
                    iterator.remove();
                }
                methods.put((Object)signature, (Object)method);
            }
        }
        return ImmutableSet.copyOf((Collection)methods.values());
    }

    private static ImmutableSet<TypeElement> getSupertypes(TypeElement type) throws Analyser.CannotGenerateCodeException {
        LinkedHashSet<TypeElement> supertypes = new LinkedHashSet<TypeElement>();
        MethodFinder.addSupertypesToSet(type, supertypes);
        return ImmutableSet.copyOf(supertypes);
    }

    private static void addSupertypesToSet(TypeElement type, Set<TypeElement> mutableSet) throws Analyser.CannotGenerateCodeException {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            MethodFinder.addSupertypesToSet(MethodFinder.asTypeElement(typeMirror), mutableSet);
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            MethodFinder.addSupertypesToSet(MethodFinder.asTypeElement(type.getSuperclass()), mutableSet);
        }
        mutableSet.add(type);
    }

    private static TypeElement asTypeElement(TypeMirror iface) throws Analyser.CannotGenerateCodeException {
        if (iface.getKind() != TypeKind.DECLARED) {
            throw new Analyser.CannotGenerateCodeException();
        }
        Element element = ((DeclaredType)iface).asElement();
        if (!element.getKind().isClass() && !element.getKind().isInterface()) {
            throw new Analyser.CannotGenerateCodeException();
        }
        return (TypeElement)element;
    }

    private MethodFinder() {
    }

    private static class Signature {
        final Name name;
        final int params;

        Signature(ExecutableElement method) {
            this.name = method.getSimpleName();
            this.params = method.getParameters().size();
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + this.params;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Signature)) {
                return false;
            }
            Signature other = (Signature)obj;
            return this.name.equals(other.name) && this.params == other.params;
        }
    }
}

