/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;

public class NullablePropertyFactory
implements PropertyCodeGenerator.Factory {
    public Optional<CodeGenerator> create(PropertyCodeGenerator.Config config) {
        Metadata.Property property = config.getProperty();
        boolean isPrimitive = property.getType().getKind().isPrimitive();
        Set<TypeElement> nullableAnnotations = NullablePropertyFactory.nullablesIn(config.getAnnotations());
        if (isPrimitive || nullableAnnotations.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new CodeGenerator(config.getMetadata(), property, nullableAnnotations));
    }

    private static Set<TypeElement> nullablesIn(Iterable<? extends AnnotationMirror> annotations) {
        ImmutableSet.Builder nullableAnnotations = ImmutableSet.builder();
        for (AnnotationMirror annotationMirror : annotations) {
            TypeElement type;
            if (!annotationMirror.getElementValues().isEmpty() || !(type = (TypeElement)annotationMirror.getAnnotationType().asElement()).getSimpleName().contentEquals("Nullable")) continue;
            nullableAnnotations.add((Object)type);
        }
        return nullableAnnotations.build();
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        private final Set<TypeElement> nullables;

        CodeGenerator(Metadata metadata, Metadata.Property property, Iterable<TypeElement> nullableAnnotations) {
            super(metadata, property);
            this.nullables = ImmutableSet.copyOf(nullableAnnotations);
        }

        @Override
        public PropertyCodeGenerator.Type getType() {
            return PropertyCodeGenerator.Type.OPTIONAL;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            this.addGetterAnnotations(code);
            code.add("private %s %s = null;\n", this.property.getType(), this.property.getName());
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code) {
            this.addSetter(code, this.metadata);
            this.addMapper(code, this.metadata);
            this.addGetter(code, this.metadata);
        }

        private void addSetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]);
            this.addAccessorAnnotations(code);
            code.add("public %s %s(", metadata.getBuilder(), BuilderMethods.setter(this.property));
            this.addGetterAnnotations(code);
            code.add("%s %s) {\n", this.property.getType(), this.property.getName()).addLine("  this.%1$s = %1$s;", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addMapper(SourceBuilder code, Metadata metadata) {
            ParameterizedType unaryOperator = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).unaryOperator().orNull();
            if (unaryOperator == null) {
                return;
            }
            TypeMirror typeParam = (TypeMirror)MoreObjects.firstNonNull((Object)this.property.getBoxedType(), (Object)this.property.getType());
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * If the value to be returned by %s is not", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * null, replaces it by applying {@code mapper} to it and using the result.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mapper} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mapper) {", metadata.getBuilder(), BuilderMethods.mapper(this.property), unaryOperator.withParameters(typeParam)).add(PreconditionExcerpts.checkNotNull("mapper")).addLine("  %s %s = %s();", this.property.getType(), this.property.getName(), BuilderMethods.getter(this.property)).addLine("  if (%s != null) {", this.property.getName()).addLine("    %s(mapper.apply(%s));", BuilderMethods.setter(this.property), this.property.getName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" */", new Object[0]);
            this.addGetterAnnotations(code);
            code.addLine("public %s %s() {", this.property.getType(), BuilderMethods.getter(this.property)).addLine("  return %s;", this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addValueFieldDeclaration(SourceBuilder code, String finalField) {
            this.addGetterAnnotations(code);
            code.add("private final %s %s;\n", this.property.getType(), finalField);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.%s;", finalField, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(Block code, String value) {
            code.addLine("%s(%s.%s());", BuilderMethods.setter(this.property), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(Block code, String builder) {
            code.addLine("%s(%s.%s());", BuilderMethods.setter(this.property), builder, BuilderMethods.getter(this.property));
        }

        @Override
        public void addGetterAnnotations(SourceBuilder code) {
            for (TypeElement nullableAnnotation : this.nullables) {
                code.add("@%s ", nullableAnnotation);
            }
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
        }

        @Override
        public void addClearField(Block code) {
            Optional<Excerpt> defaults = Declarations.freshBuilder(code, this.metadata);
            if (defaults.isPresent()) {
                code.addLine("%1$s = %2$s.%1$s;", this.property.getName(), defaults.get());
            } else {
                code.addLine("%s = null;", this.property.getName());
            }
        }
    }
}

