/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.inferred.freebuilder.processor.excerpt.CheckedList;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;

public class CheckedListMultimap {
    private static final StaticExcerpt CHECKED_LIST_MULTIMAP = new StaticExcerpt(StaticExcerpt.Type.TYPE, "CheckedListMultimap"){

        @Override
        public void addTo(SourceBuilder code) {
            ParameterizedType biConsumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).biConsumer().orNull();
            if (biConsumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * A multimap implementation that delegates to a provided put method", new Object[0]).addLine(" * to perform entry validation and insertion into a backing multimap.", new Object[0]).addLine(" */", new Object[0]).addLine("private static class CheckedListMultimap<K, V> extends %s<K, V> {", ForwardingListMultimap.class).addLine("", new Object[0]).addLine("  private final %s<K, V> multimap;", ListMultimap.class).addLine("  private final %s<K, V> put;", biConsumer.getQualifiedName()).addLine("", new Object[0]).addLine("  CheckedListMultimap(%s<K, V> multimap, %s<K, V> put) {", ListMultimap.class, biConsumer.getQualifiedName()).addLine("    this.multimap = multimap;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override protected %s<K, V> delegate() {", ListMultimap.class).addLine("    return multimap;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean put(@%1$s K key, @%1$s V value) {", Nullable.class).addLine("    put.accept(key, value);", new Object[0]).addLine("    return true;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean putAll(@%s K key, %s<? extends V> values) {", Nullable.class, Iterable.class).addLine("    boolean anyModified = false;", new Object[0]).addLine("    for (V value : values) {", new Object[0]).addLine("      put.accept(key, value);", new Object[0]).addLine("      anyModified = true;", new Object[0]).addLine("    }", new Object[0]).addLine("    return anyModified;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean putAll(%s<? extends K, ? extends V> multimap) {", Multimap.class).addLine("    boolean changed = false;", new Object[0]).addLine("    for (%s<? extends K, ? extends V> entry : multimap.entries()) {", Map.Entry.class).addLine("      put.accept(entry.getKey(), entry.getValue());", new Object[0]).addLine("      changed = true;", new Object[0]).addLine("    }", new Object[0]).addLine("    return changed;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override", new Object[0]).addLine("  public %s<V> replaceValues(@%s K key, %s<? extends V> values) {", List.class, Nullable.class, Iterable.class).addLine("    %s.checkNotNull(values);", Preconditions.class).addLine("    %s<V> result = removeAll(key);", List.class).addLine("    putAll(key, values);", new Object[0]).addLine("    return result;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<V> get(@%s K key) {", List.class, Nullable.class).addLine("    return new CheckedList<>(", new Object[0]).addLine("        multimap.get(key), value -> put.accept(key, value));", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<K, %s<V>> asMap() {", Map.class, Collection.class).addLine("    return %s.transformEntries(%s.asMap(multimap), (key, values) -> ", Maps.class, Multimaps.class).addLine("        new CheckedList<>(values, value -> put.accept(key, value)));", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }
    };

    public static List<StaticExcerpt> excerpts() {
        return ImmutableList.builder().addAll(CheckedList.excerpts()).add((Object)CHECKED_LIST_MULTIMAP).build();
    }

    private CheckedListMultimap() {
    }
}

