/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.naming;

import com.google.common.base.Optional;
import java.beans.Introspector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.naming.NamingConvention;
import org.inferred.freebuilder.processor.util.IsInvalidTypeVisitor;
import org.inferred.freebuilder.processor.util.ModelUtils;

class BeanConvention
implements NamingConvention {
    static final Pattern GETTER_PATTERN = Pattern.compile("^(get|is)([^\\p{javaLowerCase}].*)");
    static final String GET_PREFIX = "get";
    static final String IS_PREFIX = "is";
    private final Messager messager;
    private final Types types;

    BeanConvention(Messager messager, Types types) {
        this.messager = messager;
        this.types = types;
    }

    @Override
    public Optional<Metadata.Property.Builder> getPropertyNames(TypeElement valueType, ExecutableElement method) {
        boolean declaredOnValueType = method.getEnclosingElement().equals(valueType);
        String name = method.getSimpleName().toString();
        Matcher getterMatcher = GETTER_PATTERN.matcher(name);
        if (!getterMatcher.matches()) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Only getter methods (starting with 'get' or 'is') may be declared abstract on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return Optional.absent();
        }
        String prefix = getterMatcher.group(1);
        String capitalizedName = getterMatcher.group(2);
        if (BeanConvention.hasUpperCase(capitalizedName.codePointAt(0))) {
            if (declaredOnValueType) {
                String message = new StringBuilder().append("Getter methods cannot have a lowercase character immediately after the '").append(prefix).append("' prefix on @FreeBuilder types (did you mean '").append(prefix).appendCodePoint(Character.toUpperCase(capitalizedName.codePointAt(0))).append(capitalizedName.substring(capitalizedName.offsetByCodePoints(0, 1))).append("'?)").toString();
                this.messager.printMessage(Diagnostic.Kind.ERROR, message, method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return Optional.absent();
        }
        TypeMirror returnType = ModelUtils.getReturnType(valueType, method, this.types);
        if (returnType.getKind() == TypeKind.VOID) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Getter methods must not be void on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return Optional.absent();
        }
        if (prefix.equals(IS_PREFIX) && returnType.getKind() != TypeKind.BOOLEAN) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Getter methods starting with 'is' must return a boolean on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return Optional.absent();
        }
        if (!method.getParameters().isEmpty()) {
            if (declaredOnValueType) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Getter methods cannot take parameters on @FreeBuilder types", method);
            } else {
                this.printNoImplementationMessage(valueType, method);
            }
            return Optional.absent();
        }
        if (((Boolean)new IsInvalidTypeVisitor().visit(returnType)).booleanValue()) {
            return Optional.absent();
        }
        String camelCaseName = Introspector.decapitalize(capitalizedName);
        return Optional.of((Object)new Metadata.Property.Builder().setUsingBeanConvention(true).setName(camelCaseName).setCapitalizedName(capitalizedName).setGetterName(getterMatcher.group(0)));
    }

    private static boolean hasUpperCase(int codepoint) {
        return Character.toUpperCase(codepoint) != codepoint;
    }

    private void printNoImplementationMessage(TypeElement valueType, ExecutableElement method) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, "No implementation found for non-getter method '" + method + "'; cannot generate @FreeBuilder implementation", valueType);
    }
}

