/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.feature.JavaxPackage;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public class Excerpts {
    private static final Excerpt EMPTY = new EmptyExcerpt();

    public static Excerpt add(String fmt, Object ... args) {
        return new AddingExcerpt(fmt, args);
    }

    public static Excerpt empty() {
        return EMPTY;
    }

    public static Excerpt forEach(TypeMirror elementType, String iterable, String method) {
        return new ForEachExcerpt(elementType, iterable, method);
    }

    public static Excerpt generated(Class<?> generator) {
        return new GeneratedAnnotationExcerpt(generator);
    }

    public static Object join(String separator, Iterable<?> excerpts) {
        return new JoiningExcerpt(separator, excerpts);
    }

    private Excerpts() {
    }

    private static final class JoiningExcerpt
    extends Excerpt {
        private final String separator;
        private final List<?> excerpts;

        private JoiningExcerpt(String separator, Iterable<?> excerpts) {
            this.separator = separator;
            this.excerpts = ImmutableList.copyOf(excerpts);
        }

        @Override
        public void addTo(SourceBuilder source) {
            String itemPrefix = "";
            for (Object object : this.excerpts) {
                source.add("%s%s", itemPrefix, object);
                itemPrefix = this.separator;
            }
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("separator", this.separator);
            fields.add("excerpts", this.excerpts);
        }
    }

    private static final class GeneratedAnnotationExcerpt
    extends Excerpt {
        private final Class<?> generator;

        GeneratedAnnotationExcerpt(Class<?> generator) {
            this.generator = generator;
        }

        @Override
        public void addTo(SourceBuilder code) {
            QualifiedName generated = (QualifiedName)code.feature(JavaxPackage.JAVAX).generated().orNull();
            if (generated != null) {
                code.addLine("@%s(\"%s\")", generated, this.generator.getName());
            }
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("generator", this.generator);
        }
    }

    private static final class ForEachExcerpt
    extends Excerpt {
        private final TypeMirror elementType;
        private final String iterable;
        private final String method;

        private ForEachExcerpt(TypeMirror elementType, String iterable, String method) {
            this.elementType = elementType;
            this.iterable = iterable;
            this.method = method;
        }

        @Override
        public void addTo(SourceBuilder code) {
            if (code.feature(SourceLevel.SOURCE_LEVEL).hasLambdas()) {
                code.addLine("%s.forEach(this::%s);", this.iterable, this.method);
            } else {
                code.addLine("for (%s element : %s) {", this.elementType, this.iterable).addLine("  %s(element);", this.method).addLine("}", new Object[0]);
            }
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("elementType", this.elementType);
            fields.add("iterable", this.iterable);
            fields.add("method", this.method);
        }
    }

    private static final class EmptyExcerpt
    extends Excerpt {
        private EmptyExcerpt() {
        }

        @Override
        public void addTo(SourceBuilder source) {
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    private static final class AddingExcerpt
    extends Excerpt {
        private final String fmt;
        private final Object[] args;

        private AddingExcerpt(String fmt, Object[] args) {
            this.args = args;
            this.fmt = fmt;
        }

        @Override
        public void addTo(SourceBuilder source) {
            source.add(this.fmt, this.args);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder().append("Excerpts.add(\"").append(this.fmt.replaceAll("[\\\"]", "\\\u0001")).append('\"');
            for (Object arg : this.args) {
                result.append(", ").append(arg);
            }
            result.append(")");
            return result.toString();
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("fmt", this.fmt);
            fields.add("args", Arrays.asList(this.args));
        }
    }
}

