/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.Shading;

public class ModelUtils {
    private static final SimpleElementVisitor6<Optional<TypeElement>, ?> TYPE_ELEMENT_VISITOR = new SimpleElementVisitor6<Optional<TypeElement>, Void>(){

        @Override
        public Optional<TypeElement> visitType(TypeElement e, Void p) {
            return Optional.of((Object)e);
        }

        @Override
        protected Optional<TypeElement> defaultAction(Element e, Void p) {
            return Optional.absent();
        }
    };
    private static final SimpleTypeVisitor6<Optional<DeclaredType>, ?> DECLARED_TYPE_VISITOR = new SimpleTypeVisitor6<Optional<DeclaredType>, Void>(){

        @Override
        public Optional<DeclaredType> visitDeclared(DeclaredType t, Void p) {
            return Optional.of((Object)t);
        }

        @Override
        protected Optional<DeclaredType> defaultAction(TypeMirror e, Void p) {
            return Optional.absent();
        }
    };
    private static final SimpleTypeVisitor6<Optional<TypeVariable>, ?> TYPE_VARIABLE_VISITOR = new SimpleTypeVisitor6<Optional<TypeVariable>, Void>(){

        @Override
        public Optional<TypeVariable> visitTypeVariable(TypeVariable t, Void p) {
            return Optional.of((Object)t);
        }

        @Override
        protected Optional<TypeVariable> defaultAction(TypeMirror e, Void p) {
            return Optional.absent();
        }
    };

    public static Optional<AnnotationMirror> findAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return ModelUtils.findAnnotationMirror(element, Shading.unshadedName(annotationClass.getName()));
    }

    public static Optional<AnnotationMirror> findAnnotationMirror(Element element, QualifiedName annotationClass) {
        return ModelUtils.findAnnotationMirror(element, Shading.unshadedName(annotationClass.toString()));
    }

    public static Optional<AnnotationMirror> findAnnotationMirror(Element element, String annotationClassName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationTypeElement.getQualifiedName().contentEquals(annotationClassName)) continue;
            return Optional.of((Object)annotationMirror);
        }
        return Optional.absent();
    }

    public static Optional<AnnotationValue> findProperty(AnnotationMirror annotation, String propertyName) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> element : annotation.getElementValues().entrySet()) {
            if (!element.getKey().getSimpleName().contentEquals(propertyName)) continue;
            return Optional.of((Object)element.getValue());
        }
        return Optional.absent();
    }

    public static Optional<TypeElement> maybeType(Element element) {
        return (Optional)TYPE_ELEMENT_VISITOR.visit(element);
    }

    public static Optional<DeclaredType> maybeDeclared(TypeMirror type) {
        return (Optional)DECLARED_TYPE_VISITOR.visit(type);
    }

    public static Optional<TypeVariable> maybeVariable(TypeMirror type) {
        return (Optional)TYPE_VARIABLE_VISITOR.visit(type);
    }

    public static Optional<TypeElement> maybeAsTypeElement(TypeMirror type) {
        Optional<DeclaredType> declaredType = ModelUtils.maybeDeclared(type);
        if (declaredType.isPresent()) {
            return ModelUtils.maybeType(((DeclaredType)declaredType.get()).asElement());
        }
        return Optional.absent();
    }

    public static TypeElement asElement(DeclaredType type) {
        return (TypeElement)ModelUtils.maybeType(type.asElement()).get();
    }

    public static Optional<TypeMirror> maybeUnbox(TypeMirror mirror, Types types) {
        try {
            return Optional.of((Object)types.unboxedType(mirror));
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }

    public static boolean overrides(TypeElement type, Types types, String methodName, TypeMirror ... params) {
        for (ExecutableElement method : ElementFilter.methodsIn(type.getEnclosedElements())) {
            if (!ModelUtils.signatureMatches(method, types, methodName, params)) continue;
            return true;
        }
        return false;
    }

    private static boolean signatureMatches(ExecutableElement method, Types types, String name, TypeMirror ... params) {
        if (!method.getSimpleName().contentEquals(name)) {
            return false;
        }
        if (method.getParameters().size() != params.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (types.isSameType(params[i], method.getParameters().get(i).asType())) continue;
            return false;
        }
        return true;
    }

    public static TypeMirror getReturnType(TypeElement type, ExecutableElement method, Types types) {
        try {
            ExecutableType executableType = (ExecutableType)types.asMemberOf((DeclaredType)type.asType(), method);
            return executableType.getReturnType();
        }
        catch (IllegalArgumentException e) {
            return method.getReturnType();
        }
    }
}

