/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceStringBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public class PreconditionExcerpts {
    private static final Escaper JAVA_STRING_ESCAPER = Escapers.builder().addEscape('\"', "\"").addEscape('\\', "\\\\").addEscape('\n', "\\n").build();
    private static final Pattern ANY_OPERATOR = Pattern.compile("[+=<>!&^|?:]|\\binstanceof\\b");

    public static Excerpt checkNotNullPreamble(Object reference) {
        return new CheckNotNullPreambleExcerpt(reference);
    }

    public static Excerpt checkNotNullInline(Object reference) {
        return new CheckNotNullInlineExcerpt(reference);
    }

    public static Excerpt checkNotNull(Object reference) {
        return new CheckNotNullExcerpt(reference);
    }

    public static Excerpt checkArgument(Object condition, String message, Object ... args) {
        return new GuavaCheckExcerpt(args, condition, message, "checkArgument", IllegalArgumentException.class);
    }

    public static Excerpt checkState(Object condition, String message, Object ... args) {
        return new GuavaCheckExcerpt(args, condition, message, "checkState", IllegalStateException.class);
    }

    private static String negate(SourceBuilder code, Object condition) {
        SourceStringBuilder subBuilder = code.subBuilder();
        subBuilder.add("%s", condition);
        String conditionText = subBuilder.toString();
        if (conditionText.startsWith("!")) {
            return conditionText.substring(1);
        }
        if (ANY_OPERATOR.matcher(conditionText).find()) {
            return "!(" + conditionText + ")";
        }
        return "!" + conditionText;
    }

    private PreconditionExcerpts() {
    }

    private static final class CheckNotNullExcerpt
    extends Excerpt {
        private final Object reference;

        private CheckNotNullExcerpt(Object reference) {
            this.reference = reference;
        }

        @Override
        public void addTo(SourceBuilder code) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("%s.checkNotNull(%s);", Preconditions.class, this.reference);
            } else if (code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                code.addLine("%s.requireNonNull(%s);", code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().get(), this.reference);
            } else {
                code.addLine("if (%s == null) {", this.reference).addLine("  throw new NullPointerException();", new Object[0]).addLine("}", new Object[0]);
            }
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("reference", this.reference);
        }
    }

    private static final class CheckNotNullInlineExcerpt
    extends Excerpt {
        private final Object reference;

        private CheckNotNullInlineExcerpt(Object reference) {
            this.reference = reference;
        }

        @Override
        public void addTo(SourceBuilder code) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.add("%s.checkNotNull(%s)", Preconditions.class, this.reference);
            } else if (code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                code.add("%s.requireNonNull(%s)", code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().get(), this.reference);
            } else {
                code.add("%s", this.reference);
            }
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("reference", this.reference);
        }
    }

    private static final class CheckNotNullPreambleExcerpt
    extends Excerpt {
        private final Object reference;

        private CheckNotNullPreambleExcerpt(Object reference) {
            this.reference = reference;
        }

        @Override
        public void addTo(SourceBuilder code) {
            if (!code.feature(GuavaLibrary.GUAVA).isAvailable() && !code.feature(SourceLevel.SOURCE_LEVEL).javaUtilObjects().isPresent()) {
                code.addLine("if (%s == null) {", this.reference).addLine("  throw new NullPointerException();", new Object[0]).addLine("}", new Object[0]);
            }
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("reference", this.reference);
        }
    }

    private static final class GuavaCheckExcerpt
    extends Excerpt {
        private final Object[] args;
        private final Object condition;
        private final String message;
        private final String methodName;
        private final Class<? extends RuntimeException> exceptionType;

        private GuavaCheckExcerpt(Object[] args, Object condition, String message, String methodName, Class<? extends RuntimeException> exceptionType) {
            this.args = args;
            this.condition = condition;
            this.message = message;
            this.methodName = methodName;
            this.exceptionType = exceptionType;
        }

        @Override
        public void addTo(SourceBuilder code) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.add("%s.%s(%s, \"%s\"", Preconditions.class, this.methodName, this.condition, JAVA_STRING_ESCAPER.escape(this.message));
                for (Object arg : this.args) {
                    code.add(", %s", arg);
                }
                code.add(");\n", new Object[0]);
            } else {
                ArrayList<Excerpt> escapedArgs = new ArrayList<Excerpt>();
                for (Object arg : this.args) {
                    escapedArgs.add(Excerpts.add("\" + %s + \"", arg));
                }
                String messageConcatenated = code.subBuilder().add("\"" + JAVA_STRING_ESCAPER.escape(this.message) + "\"", escapedArgs.toArray()).toString().replace("\"\" + ", "").replace(" + \"\"", "");
                code.addLine("if (%s) {", PreconditionExcerpts.negate(code, this.condition)).addLine("  throw new %s(%s);", this.exceptionType, messageConcatenated).addLine("}", new Object[0]);
            }
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("methodName", this.methodName);
            fields.add("exceptionType", this.exceptionType);
            fields.add("condition", this.condition);
            fields.add("message", this.message);
            fields.add("args", Arrays.asList(this.args));
        }
    }
}

