/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util.feature;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.util.Arrays;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.util.Shading;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureSet;
import org.inferred.freebuilder.processor.util.feature.FeatureType;

public enum GuavaLibrary implements Feature<GuavaLibrary>
{
    AVAILABLE("Guava"),
    UNAVAILABLE("No Guava");

    public static final FeatureType<GuavaLibrary> GUAVA;
    private final String humanReadableFormat;

    private GuavaLibrary(String humanReadableFormat) {
        this.humanReadableFormat = humanReadableFormat;
    }

    public boolean isAvailable() {
        return this != UNAVAILABLE;
    }

    private static Class<?> primitiveUtils(TypeMirror elementType) {
        switch (elementType.getKind()) {
            case BOOLEAN: {
                return Booleans.class;
            }
            case BYTE: {
                return Bytes.class;
            }
            case CHAR: {
                return Chars.class;
            }
            case DOUBLE: {
                return Doubles.class;
            }
            case FLOAT: {
                return Floats.class;
            }
            case INT: {
                return Ints.class;
            }
            case LONG: {
                return Longs.class;
            }
            case SHORT: {
                return Shorts.class;
            }
        }
        throw new IllegalArgumentException("Unexpected primitive type " + elementType);
    }

    public Optional<Class<?>> arrayUtils(TypeMirror elementType) {
        if (!elementType.getKind().isPrimitive()) {
            return Optional.of(Arrays.class);
        }
        if (this.isAvailable()) {
            return Optional.fromNullable(GuavaLibrary.primitiveUtils(elementType));
        }
        return Optional.absent();
    }

    public String toString() {
        return this.humanReadableFormat;
    }

    static {
        GUAVA = new FeatureType<GuavaLibrary>(){

            @Override
            protected GuavaLibrary testDefault(FeatureSet features) {
                return UNAVAILABLE;
            }

            @Override
            protected GuavaLibrary forEnvironment(ProcessingEnvironment env, FeatureSet features) {
                String name = Shading.unshadedName(ImmutableList.class.getName());
                TypeElement element = env.getElementUtils().getTypeElement(name);
                return element != null ? AVAILABLE : UNAVAILABLE;
            }
        };
    }
}

