/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.excerpt.CheckedList;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public class ListPropertyFactory
implements PropertyCodeGenerator.Factory {
    private static final StaticExcerpt IMMUTABLE_LIST = new StaticExcerpt(StaticExcerpt.Type.METHOD, "immutableList"){

        @Override
        public void addTo(SourceBuilder code) {
            if (!code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("", new Object[0]).addLine("@%s(\"unchecked\")", SuppressWarnings.class).addLine("private static <E> %1$s<E> immutableList(%1$s<E> elements, %2$s<E> type) {", List.class, Class.class).addLine("  switch (elements.size()) {", new Object[0]).addLine("  case 0:", new Object[0]).addLine("    return %s.emptyList();", Collections.class).addLine("  case 1:", new Object[0]).addLine("    return %s.singletonList(elements.get(0));", Collections.class).addLine("  default:", new Object[0]).addLine("    return %s.unmodifiableList(%s.asList(elements.toArray(", Collections.class, Arrays.class).addLine("        (E[]) %s.newInstance(type, elements.size()))));", Array.class).addLine("  }", new Object[0]).addLine("}", new Object[0]);
            }
        }
    };

    @Override
    public Optional<? extends PropertyCodeGenerator> create(PropertyCodeGenerator.Config config) {
        DeclaredType type = (DeclaredType)ModelUtils.maybeDeclared(config.getProperty().getType()).orNull();
        if (type == null || !Util.erasesToAnyOf(type, Collection.class, List.class, ImmutableList.class)) {
            return Optional.absent();
        }
        TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
        Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
        boolean overridesAddMethod = ListPropertyFactory.hasAddMethodOverride(config, (TypeMirror)unboxedType.or((Object)elementType));
        return Optional.of((Object)new CodeGenerator(config.getMetadata(), config.getProperty(), overridesAddMethod, elementType, unboxedType));
    }

    private static boolean hasAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror keyType) {
        return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), keyType);
    }

    @VisibleForTesting
    static class CodeGenerator
    extends PropertyCodeGenerator {
        private static final ParameterizedType COLLECTION = QualifiedName.of(Collection.class).withParameters("E");
        private final boolean overridesAddMethod;
        private final TypeMirror elementType;
        private final Optional<TypeMirror> unboxedType;

        @VisibleForTesting
        CodeGenerator(Metadata metadata, Metadata.Property property, boolean overridesAddMethod, TypeMirror elementType, Optional<TypeMirror> unboxedType) {
            super(metadata, property);
            this.overridesAddMethod = overridesAddMethod;
            this.elementType = elementType;
            this.unboxedType = unboxedType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("private %s<%s> %s = %s.of();", List.class, this.elementType, this.property.getName(), ImmutableList.class);
            } else {
                code.addLine("private final %1$s<%2$s> %3$s = new %1$s%4$s();", ArrayList.class, this.elementType, this.property.getName(), SourceLevel.diamondOperator(this.elementType));
            }
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code) {
            this.addAdd(code, this.metadata);
            this.addVarargsAdd(code, this.metadata);
            this.addAddAllMethods(code, this.metadata);
            this.addMutate(code, this.metadata);
            this.addClear(code, this.metadata);
            this.addGetter(code, this.metadata);
        }

        private void addAdd(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the list to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", metadata.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.or((Object)this.elementType));
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("  if (this.%s instanceof %s) {", this.property.getName(), ImmutableList.class).addLine("    this.%1$s = new %2$s%3$s(this.%1$s);", this.property.getName(), ArrayList.class, SourceLevel.diamondOperator(this.elementType)).addLine("  }", new Object[0]);
            }
            if (this.unboxedType.isPresent()) {
                code.addLine("  this.%s.add(element);", this.property.getName());
            } else {
                code.add(PreconditionExcerpts.checkNotNullPreamble("element")).addLine("  this.%s.add(%s);", this.property.getName(), PreconditionExcerpts.checkNotNullInline("element"));
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addVarargsAdd(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the list to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s... elements) {", metadata.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.or((Object)this.elementType));
            Optional<Class<?>> arrayUtils = code.feature(GuavaLibrary.GUAVA).arrayUtils((TypeMirror)this.unboxedType.or((Object)this.elementType));
            if (arrayUtils.isPresent()) {
                code.addLine("  return %s(%s.asList(elements));", BuilderMethods.addAllMethod(this.property), arrayUtils.get());
            } else {
                code.addLine("  %1$s.ensureCapacity(%1$s.size() + elements.length);", this.property.getName()).addLine("  for (%s element : elements) {", this.unboxedType.get()).addLine("    %s(element);", BuilderMethods.addMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder());
            }
            code.addLine("}", new Object[0]);
        }

        private void addAddAllMethods(SourceBuilder code, Metadata metadata) {
            if (code.feature(SourceLevel.SOURCE_LEVEL).stream().isPresent()) {
                this.addSpliteratorAddAll(code, metadata);
                this.addStreamAddAll(code, metadata);
                this.addIterableAddAll(code, metadata);
            } else {
                this.addPreStreamsAddAll(code, metadata);
            }
        }

        private void addPreStreamsAddAll(SourceBuilder code, Metadata metadata) {
            this.addJavadocForAddAll(code, metadata);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s<? extends %s> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType);
            code.addLine("  if (elements instanceof %s) {", Collection.class).addLine("    int elementsSize = ((%s<?>) elements).size();", Collection.class);
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("    if (elementsSize != 0) {", new Object[0]).addLine("      if (%s instanceof %s) {", this.property.getName(), ImmutableList.class).addLine("        %1$s = new %2$s%3$s(%1$s);", this.property.getName(), ArrayList.class, SourceLevel.diamondOperator(this.elementType)).addLine("      }", new Object[0]).add("      ((%s<?>) %s)", ArrayList.class, this.property.getName());
            } else {
                code.add("    %s", this.property.getName());
            }
            code.add(".ensureCapacity(%s.size() + elementsSize);%n", this.property.getName()).addLine("  }", new Object[0]);
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("  }", new Object[0]);
            }
            code.add(Excerpts.forEach((TypeMirror)this.unboxedType.or((Object)this.elementType), "elements", BuilderMethods.addMethod(this.property))).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addSpliteratorAddAll(SourceBuilder code, Metadata metadata) {
            QualifiedName spliterator = (QualifiedName)code.feature(SourceLevel.SOURCE_LEVEL).spliterator().get();
            this.addJavadocForAddAll(code, metadata);
            code.addLine("public %s %s(%s<? extends %s> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), spliterator, this.elementType);
            code.addLine("  if ((elements.characteristics() & %s.SIZED) != 0) {", spliterator).addLine("    long elementsSize = elements.estimateSize();", new Object[0]).addLine("    if (elementsSize > 0 && elementsSize <= Integer.MAX_VALUE) {", new Object[0]);
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("      if (%s instanceof %s) {", this.property.getName(), ImmutableList.class).addLine("        %1$s = new %2$s%3$s(%1$s);", this.property.getName(), ArrayList.class, SourceLevel.diamondOperator(this.elementType)).addLine("      }", new Object[0]).add("      ((%s<?>) %s)", ArrayList.class, this.property.getName());
            } else {
                code.add("      %s", this.property.getName());
            }
            code.add(".ensureCapacity(%s.size() + (int) elementsSize);%n", this.property.getName()).addLine("    }", new Object[0]).addLine("  }", new Object[0]).addLine("  elements.forEachRemaining(this::%s);", BuilderMethods.addMethod(this.property)).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addIterableAddAll(SourceBuilder code, Metadata metadata) {
            this.addJavadocForAddAll(code, metadata);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s<? extends %s> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
        }

        private void addStreamAddAll(SourceBuilder code, Metadata metadata) {
            QualifiedName baseStream = (QualifiedName)code.feature(SourceLevel.SOURCE_LEVEL).baseStream().get();
            this.addJavadocForAddAll(code, metadata);
            code.addLine("public %s %s(%s<? extends %s, ?> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), baseStream, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
        }

        private void addJavadocForAddAll(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the list to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
        }

        private void addMutate(SourceBuilder code, Metadata metadata) {
            ParameterizedType consumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).consumer().orNull();
            if (consumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the list to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the list in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", COLLECTION.javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s<? super %s<%s>> mutator) {", metadata.getBuilder(), BuilderMethods.mutator(this.property), consumer.getQualifiedName(), List.class, this.elementType);
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("  if (this.%s instanceof %s) {", this.property.getName(), ImmutableList.class).addLine("    this.%1$s = new %2$s%3$s(this.%1$s);", this.property.getName(), ArrayList.class, SourceLevel.diamondOperator(this.elementType)).addLine("  }", new Object[0]);
            }
            if (this.overridesAddMethod) {
                code.addLine("  mutator.accept(new CheckedList<>(%s, this::%s));", this.property.getName(), BuilderMethods.addMethod(this.property));
            } else {
                code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.addMethod(this.property)).addLine("  mutator.accept(%s);", this.property.getName());
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addClear(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the list to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", metadata.getBuilder(), BuilderMethods.clearMethod(this.property));
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("  if (%s instanceof %s) {", this.property.getName(), ImmutableList.class).addLine("    %s = %s.of();", this.property.getName(), ImmutableList.class).addLine("  } else {", new Object[0]);
            }
            code.addLine("    %s.clear();", this.property.getName());
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("  }", new Object[0]);
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the list that will be returned by", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s() {", List.class, this.elementType, BuilderMethods.getter(this.property));
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("  if (%s instanceof %s) {", this.property.getName(), ImmutableList.class).addLine("    %1$s = new %2$s%3$s(%1$s);", this.property.getName(), ArrayList.class, SourceLevel.diamondOperator(this.elementType)).addLine("  }", new Object[0]);
            }
            code.addLine("  return %s.unmodifiableList(%s);", Collections.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("%s = %s.copyOf(%s.%s);", finalField, ImmutableList.class, builder, this.property.getName());
            } else {
                code.addLine("%s = immutableList(%s.%s, %s.class);", finalField, builder, this.property.getName(), this.elementType);
            }
        }

        @Override
        public void addMergeFromValue(Block code, String value) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("if (%s instanceof %s && %s == %s.<%s>of()) {", value, this.metadata.getValueType(), this.property.getName(), ImmutableList.class, this.elementType).addLine("  %s = %s.%s();", this.property.getName(), value, this.property.getGetterName()).addLine("} else {", new Object[0]);
            }
            code.addLine("%s(%s.%s());", BuilderMethods.addAllMethod(this.property), value, this.property.getGetterName());
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                code.addLine("}", new Object[0]);
            }
        }

        @Override
        public void addMergeFromBuilder(Block code, String builder) {
            Excerpt base = Declarations.upcastToGeneratedBuilder(code, this.metadata, builder);
            code.addLine("%s(%s.%s);", BuilderMethods.addAllMethod(this.property), base, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, BuilderMethods.addAllMethod(this.property), variable);
        }

        @Override
        public void addClearField(Block code) {
            code.addLine("%s();", BuilderMethods.clearMethod(this.property));
        }

        public Set<StaticExcerpt> getStaticExcerpts() {
            ImmutableSet.Builder methods = ImmutableSet.builder();
            methods.add((Object)IMMUTABLE_LIST);
            if (this.overridesAddMethod) {
                methods.addAll(CheckedList.excerpts());
            }
            return methods.build();
        }
    }
}

