/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.excerpt.CheckedMultiset;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public class MultisetPropertyFactory
implements PropertyCodeGenerator.Factory {
    public Optional<CodeGenerator> create(PropertyCodeGenerator.Config config) {
        DeclaredType type = (DeclaredType)ModelUtils.maybeDeclared(config.getProperty().getType()).orNull();
        if (type == null || !Util.erasesToAnyOf(type, Multiset.class, ImmutableMultiset.class)) {
            return Optional.absent();
        }
        TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
        Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
        boolean overridesSetCountMethod = MultisetPropertyFactory.hasSetCountMethodOverride(config, (TypeMirror)unboxedType.or((Object)elementType));
        return Optional.of((Object)new CodeGenerator(config.getMetadata(), config.getProperty(), overridesSetCountMethod, elementType, unboxedType));
    }

    private static boolean hasSetCountMethodOverride(PropertyCodeGenerator.Config config, TypeMirror type) {
        return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.setCountMethod(config.getProperty()), type, config.getTypes().getPrimitiveType(TypeKind.INT));
    }

    private static class CodeGenerator
    extends PropertyCodeGenerator {
        private static final ParameterizedType COLLECTION = QualifiedName.of(Collection.class).withParameters("E");
        private final boolean overridesSetCountMethod;
        private final TypeMirror elementType;
        private final Optional<TypeMirror> unboxedType;

        CodeGenerator(Metadata metadata, Metadata.Property property, boolean overridesSetCountMethod, TypeMirror elementType, Optional<TypeMirror> unboxedType) {
            super(metadata, property);
            this.overridesSetCountMethod = overridesSetCountMethod;
            this.elementType = elementType;
            this.unboxedType = unboxedType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("private final %1$s<%2$s> %3$s = %1$s.create();", LinkedHashMultiset.class, this.elementType, this.property.getName());
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code) {
            this.addAdd(code, this.metadata);
            this.addVarargsAdd(code, this.metadata);
            this.addAddAllMethods(code, this.metadata);
            this.addAddCopiesTo(code, this.metadata);
            this.addMutate(code, this.metadata);
            this.addClear(code, this.metadata);
            this.addSetCountOf(code, this.metadata);
            this.addGetter(code, this.metadata);
        }

        private void addAdd(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the multiset to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", metadata.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.or((Object)this.elementType)).addLine("  %s(element, 1);", BuilderMethods.addCopiesMethod(this.property)).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addVarargsAdd(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the multiset to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s... elements) {", metadata.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.or((Object)this.elementType)).addLine("  for (%s element : elements) {", this.unboxedType.or((Object)this.elementType)).addLine("    %s(element, 1);", BuilderMethods.addCopiesMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addAddAllMethods(SourceBuilder code, Metadata metadata) {
            if (code.feature(SourceLevel.SOURCE_LEVEL).stream().isPresent()) {
                this.addSpliteratorAddAll(code, metadata);
                this.addStreamAddAll(code, metadata);
                this.addIterableAddAll(code, metadata);
            } else {
                this.addPreStreamsAddAll(code, metadata);
            }
        }

        private void addSpliteratorAddAll(SourceBuilder code, Metadata metadata) {
            QualifiedName spliterator = (QualifiedName)code.feature(SourceLevel.SOURCE_LEVEL).spliterator().get();
            this.addJavadocForAddAll(code, metadata);
            code.addLine("public %s %s(%s<? extends %s> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), spliterator, this.elementType).addLine("  elements.forEachRemaining(element -> {", new Object[0]).addLine("    %s(element, 1);", BuilderMethods.addCopiesMethod(this.property)).addLine("  });", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addStreamAddAll(SourceBuilder code, Metadata metadata) {
            QualifiedName baseStream = (QualifiedName)code.feature(SourceLevel.SOURCE_LEVEL).baseStream().get();
            this.addJavadocForAddAll(code, metadata);
            code.addLine("public %s %s(%s<? extends %s, ?> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), baseStream, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
        }

        private void addIterableAddAll(SourceBuilder code, Metadata metadata) {
            this.addJavadocForAddAll(code, metadata);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s<? extends %s> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
        }

        private void addPreStreamsAddAll(SourceBuilder code, Metadata metadata) {
            this.addJavadocForAddAll(code, metadata);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s<? extends %s> elements) {", metadata.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType).addLine("  for (%s element : elements) {", this.unboxedType.or((Object)this.elementType)).addLine("    %s(element, 1);", BuilderMethods.addCopiesMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addJavadocForAddAll(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the multiset to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
        }

        private void addAddCopiesTo(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds a number of occurrences of {@code element} to the multiset to be", new Object[0]).addLine(" * returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" * @throws IllegalArgumentException if {@code occurrences} is negative", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s element, int occurrences) {", metadata.getBuilder(), BuilderMethods.addCopiesMethod(this.property), this.unboxedType.or((Object)this.elementType)).addLine("  %s(element, this.%s.count(element) + occurrences);", BuilderMethods.setCountMethod(this.property), this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addMutate(SourceBuilder code, Metadata metadata) {
            ParameterizedType consumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).consumer().orNull();
            if (consumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the multiset to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the multiset in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", COLLECTION.javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s<%s<%s>> mutator) {", metadata.getBuilder(), BuilderMethods.mutator(this.property), consumer.getQualifiedName(), Multiset.class, this.elementType);
            if (this.overridesSetCountMethod) {
                code.addLine("  mutator.accept(new CheckedMultiset<>(%s, this::%s));", this.property.getName(), BuilderMethods.setCountMethod(this.property));
            } else {
                code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.setCountMethod(this.property)).addLine("  mutator.accept(%s);", this.property.getName());
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addClear(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the multiset to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", metadata.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  this.%s.clear();", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addSetCountOf(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds or removes the necessary occurrences of {@code element} to/from the", new Object[0]).addLine(" * multiset to be returned from %s, such that it attains the", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * desired count.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
            }
            code.addLine(" * @throws IllegalArgumentException if {@code occurrences} is negative", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s element, int occurrences) {", metadata.getBuilder(), BuilderMethods.setCountMethod(this.property), this.unboxedType.or((Object)this.elementType));
            if (!this.unboxedType.isPresent()) {
                code.addLine("  %s.checkNotNull(element);", Preconditions.class, this.property.getName());
            }
            code.addLine("  this.%s.setCount(element, occurrences);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the multiset that will be returned by", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s() {", Multiset.class, this.elementType, BuilderMethods.getter(this.property)).addLine("  return %s.unmodifiableMultiset(%s);", Multisets.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.copyOf(%s.%s);", finalField, ImmutableMultiset.class, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(Block code, String value) {
            code.addLine("%s(%s.%s());", BuilderMethods.addAllMethod(this.property), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(Block code, String builder) {
            code.addLine("%s(((%s) %s).%s);", BuilderMethods.addAllMethod(this.property), this.metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s%s(%s);", builder, BuilderMethods.addAllMethod(this.property), variable);
        }

        @Override
        public void addClearField(Block code) {
            code.addLine("%s.clear();", this.property.getName());
        }

        public Set<StaticExcerpt> getStaticExcerpts() {
            ImmutableSet.Builder staticMethods = ImmutableSet.builder();
            if (this.overridesSetCountMethod) {
                staticMethods.addAll(CheckedMultiset.excerpts());
            }
            return staticMethods.build();
        }
    }
}

